/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = ContentSafetyLabel.Builder.class)
public final class ContentSafetyLabel {
    private final String label;

    private final double confidence;

    private final double severity;

    private final Map<String, Object> additionalProperties;

    private ContentSafetyLabel(
            String label, double confidence, double severity, Map<String, Object> additionalProperties) {
        this.label = label;
        this.confidence = confidence;
        this.severity = severity;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The label of the sensitive topic
     */
    @JsonProperty("label")
    public String getLabel() {
        return label;
    }

    /**
     * @return The confidence score for the topic being discussed, from 0 to 1
     */
    @JsonProperty("confidence")
    public double getConfidence() {
        return confidence;
    }

    /**
     * @return How severely the topic is discussed in the section, from 0 to 1
     */
    @JsonProperty("severity")
    public double getSeverity() {
        return severity;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ContentSafetyLabel && equalTo((ContentSafetyLabel) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContentSafetyLabel other) {
        return label.equals(other.label) && confidence == other.confidence && severity == other.severity;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.label, this.confidence, this.severity);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LabelStage builder() {
        return new Builder();
    }

    public interface LabelStage {
        ConfidenceStage label(String label);

        Builder from(ContentSafetyLabel other);
    }

    public interface ConfidenceStage {
        SeverityStage confidence(double confidence);
    }

    public interface SeverityStage {
        _FinalStage severity(double severity);
    }

    public interface _FinalStage {
        ContentSafetyLabel build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements LabelStage, ConfidenceStage, SeverityStage, _FinalStage {
        private String label;

        private double confidence;

        private double severity;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ContentSafetyLabel other) {
            label(other.getLabel());
            confidence(other.getConfidence());
            severity(other.getSeverity());
            return this;
        }

        /**
         * <p>The label of the sensitive topic</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("label")
        public ConfidenceStage label(String label) {
            this.label = label;
            return this;
        }

        /**
         * <p>The confidence score for the topic being discussed, from 0 to 1</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("confidence")
        public SeverityStage confidence(double confidence) {
            this.confidence = confidence;
            return this;
        }

        /**
         * <p>How severely the topic is discussed in the section, from 0 to 1</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("severity")
        public _FinalStage severity(double severity) {
            this.severity = severity;
            return this;
        }

        @java.lang.Override
        public ContentSafetyLabel build() {
            return new ContentSafetyLabel(label, confidence, severity, additionalProperties);
        }
    }
}
