/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = PageDetails.Builder.class)
public final class PageDetails {
    private final int limit;

    private final int resultCount;

    private final String currentUrl;

    private final Optional<String> prevUrl;

    private final Optional<String> nextUrl;

    private final Map<String, Object> additionalProperties;

    private PageDetails(
            int limit,
            int resultCount,
            String currentUrl,
            Optional<String> prevUrl,
            Optional<String> nextUrl,
            Map<String, Object> additionalProperties) {
        this.limit = limit;
        this.resultCount = resultCount;
        this.currentUrl = currentUrl;
        this.prevUrl = prevUrl;
        this.nextUrl = nextUrl;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("limit")
    public int getLimit() {
        return limit;
    }

    @JsonProperty("result_count")
    public int getResultCount() {
        return resultCount;
    }

    @JsonProperty("current_url")
    public String getCurrentUrl() {
        return currentUrl;
    }

    /**
     * @return The URL to the next page of transcripts. The previous URL always points to a page with older transcripts.
     */
    @JsonProperty("prev_url")
    public Optional<String> getPrevUrl() {
        return prevUrl;
    }

    /**
     * @return The URL to the next page of transcripts. The next URL always points to a page with newer transcripts.
     */
    @JsonProperty("next_url")
    public Optional<String> getNextUrl() {
        return nextUrl;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PageDetails && equalTo((PageDetails) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PageDetails other) {
        return limit == other.limit
                && resultCount == other.resultCount
                && currentUrl.equals(other.currentUrl)
                && prevUrl.equals(other.prevUrl)
                && nextUrl.equals(other.nextUrl);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.limit, this.resultCount, this.currentUrl, this.prevUrl, this.nextUrl);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LimitStage builder() {
        return new Builder();
    }

    public interface LimitStage {
        ResultCountStage limit(int limit);

        Builder from(PageDetails other);
    }

    public interface ResultCountStage {
        CurrentUrlStage resultCount(int resultCount);
    }

    public interface CurrentUrlStage {
        _FinalStage currentUrl(String currentUrl);
    }

    public interface _FinalStage {
        PageDetails build();

        _FinalStage prevUrl(Optional<String> prevUrl);

        _FinalStage prevUrl(String prevUrl);

        _FinalStage nextUrl(Optional<String> nextUrl);

        _FinalStage nextUrl(String nextUrl);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements LimitStage, ResultCountStage, CurrentUrlStage, _FinalStage {
        private int limit;

        private int resultCount;

        private String currentUrl;

        private Optional<String> nextUrl = Optional.empty();

        private Optional<String> prevUrl = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(PageDetails other) {
            limit(other.getLimit());
            resultCount(other.getResultCount());
            currentUrl(other.getCurrentUrl());
            prevUrl(other.getPrevUrl());
            nextUrl(other.getNextUrl());
            return this;
        }

        @java.lang.Override
        @JsonSetter("limit")
        public ResultCountStage limit(int limit) {
            this.limit = limit;
            return this;
        }

        @java.lang.Override
        @JsonSetter("result_count")
        public CurrentUrlStage resultCount(int resultCount) {
            this.resultCount = resultCount;
            return this;
        }

        @java.lang.Override
        @JsonSetter("current_url")
        public _FinalStage currentUrl(String currentUrl) {
            this.currentUrl = currentUrl;
            return this;
        }

        /**
         * <p>The URL to the next page of transcripts. The next URL always points to a page with newer transcripts.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage nextUrl(String nextUrl) {
            this.nextUrl = Optional.of(nextUrl);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "next_url", nulls = Nulls.SKIP)
        public _FinalStage nextUrl(Optional<String> nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        /**
         * <p>The URL to the next page of transcripts. The previous URL always points to a page with older transcripts.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage prevUrl(String prevUrl) {
            this.prevUrl = Optional.of(prevUrl);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "prev_url", nulls = Nulls.SKIP)
        public _FinalStage prevUrl(Optional<String> prevUrl) {
            this.prevUrl = prevUrl;
            return this;
        }

        @java.lang.Override
        public PageDetails build() {
            return new PageDetails(limit, resultCount, currentUrl, prevUrl, nextUrl, additionalProperties);
        }
    }
}
