/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class Sentiment {
    public static final Sentiment NEUTRAL = new Sentiment(Value.NEUTRAL, "NEUTRAL");

    public static final Sentiment NEGATIVE = new Sentiment(Value.NEGATIVE, "NEGATIVE");

    public static final Sentiment POSITIVE = new Sentiment(Value.POSITIVE, "POSITIVE");

    private final Value value;

    private final String string;

    Sentiment(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return value;
    }

    @java.lang.Override
    @JsonValue
    public String toString() {
        return this.string;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        return (this == other) || (other instanceof Sentiment && this.string.equals(((Sentiment) other).string));
    }

    @java.lang.Override
    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (value) {
            case NEUTRAL:
                return visitor.visitNeutral();
            case NEGATIVE:
                return visitor.visitNegative();
            case POSITIVE:
                return visitor.visitPositive();
            case UNKNOWN:
            default:
                return visitor.visitUnknown(string);
        }
    }

    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    public static Sentiment valueOf(String value) {
        switch (value) {
            case "NEUTRAL":
                return NEUTRAL;
            case "NEGATIVE":
                return NEGATIVE;
            case "POSITIVE":
                return POSITIVE;
            default:
                return new Sentiment(Value.UNKNOWN, value);
        }
    }

    public enum Value {
        POSITIVE,

        NEUTRAL,

        NEGATIVE,

        UNKNOWN
    }

    public interface Visitor<T> {
        T visitPositive();

        T visitNeutral();

        T visitNegative();

        T visitUnknown(String unknownType);
    }
}
