/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = Transcript.Builder.class)
public final class Transcript {
    private final String id;

    private final Optional<SpeechModel> speechModel;

    private final String languageModel;

    private final String acousticModel;

    private final TranscriptStatus status;

    private final Optional<TranscriptLanguageCode> languageCode;

    private final String audioUrl;

    private final Optional<String> text;

    private final Optional<List<TranscriptWord>> words;

    private final Optional<List<TranscriptUtterance>> utterances;

    private final Optional<Double> confidence;

    private final Optional<Double> audioDuration;

    private final Optional<Boolean> punctuate;

    private final Optional<Boolean> formatText;

    private final Optional<Boolean> dualChannel;

    private final Optional<String> webhookUrl;

    private final Optional<Integer> webhookStatusCode;

    private final boolean webhookAuth;

    private final Optional<String> webhookAuthHeaderName;

    private final Optional<Boolean> speedBoost;

    private final boolean autoHighlights;

    private final Optional<AutoHighlightsResult> autoHighlightsResult;

    private final Optional<Integer> audioStartFrom;

    private final Optional<Integer> audioEndAt;

    private final Optional<List<String>> wordBoost;

    private final Optional<String> boostParam;

    private final Optional<Boolean> filterProfanity;

    private final boolean redactPii;

    private final Optional<Boolean> redactPiiAudio;

    private final Optional<RedactPiiAudioQuality> redactPiiAudioQuality;

    private final Optional<List<PiiPolicy>> redactPiiPolicies;

    private final Optional<SubstitutionPolicy> redactPiiSub;

    private final Optional<Boolean> speakerLabels;

    private final Optional<Integer> speakersExpected;

    private final Optional<Boolean> contentSafety;

    private final Optional<ContentSafetyLabelsResult> contentSafetyLabels;

    private final Optional<Boolean> iabCategories;

    private final Optional<TopicDetectionModelResult> iabCategoriesResult;

    private final Optional<Boolean> languageDetection;

    private final Optional<List<TranscriptCustomSpelling>> customSpelling;

    private final Optional<Boolean> autoChapters;

    private final Optional<List<Chapter>> chapters;

    private final boolean summarization;

    private final Optional<String> summaryType;

    private final Optional<String> summaryModel;

    private final Optional<String> summary;

    private final Optional<Boolean> customTopics;

    private final Optional<List<String>> topics;

    private final Optional<Boolean> disfluencies;

    private final Optional<Boolean> sentimentAnalysis;

    private final Optional<List<SentimentAnalysisResult>> sentimentAnalysisResults;

    private final Optional<Boolean> entityDetection;

    private final Optional<List<Entity>> entities;

    private final Optional<Double> speechThreshold;

    private final Optional<Boolean> throttled;

    private final Optional<String> error;

    private final Map<String, Object> additionalProperties;

    private Transcript(
            String id,
            Optional<SpeechModel> speechModel,
            String languageModel,
            String acousticModel,
            TranscriptStatus status,
            Optional<TranscriptLanguageCode> languageCode,
            String audioUrl,
            Optional<String> text,
            Optional<List<TranscriptWord>> words,
            Optional<List<TranscriptUtterance>> utterances,
            Optional<Double> confidence,
            Optional<Double> audioDuration,
            Optional<Boolean> punctuate,
            Optional<Boolean> formatText,
            Optional<Boolean> dualChannel,
            Optional<String> webhookUrl,
            Optional<Integer> webhookStatusCode,
            boolean webhookAuth,
            Optional<String> webhookAuthHeaderName,
            Optional<Boolean> speedBoost,
            boolean autoHighlights,
            Optional<AutoHighlightsResult> autoHighlightsResult,
            Optional<Integer> audioStartFrom,
            Optional<Integer> audioEndAt,
            Optional<List<String>> wordBoost,
            Optional<String> boostParam,
            Optional<Boolean> filterProfanity,
            boolean redactPii,
            Optional<Boolean> redactPiiAudio,
            Optional<RedactPiiAudioQuality> redactPiiAudioQuality,
            Optional<List<PiiPolicy>> redactPiiPolicies,
            Optional<SubstitutionPolicy> redactPiiSub,
            Optional<Boolean> speakerLabels,
            Optional<Integer> speakersExpected,
            Optional<Boolean> contentSafety,
            Optional<ContentSafetyLabelsResult> contentSafetyLabels,
            Optional<Boolean> iabCategories,
            Optional<TopicDetectionModelResult> iabCategoriesResult,
            Optional<Boolean> languageDetection,
            Optional<List<TranscriptCustomSpelling>> customSpelling,
            Optional<Boolean> autoChapters,
            Optional<List<Chapter>> chapters,
            boolean summarization,
            Optional<String> summaryType,
            Optional<String> summaryModel,
            Optional<String> summary,
            Optional<Boolean> customTopics,
            Optional<List<String>> topics,
            Optional<Boolean> disfluencies,
            Optional<Boolean> sentimentAnalysis,
            Optional<List<SentimentAnalysisResult>> sentimentAnalysisResults,
            Optional<Boolean> entityDetection,
            Optional<List<Entity>> entities,
            Optional<Double> speechThreshold,
            Optional<Boolean> throttled,
            Optional<String> error,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.speechModel = speechModel;
        this.languageModel = languageModel;
        this.acousticModel = acousticModel;
        this.status = status;
        this.languageCode = languageCode;
        this.audioUrl = audioUrl;
        this.text = text;
        this.words = words;
        this.utterances = utterances;
        this.confidence = confidence;
        this.audioDuration = audioDuration;
        this.punctuate = punctuate;
        this.formatText = formatText;
        this.dualChannel = dualChannel;
        this.webhookUrl = webhookUrl;
        this.webhookStatusCode = webhookStatusCode;
        this.webhookAuth = webhookAuth;
        this.webhookAuthHeaderName = webhookAuthHeaderName;
        this.speedBoost = speedBoost;
        this.autoHighlights = autoHighlights;
        this.autoHighlightsResult = autoHighlightsResult;
        this.audioStartFrom = audioStartFrom;
        this.audioEndAt = audioEndAt;
        this.wordBoost = wordBoost;
        this.boostParam = boostParam;
        this.filterProfanity = filterProfanity;
        this.redactPii = redactPii;
        this.redactPiiAudio = redactPiiAudio;
        this.redactPiiAudioQuality = redactPiiAudioQuality;
        this.redactPiiPolicies = redactPiiPolicies;
        this.redactPiiSub = redactPiiSub;
        this.speakerLabels = speakerLabels;
        this.speakersExpected = speakersExpected;
        this.contentSafety = contentSafety;
        this.contentSafetyLabels = contentSafetyLabels;
        this.iabCategories = iabCategories;
        this.iabCategoriesResult = iabCategoriesResult;
        this.languageDetection = languageDetection;
        this.customSpelling = customSpelling;
        this.autoChapters = autoChapters;
        this.chapters = chapters;
        this.summarization = summarization;
        this.summaryType = summaryType;
        this.summaryModel = summaryModel;
        this.summary = summary;
        this.customTopics = customTopics;
        this.topics = topics;
        this.disfluencies = disfluencies;
        this.sentimentAnalysis = sentimentAnalysis;
        this.sentimentAnalysisResults = sentimentAnalysisResults;
        this.entityDetection = entityDetection;
        this.entities = entities;
        this.speechThreshold = speechThreshold;
        this.throttled = throttled;
        this.error = error;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier of your transcript
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("speech_model")
    public Optional<SpeechModel> getSpeechModel() {
        return speechModel;
    }

    /**
     * @return The language model that was used for the transcript
     */
    @JsonProperty("language_model")
    public String getLanguageModel() {
        return languageModel;
    }

    /**
     * @return The acoustic model that was used for the transcript
     */
    @JsonProperty("acoustic_model")
    public String getAcousticModel() {
        return acousticModel;
    }

    /**
     * @return The status of your transcript. Possible values are queued, processing, completed, or error.
     */
    @JsonProperty("status")
    public TranscriptStatus getStatus() {
        return status;
    }

    /**
     * @return The language of your audio file.
     * Possible values are found in <a href="https://www.assemblyai.com/docs/concepts/supported-languages">Supported Languages</a>.
     * The default value is 'en_us'.
     */
    @JsonProperty("language_code")
    public Optional<TranscriptLanguageCode> getLanguageCode() {
        return languageCode;
    }

    /**
     * @return The URL of the media that was transcribed
     */
    @JsonProperty("audio_url")
    public String getAudioUrl() {
        return audioUrl;
    }

    /**
     * @return The textual transcript of your media file
     */
    @JsonProperty("text")
    public Optional<String> getText() {
        return text;
    }

    /**
     * @return An array of temporally-sequential word objects, one for each word in the transcript.
     * See <a href="https://www.assemblyai.com/docs/models/speech-recognition">Speech recognition</a> for more information.
     */
    @JsonProperty("words")
    public Optional<List<TranscriptWord>> getWords() {
        return words;
    }

    /**
     * @return When dual_channel or speaker_labels is enabled, a list of turn-by-turn utterance objects.
     * See <a href="https://www.assemblyai.com/docs/models/speaker-diarization">Speaker diarization</a> for more information.
     */
    @JsonProperty("utterances")
    public Optional<List<TranscriptUtterance>> getUtterances() {
        return utterances;
    }

    /**
     * @return The confidence score for the transcript, between 0.0 (low confidence) and 1.0 (high confidence)
     */
    @JsonProperty("confidence")
    public Optional<Double> getConfidence() {
        return confidence;
    }

    /**
     * @return The duration of this transcript object's media file, in seconds
     */
    @JsonProperty("audio_duration")
    public Optional<Double> getAudioDuration() {
        return audioDuration;
    }

    /**
     * @return Whether Automatic Punctuation is enabled, either true or false
     */
    @JsonProperty("punctuate")
    public Optional<Boolean> getPunctuate() {
        return punctuate;
    }

    /**
     * @return Whether Text Formatting is enabled, either true or false
     */
    @JsonProperty("format_text")
    public Optional<Boolean> getFormatText() {
        return formatText;
    }

    /**
     * @return Whether <a href="https://www.assemblyai.com/docs/models/speech-recognition#dual-channel-transcription">Dual channel transcription</a> was enabled in the transcription request, either true or false
     */
    @JsonProperty("dual_channel")
    public Optional<Boolean> getDualChannel() {
        return dualChannel;
    }

    /**
     * @return The URL to which we send webhooks upon trancription completion
     */
    @JsonProperty("webhook_url")
    public Optional<String> getWebhookUrl() {
        return webhookUrl;
    }

    /**
     * @return The status code we received from your server when delivering your webhook, if a webhook URL was provided
     */
    @JsonProperty("webhook_status_code")
    public Optional<Integer> getWebhookStatusCode() {
        return webhookStatusCode;
    }

    /**
     * @return Whether webhook authentication details were provided
     */
    @JsonProperty("webhook_auth")
    public boolean getWebhookAuth() {
        return webhookAuth;
    }

    /**
     * @return The header name which should be sent back with webhook calls
     */
    @JsonProperty("webhook_auth_header_name")
    public Optional<String> getWebhookAuthHeaderName() {
        return webhookAuthHeaderName;
    }

    /**
     * @return Whether speed boost is enabled
     */
    @JsonProperty("speed_boost")
    public Optional<Boolean> getSpeedBoost() {
        return speedBoost;
    }

    /**
     * @return Whether Key Phrases is enabled, either true or false
     */
    @JsonProperty("auto_highlights")
    public boolean getAutoHighlights() {
        return autoHighlights;
    }

    @JsonProperty("auto_highlights_result")
    public Optional<AutoHighlightsResult> getAutoHighlightsResult() {
        return autoHighlightsResult;
    }

    /**
     * @return The point in time, in milliseconds, in the file at which the transcription was started
     */
    @JsonProperty("audio_start_from")
    public Optional<Integer> getAudioStartFrom() {
        return audioStartFrom;
    }

    /**
     * @return The point in time, in milliseconds, in the file at which the transcription was terminated
     */
    @JsonProperty("audio_end_at")
    public Optional<Integer> getAudioEndAt() {
        return audioEndAt;
    }

    /**
     * @return The list of custom vocabulary to boost transcription probability for
     */
    @JsonProperty("word_boost")
    public Optional<List<String>> getWordBoost() {
        return wordBoost;
    }

    /**
     * @return The word boost parameter value
     */
    @JsonProperty("boost_param")
    public Optional<String> getBoostParam() {
        return boostParam;
    }

    /**
     * @return Whether <a href="https://www.assemblyai.com/docs/models/speech-recognition#profanity-filtering">Profanity Filtering</a> is enabled, either true or false
     */
    @JsonProperty("filter_profanity")
    public Optional<Boolean> getFilterProfanity() {
        return filterProfanity;
    }

    /**
     * @return Whether <a href="https://www.assemblyai.com/docs/models/pii-redaction">PII Redaction</a> is enabled, either true or false
     */
    @JsonProperty("redact_pii")
    public boolean getRedactPii() {
        return redactPii;
    }

    /**
     * @return Whether a redacted version of the audio file was generated,
     * either true or false. See <a href="https://www.assemblyai.com/docs/models/pii-redaction">PII redaction</a> for more information.
     */
    @JsonProperty("redact_pii_audio")
    public Optional<Boolean> getRedactPiiAudio() {
        return redactPiiAudio;
    }

    @JsonProperty("redact_pii_audio_quality")
    public Optional<RedactPiiAudioQuality> getRedactPiiAudioQuality() {
        return redactPiiAudioQuality;
    }

    /**
     * @return The list of PII Redaction policies that were enabled, if PII Redaction is enabled.
     * See <a href="https://www.assemblyai.com/docs/models/pii-redaction">PII redaction</a> for more information.
     */
    @JsonProperty("redact_pii_policies")
    public Optional<List<PiiPolicy>> getRedactPiiPolicies() {
        return redactPiiPolicies;
    }

    /**
     * @return The replacement logic for detected PII, can be &quot;entity_type&quot; or &quot;hash&quot;. See <a href="https://www.assemblyai.com/docs/models/pii-redaction">PII redaction</a> for more details.
     */
    @JsonProperty("redact_pii_sub")
    public Optional<SubstitutionPolicy> getRedactPiiSub() {
        return redactPiiSub;
    }

    /**
     * @return Whether <a href="https://www.assemblyai.com/docs/models/speaker-diarization">Speaker diarization</a> is enabled, can be true or false
     */
    @JsonProperty("speaker_labels")
    public Optional<Boolean> getSpeakerLabels() {
        return speakerLabels;
    }

    /**
     * @return Tell the speaker label model how many speakers it should attempt to identify, up to 10. See <a href="https://www.assemblyai.com/docs/models/speaker-diarization">Speaker diarization</a> for more details.
     */
    @JsonProperty("speakers_expected")
    public Optional<Integer> getSpeakersExpected() {
        return speakersExpected;
    }

    /**
     * @return Whether <a href="https://www.assemblyai.com/docs/models/content-moderation">Content Moderation</a> is enabled, can be true or false
     */
    @JsonProperty("content_safety")
    public Optional<Boolean> getContentSafety() {
        return contentSafety;
    }

    @JsonProperty("content_safety_labels")
    public Optional<ContentSafetyLabelsResult> getContentSafetyLabels() {
        return contentSafetyLabels;
    }

    /**
     * @return Whether <a href="https://www.assemblyai.com/docs/models/topic-detection">Topic Detection</a> is enabled, can be true or false
     */
    @JsonProperty("iab_categories")
    public Optional<Boolean> getIabCategories() {
        return iabCategories;
    }

    @JsonProperty("iab_categories_result")
    public Optional<TopicDetectionModelResult> getIabCategoriesResult() {
        return iabCategoriesResult;
    }

    /**
     * @return Whether <a href="https://www.assemblyai.com/docs/models/speech-recognition#automatic-language-detection">Automatic language detection</a> is enabled, either true or false
     */
    @JsonProperty("language_detection")
    public Optional<Boolean> getLanguageDetection() {
        return languageDetection;
    }

    /**
     * @return Customize how words are spelled and formatted using to and from values
     */
    @JsonProperty("custom_spelling")
    public Optional<List<TranscriptCustomSpelling>> getCustomSpelling() {
        return customSpelling;
    }

    /**
     * @return Whether <a href="https://www.assemblyai.com/docs/models/auto-chapters">Auto Chapters</a> is enabled, can be true or false
     */
    @JsonProperty("auto_chapters")
    public Optional<Boolean> getAutoChapters() {
        return autoChapters;
    }

    /**
     * @return An array of temporally sequential chapters for the audio file
     */
    @JsonProperty("chapters")
    public Optional<List<Chapter>> getChapters() {
        return chapters;
    }

    /**
     * @return Whether <a href="https://www.assemblyai.com/docs/models/summarization">Summarization</a> is enabled, either true or false
     */
    @JsonProperty("summarization")
    public boolean getSummarization() {
        return summarization;
    }

    /**
     * @return The type of summary generated, if <a href="https://www.assemblyai.com/docs/models/summarization">Summarization</a> is enabled
     */
    @JsonProperty("summary_type")
    public Optional<String> getSummaryType() {
        return summaryType;
    }

    /**
     * @return The Summarization model used to generate the summary,
     * if <a href="https://www.assemblyai.com/docs/models/summarization">Summarization</a> is enabled
     */
    @JsonProperty("summary_model")
    public Optional<String> getSummaryModel() {
        return summaryModel;
    }

    /**
     * @return The generated summary of the media file, if <a href="https://www.assemblyai.com/docs/models/summarization">Summarization</a> is enabled
     */
    @JsonProperty("summary")
    public Optional<String> getSummary() {
        return summary;
    }

    /**
     * @return Whether custom topics is enabled, either true or false
     */
    @JsonProperty("custom_topics")
    public Optional<Boolean> getCustomTopics() {
        return customTopics;
    }

    /**
     * @return The list of custom topics provided if custom topics is enabled
     */
    @JsonProperty("topics")
    public Optional<List<String>> getTopics() {
        return topics;
    }

    /**
     * @return Transcribe Filler Words, like &quot;umm&quot;, in your media file; can be true or false
     */
    @JsonProperty("disfluencies")
    public Optional<Boolean> getDisfluencies() {
        return disfluencies;
    }

    /**
     * @return Whether <a href="https://www.assemblyai.com/docs/models/sentiment-analysis">Sentiment Analysis</a> is enabled, can be true or false
     */
    @JsonProperty("sentiment_analysis")
    public Optional<Boolean> getSentimentAnalysis() {
        return sentimentAnalysis;
    }

    /**
     * @return An array of results for the Sentiment Analysis model, if it is enabled.
     * See <a href="https://www.assemblyai.com/docs/models/sentiment-analysis">Sentiment analysis</a> for more information.
     */
    @JsonProperty("sentiment_analysis_results")
    public Optional<List<SentimentAnalysisResult>> getSentimentAnalysisResults() {
        return sentimentAnalysisResults;
    }

    /**
     * @return Whether <a href="https://www.assemblyai.com/docs/models/entity-detection">Entity Detection</a> is enabled, can be true or false
     */
    @JsonProperty("entity_detection")
    public Optional<Boolean> getEntityDetection() {
        return entityDetection;
    }

    /**
     * @return An array of results for the Entity Detection model, if it is enabled.
     * See <a href="https://www.assemblyai.com/docs/models/entity-detection">Entity detection</a> for more information.
     */
    @JsonProperty("entities")
    public Optional<List<Entity>> getEntities() {
        return entities;
    }

    /**
     * @return Defaults to null. Reject audio files that contain less than this fraction of speech.
     * Valid values are in the range [0, 1] inclusive.
     */
    @JsonProperty("speech_threshold")
    public Optional<Double> getSpeechThreshold() {
        return speechThreshold;
    }

    /**
     * @return True while a request is throttled and false when a request is no longer throttled
     */
    @JsonProperty("throttled")
    public Optional<Boolean> getThrottled() {
        return throttled;
    }

    /**
     * @return Error message of why the transcript failed
     */
    @JsonProperty("error")
    public Optional<String> getError() {
        return error;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Transcript && equalTo((Transcript) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Transcript other) {
        return id.equals(other.id)
                && speechModel.equals(other.speechModel)
                && languageModel.equals(other.languageModel)
                && acousticModel.equals(other.acousticModel)
                && status.equals(other.status)
                && languageCode.equals(other.languageCode)
                && audioUrl.equals(other.audioUrl)
                && text.equals(other.text)
                && words.equals(other.words)
                && utterances.equals(other.utterances)
                && confidence.equals(other.confidence)
                && audioDuration.equals(other.audioDuration)
                && punctuate.equals(other.punctuate)
                && formatText.equals(other.formatText)
                && dualChannel.equals(other.dualChannel)
                && webhookUrl.equals(other.webhookUrl)
                && webhookStatusCode.equals(other.webhookStatusCode)
                && webhookAuth == other.webhookAuth
                && webhookAuthHeaderName.equals(other.webhookAuthHeaderName)
                && speedBoost.equals(other.speedBoost)
                && autoHighlights == other.autoHighlights
                && autoHighlightsResult.equals(other.autoHighlightsResult)
                && audioStartFrom.equals(other.audioStartFrom)
                && audioEndAt.equals(other.audioEndAt)
                && wordBoost.equals(other.wordBoost)
                && boostParam.equals(other.boostParam)
                && filterProfanity.equals(other.filterProfanity)
                && redactPii == other.redactPii
                && redactPiiAudio.equals(other.redactPiiAudio)
                && redactPiiAudioQuality.equals(other.redactPiiAudioQuality)
                && redactPiiPolicies.equals(other.redactPiiPolicies)
                && redactPiiSub.equals(other.redactPiiSub)
                && speakerLabels.equals(other.speakerLabels)
                && speakersExpected.equals(other.speakersExpected)
                && contentSafety.equals(other.contentSafety)
                && contentSafetyLabels.equals(other.contentSafetyLabels)
                && iabCategories.equals(other.iabCategories)
                && iabCategoriesResult.equals(other.iabCategoriesResult)
                && languageDetection.equals(other.languageDetection)
                && customSpelling.equals(other.customSpelling)
                && autoChapters.equals(other.autoChapters)
                && chapters.equals(other.chapters)
                && summarization == other.summarization
                && summaryType.equals(other.summaryType)
                && summaryModel.equals(other.summaryModel)
                && summary.equals(other.summary)
                && customTopics.equals(other.customTopics)
                && topics.equals(other.topics)
                && disfluencies.equals(other.disfluencies)
                && sentimentAnalysis.equals(other.sentimentAnalysis)
                && sentimentAnalysisResults.equals(other.sentimentAnalysisResults)
                && entityDetection.equals(other.entityDetection)
                && entities.equals(other.entities)
                && speechThreshold.equals(other.speechThreshold)
                && throttled.equals(other.throttled)
                && error.equals(other.error);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id,
                this.speechModel,
                this.languageModel,
                this.acousticModel,
                this.status,
                this.languageCode,
                this.audioUrl,
                this.text,
                this.words,
                this.utterances,
                this.confidence,
                this.audioDuration,
                this.punctuate,
                this.formatText,
                this.dualChannel,
                this.webhookUrl,
                this.webhookStatusCode,
                this.webhookAuth,
                this.webhookAuthHeaderName,
                this.speedBoost,
                this.autoHighlights,
                this.autoHighlightsResult,
                this.audioStartFrom,
                this.audioEndAt,
                this.wordBoost,
                this.boostParam,
                this.filterProfanity,
                this.redactPii,
                this.redactPiiAudio,
                this.redactPiiAudioQuality,
                this.redactPiiPolicies,
                this.redactPiiSub,
                this.speakerLabels,
                this.speakersExpected,
                this.contentSafety,
                this.contentSafetyLabels,
                this.iabCategories,
                this.iabCategoriesResult,
                this.languageDetection,
                this.customSpelling,
                this.autoChapters,
                this.chapters,
                this.summarization,
                this.summaryType,
                this.summaryModel,
                this.summary,
                this.customTopics,
                this.topics,
                this.disfluencies,
                this.sentimentAnalysis,
                this.sentimentAnalysisResults,
                this.entityDetection,
                this.entities,
                this.speechThreshold,
                this.throttled,
                this.error);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        LanguageModelStage id(String id);

        Builder from(Transcript other);
    }

    public interface LanguageModelStage {
        AcousticModelStage languageModel(String languageModel);
    }

    public interface AcousticModelStage {
        StatusStage acousticModel(String acousticModel);
    }

    public interface StatusStage {
        AudioUrlStage status(TranscriptStatus status);
    }

    public interface AudioUrlStage {
        WebhookAuthStage audioUrl(String audioUrl);
    }

    public interface WebhookAuthStage {
        AutoHighlightsStage webhookAuth(boolean webhookAuth);
    }

    public interface AutoHighlightsStage {
        RedactPiiStage autoHighlights(boolean autoHighlights);
    }

    public interface RedactPiiStage {
        SummarizationStage redactPii(boolean redactPii);
    }

    public interface SummarizationStage {
        _FinalStage summarization(boolean summarization);
    }

    public interface _FinalStage {
        Transcript build();

        _FinalStage speechModel(Optional<SpeechModel> speechModel);

        _FinalStage speechModel(SpeechModel speechModel);

        _FinalStage languageCode(Optional<TranscriptLanguageCode> languageCode);

        _FinalStage languageCode(TranscriptLanguageCode languageCode);

        _FinalStage text(Optional<String> text);

        _FinalStage text(String text);

        _FinalStage words(Optional<List<TranscriptWord>> words);

        _FinalStage words(List<TranscriptWord> words);

        _FinalStage utterances(Optional<List<TranscriptUtterance>> utterances);

        _FinalStage utterances(List<TranscriptUtterance> utterances);

        _FinalStage confidence(Optional<Double> confidence);

        _FinalStage confidence(Double confidence);

        _FinalStage audioDuration(Optional<Double> audioDuration);

        _FinalStage audioDuration(Double audioDuration);

        _FinalStage punctuate(Optional<Boolean> punctuate);

        _FinalStage punctuate(Boolean punctuate);

        _FinalStage formatText(Optional<Boolean> formatText);

        _FinalStage formatText(Boolean formatText);

        _FinalStage dualChannel(Optional<Boolean> dualChannel);

        _FinalStage dualChannel(Boolean dualChannel);

        _FinalStage webhookUrl(Optional<String> webhookUrl);

        _FinalStage webhookUrl(String webhookUrl);

        _FinalStage webhookStatusCode(Optional<Integer> webhookStatusCode);

        _FinalStage webhookStatusCode(Integer webhookStatusCode);

        _FinalStage webhookAuthHeaderName(Optional<String> webhookAuthHeaderName);

        _FinalStage webhookAuthHeaderName(String webhookAuthHeaderName);

        _FinalStage speedBoost(Optional<Boolean> speedBoost);

        _FinalStage speedBoost(Boolean speedBoost);

        _FinalStage autoHighlightsResult(Optional<AutoHighlightsResult> autoHighlightsResult);

        _FinalStage autoHighlightsResult(AutoHighlightsResult autoHighlightsResult);

        _FinalStage audioStartFrom(Optional<Integer> audioStartFrom);

        _FinalStage audioStartFrom(Integer audioStartFrom);

        _FinalStage audioEndAt(Optional<Integer> audioEndAt);

        _FinalStage audioEndAt(Integer audioEndAt);

        _FinalStage wordBoost(Optional<List<String>> wordBoost);

        _FinalStage wordBoost(List<String> wordBoost);

        _FinalStage boostParam(Optional<String> boostParam);

        _FinalStage boostParam(String boostParam);

        _FinalStage filterProfanity(Optional<Boolean> filterProfanity);

        _FinalStage filterProfanity(Boolean filterProfanity);

        _FinalStage redactPiiAudio(Optional<Boolean> redactPiiAudio);

        _FinalStage redactPiiAudio(Boolean redactPiiAudio);

        _FinalStage redactPiiAudioQuality(Optional<RedactPiiAudioQuality> redactPiiAudioQuality);

        _FinalStage redactPiiAudioQuality(RedactPiiAudioQuality redactPiiAudioQuality);

        _FinalStage redactPiiPolicies(Optional<List<PiiPolicy>> redactPiiPolicies);

        _FinalStage redactPiiPolicies(List<PiiPolicy> redactPiiPolicies);

        _FinalStage redactPiiSub(Optional<SubstitutionPolicy> redactPiiSub);

        _FinalStage redactPiiSub(SubstitutionPolicy redactPiiSub);

        _FinalStage speakerLabels(Optional<Boolean> speakerLabels);

        _FinalStage speakerLabels(Boolean speakerLabels);

        _FinalStage speakersExpected(Optional<Integer> speakersExpected);

        _FinalStage speakersExpected(Integer speakersExpected);

        _FinalStage contentSafety(Optional<Boolean> contentSafety);

        _FinalStage contentSafety(Boolean contentSafety);

        _FinalStage contentSafetyLabels(Optional<ContentSafetyLabelsResult> contentSafetyLabels);

        _FinalStage contentSafetyLabels(ContentSafetyLabelsResult contentSafetyLabels);

        _FinalStage iabCategories(Optional<Boolean> iabCategories);

        _FinalStage iabCategories(Boolean iabCategories);

        _FinalStage iabCategoriesResult(Optional<TopicDetectionModelResult> iabCategoriesResult);

        _FinalStage iabCategoriesResult(TopicDetectionModelResult iabCategoriesResult);

        _FinalStage languageDetection(Optional<Boolean> languageDetection);

        _FinalStage languageDetection(Boolean languageDetection);

        _FinalStage customSpelling(Optional<List<TranscriptCustomSpelling>> customSpelling);

        _FinalStage customSpelling(List<TranscriptCustomSpelling> customSpelling);

        _FinalStage autoChapters(Optional<Boolean> autoChapters);

        _FinalStage autoChapters(Boolean autoChapters);

        _FinalStage chapters(Optional<List<Chapter>> chapters);

        _FinalStage chapters(List<Chapter> chapters);

        _FinalStage summaryType(Optional<String> summaryType);

        _FinalStage summaryType(String summaryType);

        _FinalStage summaryModel(Optional<String> summaryModel);

        _FinalStage summaryModel(String summaryModel);

        _FinalStage summary(Optional<String> summary);

        _FinalStage summary(String summary);

        _FinalStage customTopics(Optional<Boolean> customTopics);

        _FinalStage customTopics(Boolean customTopics);

        _FinalStage topics(Optional<List<String>> topics);

        _FinalStage topics(List<String> topics);

        _FinalStage disfluencies(Optional<Boolean> disfluencies);

        _FinalStage disfluencies(Boolean disfluencies);

        _FinalStage sentimentAnalysis(Optional<Boolean> sentimentAnalysis);

        _FinalStage sentimentAnalysis(Boolean sentimentAnalysis);

        _FinalStage sentimentAnalysisResults(Optional<List<SentimentAnalysisResult>> sentimentAnalysisResults);

        _FinalStage sentimentAnalysisResults(List<SentimentAnalysisResult> sentimentAnalysisResults);

        _FinalStage entityDetection(Optional<Boolean> entityDetection);

        _FinalStage entityDetection(Boolean entityDetection);

        _FinalStage entities(Optional<List<Entity>> entities);

        _FinalStage entities(List<Entity> entities);

        _FinalStage speechThreshold(Optional<Double> speechThreshold);

        _FinalStage speechThreshold(Double speechThreshold);

        _FinalStage throttled(Optional<Boolean> throttled);

        _FinalStage throttled(Boolean throttled);

        _FinalStage error(Optional<String> error);

        _FinalStage error(String error);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements IdStage,
                    LanguageModelStage,
                    AcousticModelStage,
                    StatusStage,
                    AudioUrlStage,
                    WebhookAuthStage,
                    AutoHighlightsStage,
                    RedactPiiStage,
                    SummarizationStage,
                    _FinalStage {
        private String id;

        private String languageModel;

        private String acousticModel;

        private TranscriptStatus status;

        private String audioUrl;

        private boolean webhookAuth;

        private boolean autoHighlights;

        private boolean redactPii;

        private boolean summarization;

        private Optional<String> error = Optional.empty();

        private Optional<Boolean> throttled = Optional.empty();

        private Optional<Double> speechThreshold = Optional.empty();

        private Optional<List<Entity>> entities = Optional.empty();

        private Optional<Boolean> entityDetection = Optional.empty();

        private Optional<List<SentimentAnalysisResult>> sentimentAnalysisResults = Optional.empty();

        private Optional<Boolean> sentimentAnalysis = Optional.empty();

        private Optional<Boolean> disfluencies = Optional.empty();

        private Optional<List<String>> topics = Optional.empty();

        private Optional<Boolean> customTopics = Optional.empty();

        private Optional<String> summary = Optional.empty();

        private Optional<String> summaryModel = Optional.empty();

        private Optional<String> summaryType = Optional.empty();

        private Optional<List<Chapter>> chapters = Optional.empty();

        private Optional<Boolean> autoChapters = Optional.empty();

        private Optional<List<TranscriptCustomSpelling>> customSpelling = Optional.empty();

        private Optional<Boolean> languageDetection = Optional.empty();

        private Optional<TopicDetectionModelResult> iabCategoriesResult = Optional.empty();

        private Optional<Boolean> iabCategories = Optional.empty();

        private Optional<ContentSafetyLabelsResult> contentSafetyLabels = Optional.empty();

        private Optional<Boolean> contentSafety = Optional.empty();

        private Optional<Integer> speakersExpected = Optional.empty();

        private Optional<Boolean> speakerLabels = Optional.empty();

        private Optional<SubstitutionPolicy> redactPiiSub = Optional.empty();

        private Optional<List<PiiPolicy>> redactPiiPolicies = Optional.empty();

        private Optional<RedactPiiAudioQuality> redactPiiAudioQuality = Optional.empty();

        private Optional<Boolean> redactPiiAudio = Optional.empty();

        private Optional<Boolean> filterProfanity = Optional.empty();

        private Optional<String> boostParam = Optional.empty();

        private Optional<List<String>> wordBoost = Optional.empty();

        private Optional<Integer> audioEndAt = Optional.empty();

        private Optional<Integer> audioStartFrom = Optional.empty();

        private Optional<AutoHighlightsResult> autoHighlightsResult = Optional.empty();

        private Optional<Boolean> speedBoost = Optional.empty();

        private Optional<String> webhookAuthHeaderName = Optional.empty();

        private Optional<Integer> webhookStatusCode = Optional.empty();

        private Optional<String> webhookUrl = Optional.empty();

        private Optional<Boolean> dualChannel = Optional.empty();

        private Optional<Boolean> formatText = Optional.empty();

        private Optional<Boolean> punctuate = Optional.empty();

        private Optional<Double> audioDuration = Optional.empty();

        private Optional<Double> confidence = Optional.empty();

        private Optional<List<TranscriptUtterance>> utterances = Optional.empty();

        private Optional<List<TranscriptWord>> words = Optional.empty();

        private Optional<String> text = Optional.empty();

        private Optional<TranscriptLanguageCode> languageCode = Optional.empty();

        private Optional<SpeechModel> speechModel = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Transcript other) {
            id(other.getId());
            speechModel(other.getSpeechModel());
            languageModel(other.getLanguageModel());
            acousticModel(other.getAcousticModel());
            status(other.getStatus());
            languageCode(other.getLanguageCode());
            audioUrl(other.getAudioUrl());
            text(other.getText());
            words(other.getWords());
            utterances(other.getUtterances());
            confidence(other.getConfidence());
            audioDuration(other.getAudioDuration());
            punctuate(other.getPunctuate());
            formatText(other.getFormatText());
            dualChannel(other.getDualChannel());
            webhookUrl(other.getWebhookUrl());
            webhookStatusCode(other.getWebhookStatusCode());
            webhookAuth(other.getWebhookAuth());
            webhookAuthHeaderName(other.getWebhookAuthHeaderName());
            speedBoost(other.getSpeedBoost());
            autoHighlights(other.getAutoHighlights());
            autoHighlightsResult(other.getAutoHighlightsResult());
            audioStartFrom(other.getAudioStartFrom());
            audioEndAt(other.getAudioEndAt());
            wordBoost(other.getWordBoost());
            boostParam(other.getBoostParam());
            filterProfanity(other.getFilterProfanity());
            redactPii(other.getRedactPii());
            redactPiiAudio(other.getRedactPiiAudio());
            redactPiiAudioQuality(other.getRedactPiiAudioQuality());
            redactPiiPolicies(other.getRedactPiiPolicies());
            redactPiiSub(other.getRedactPiiSub());
            speakerLabels(other.getSpeakerLabels());
            speakersExpected(other.getSpeakersExpected());
            contentSafety(other.getContentSafety());
            contentSafetyLabels(other.getContentSafetyLabels());
            iabCategories(other.getIabCategories());
            iabCategoriesResult(other.getIabCategoriesResult());
            languageDetection(other.getLanguageDetection());
            customSpelling(other.getCustomSpelling());
            autoChapters(other.getAutoChapters());
            chapters(other.getChapters());
            summarization(other.getSummarization());
            summaryType(other.getSummaryType());
            summaryModel(other.getSummaryModel());
            summary(other.getSummary());
            customTopics(other.getCustomTopics());
            topics(other.getTopics());
            disfluencies(other.getDisfluencies());
            sentimentAnalysis(other.getSentimentAnalysis());
            sentimentAnalysisResults(other.getSentimentAnalysisResults());
            entityDetection(other.getEntityDetection());
            entities(other.getEntities());
            speechThreshold(other.getSpeechThreshold());
            throttled(other.getThrottled());
            error(other.getError());
            return this;
        }

        /**
         * <p>The unique identifier of your transcript</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public LanguageModelStage id(String id) {
            this.id = id;
            return this;
        }

        /**
         * <p>The language model that was used for the transcript</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("language_model")
        public AcousticModelStage languageModel(String languageModel) {
            this.languageModel = languageModel;
            return this;
        }

        /**
         * <p>The acoustic model that was used for the transcript</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("acoustic_model")
        public StatusStage acousticModel(String acousticModel) {
            this.acousticModel = acousticModel;
            return this;
        }

        /**
         * <p>The status of your transcript. Possible values are queued, processing, completed, or error.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("status")
        public AudioUrlStage status(TranscriptStatus status) {
            this.status = status;
            return this;
        }

        /**
         * <p>The URL of the media that was transcribed</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("audio_url")
        public WebhookAuthStage audioUrl(String audioUrl) {
            this.audioUrl = audioUrl;
            return this;
        }

        /**
         * <p>Whether webhook authentication details were provided</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("webhook_auth")
        public AutoHighlightsStage webhookAuth(boolean webhookAuth) {
            this.webhookAuth = webhookAuth;
            return this;
        }

        /**
         * <p>Whether Key Phrases is enabled, either true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("auto_highlights")
        public RedactPiiStage autoHighlights(boolean autoHighlights) {
            this.autoHighlights = autoHighlights;
            return this;
        }

        /**
         * <p>Whether <a href="https://www.assemblyai.com/docs/models/pii-redaction">PII Redaction</a> is enabled, either true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("redact_pii")
        public SummarizationStage redactPii(boolean redactPii) {
            this.redactPii = redactPii;
            return this;
        }

        /**
         * <p>Whether <a href="https://www.assemblyai.com/docs/models/summarization">Summarization</a> is enabled, either true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("summarization")
        public _FinalStage summarization(boolean summarization) {
            this.summarization = summarization;
            return this;
        }

        /**
         * <p>Error message of why the transcript failed</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage error(String error) {
            this.error = Optional.of(error);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "error", nulls = Nulls.SKIP)
        public _FinalStage error(Optional<String> error) {
            this.error = error;
            return this;
        }

        /**
         * <p>True while a request is throttled and false when a request is no longer throttled</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage throttled(Boolean throttled) {
            this.throttled = Optional.of(throttled);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "throttled", nulls = Nulls.SKIP)
        public _FinalStage throttled(Optional<Boolean> throttled) {
            this.throttled = throttled;
            return this;
        }

        /**
         * <p>Defaults to null. Reject audio files that contain less than this fraction of speech.
         * Valid values are in the range [0, 1] inclusive.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage speechThreshold(Double speechThreshold) {
            this.speechThreshold = Optional.of(speechThreshold);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "speech_threshold", nulls = Nulls.SKIP)
        public _FinalStage speechThreshold(Optional<Double> speechThreshold) {
            this.speechThreshold = speechThreshold;
            return this;
        }

        /**
         * <p>An array of results for the Entity Detection model, if it is enabled.
         * See <a href="https://www.assemblyai.com/docs/models/entity-detection">Entity detection</a> for more information.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage entities(List<Entity> entities) {
            this.entities = Optional.of(entities);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "entities", nulls = Nulls.SKIP)
        public _FinalStage entities(Optional<List<Entity>> entities) {
            this.entities = entities;
            return this;
        }

        /**
         * <p>Whether <a href="https://www.assemblyai.com/docs/models/entity-detection">Entity Detection</a> is enabled, can be true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage entityDetection(Boolean entityDetection) {
            this.entityDetection = Optional.of(entityDetection);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "entity_detection", nulls = Nulls.SKIP)
        public _FinalStage entityDetection(Optional<Boolean> entityDetection) {
            this.entityDetection = entityDetection;
            return this;
        }

        /**
         * <p>An array of results for the Sentiment Analysis model, if it is enabled.
         * See <a href="https://www.assemblyai.com/docs/models/sentiment-analysis">Sentiment analysis</a> for more information.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage sentimentAnalysisResults(List<SentimentAnalysisResult> sentimentAnalysisResults) {
            this.sentimentAnalysisResults = Optional.of(sentimentAnalysisResults);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "sentiment_analysis_results", nulls = Nulls.SKIP)
        public _FinalStage sentimentAnalysisResults(Optional<List<SentimentAnalysisResult>> sentimentAnalysisResults) {
            this.sentimentAnalysisResults = sentimentAnalysisResults;
            return this;
        }

        /**
         * <p>Whether <a href="https://www.assemblyai.com/docs/models/sentiment-analysis">Sentiment Analysis</a> is enabled, can be true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage sentimentAnalysis(Boolean sentimentAnalysis) {
            this.sentimentAnalysis = Optional.of(sentimentAnalysis);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "sentiment_analysis", nulls = Nulls.SKIP)
        public _FinalStage sentimentAnalysis(Optional<Boolean> sentimentAnalysis) {
            this.sentimentAnalysis = sentimentAnalysis;
            return this;
        }

        /**
         * <p>Transcribe Filler Words, like &quot;umm&quot;, in your media file; can be true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage disfluencies(Boolean disfluencies) {
            this.disfluencies = Optional.of(disfluencies);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "disfluencies", nulls = Nulls.SKIP)
        public _FinalStage disfluencies(Optional<Boolean> disfluencies) {
            this.disfluencies = disfluencies;
            return this;
        }

        /**
         * <p>The list of custom topics provided if custom topics is enabled</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage topics(List<String> topics) {
            this.topics = Optional.of(topics);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "topics", nulls = Nulls.SKIP)
        public _FinalStage topics(Optional<List<String>> topics) {
            this.topics = topics;
            return this;
        }

        /**
         * <p>Whether custom topics is enabled, either true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage customTopics(Boolean customTopics) {
            this.customTopics = Optional.of(customTopics);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "custom_topics", nulls = Nulls.SKIP)
        public _FinalStage customTopics(Optional<Boolean> customTopics) {
            this.customTopics = customTopics;
            return this;
        }

        /**
         * <p>The generated summary of the media file, if <a href="https://www.assemblyai.com/docs/models/summarization">Summarization</a> is enabled</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage summary(String summary) {
            this.summary = Optional.of(summary);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "summary", nulls = Nulls.SKIP)
        public _FinalStage summary(Optional<String> summary) {
            this.summary = summary;
            return this;
        }

        /**
         * <p>The Summarization model used to generate the summary,
         * if <a href="https://www.assemblyai.com/docs/models/summarization">Summarization</a> is enabled</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage summaryModel(String summaryModel) {
            this.summaryModel = Optional.of(summaryModel);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "summary_model", nulls = Nulls.SKIP)
        public _FinalStage summaryModel(Optional<String> summaryModel) {
            this.summaryModel = summaryModel;
            return this;
        }

        /**
         * <p>The type of summary generated, if <a href="https://www.assemblyai.com/docs/models/summarization">Summarization</a> is enabled</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage summaryType(String summaryType) {
            this.summaryType = Optional.of(summaryType);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "summary_type", nulls = Nulls.SKIP)
        public _FinalStage summaryType(Optional<String> summaryType) {
            this.summaryType = summaryType;
            return this;
        }

        /**
         * <p>An array of temporally sequential chapters for the audio file</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage chapters(List<Chapter> chapters) {
            this.chapters = Optional.of(chapters);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "chapters", nulls = Nulls.SKIP)
        public _FinalStage chapters(Optional<List<Chapter>> chapters) {
            this.chapters = chapters;
            return this;
        }

        /**
         * <p>Whether <a href="https://www.assemblyai.com/docs/models/auto-chapters">Auto Chapters</a> is enabled, can be true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage autoChapters(Boolean autoChapters) {
            this.autoChapters = Optional.of(autoChapters);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "auto_chapters", nulls = Nulls.SKIP)
        public _FinalStage autoChapters(Optional<Boolean> autoChapters) {
            this.autoChapters = autoChapters;
            return this;
        }

        /**
         * <p>Customize how words are spelled and formatted using to and from values</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage customSpelling(List<TranscriptCustomSpelling> customSpelling) {
            this.customSpelling = Optional.of(customSpelling);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "custom_spelling", nulls = Nulls.SKIP)
        public _FinalStage customSpelling(Optional<List<TranscriptCustomSpelling>> customSpelling) {
            this.customSpelling = customSpelling;
            return this;
        }

        /**
         * <p>Whether <a href="https://www.assemblyai.com/docs/models/speech-recognition#automatic-language-detection">Automatic language detection</a> is enabled, either true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage languageDetection(Boolean languageDetection) {
            this.languageDetection = Optional.of(languageDetection);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "language_detection", nulls = Nulls.SKIP)
        public _FinalStage languageDetection(Optional<Boolean> languageDetection) {
            this.languageDetection = languageDetection;
            return this;
        }

        @java.lang.Override
        public _FinalStage iabCategoriesResult(TopicDetectionModelResult iabCategoriesResult) {
            this.iabCategoriesResult = Optional.of(iabCategoriesResult);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "iab_categories_result", nulls = Nulls.SKIP)
        public _FinalStage iabCategoriesResult(Optional<TopicDetectionModelResult> iabCategoriesResult) {
            this.iabCategoriesResult = iabCategoriesResult;
            return this;
        }

        /**
         * <p>Whether <a href="https://www.assemblyai.com/docs/models/topic-detection">Topic Detection</a> is enabled, can be true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage iabCategories(Boolean iabCategories) {
            this.iabCategories = Optional.of(iabCategories);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "iab_categories", nulls = Nulls.SKIP)
        public _FinalStage iabCategories(Optional<Boolean> iabCategories) {
            this.iabCategories = iabCategories;
            return this;
        }

        @java.lang.Override
        public _FinalStage contentSafetyLabels(ContentSafetyLabelsResult contentSafetyLabels) {
            this.contentSafetyLabels = Optional.of(contentSafetyLabels);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "content_safety_labels", nulls = Nulls.SKIP)
        public _FinalStage contentSafetyLabels(Optional<ContentSafetyLabelsResult> contentSafetyLabels) {
            this.contentSafetyLabels = contentSafetyLabels;
            return this;
        }

        /**
         * <p>Whether <a href="https://www.assemblyai.com/docs/models/content-moderation">Content Moderation</a> is enabled, can be true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage contentSafety(Boolean contentSafety) {
            this.contentSafety = Optional.of(contentSafety);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "content_safety", nulls = Nulls.SKIP)
        public _FinalStage contentSafety(Optional<Boolean> contentSafety) {
            this.contentSafety = contentSafety;
            return this;
        }

        /**
         * <p>Tell the speaker label model how many speakers it should attempt to identify, up to 10. See <a href="https://www.assemblyai.com/docs/models/speaker-diarization">Speaker diarization</a> for more details.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage speakersExpected(Integer speakersExpected) {
            this.speakersExpected = Optional.of(speakersExpected);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "speakers_expected", nulls = Nulls.SKIP)
        public _FinalStage speakersExpected(Optional<Integer> speakersExpected) {
            this.speakersExpected = speakersExpected;
            return this;
        }

        /**
         * <p>Whether <a href="https://www.assemblyai.com/docs/models/speaker-diarization">Speaker diarization</a> is enabled, can be true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage speakerLabels(Boolean speakerLabels) {
            this.speakerLabels = Optional.of(speakerLabels);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "speaker_labels", nulls = Nulls.SKIP)
        public _FinalStage speakerLabels(Optional<Boolean> speakerLabels) {
            this.speakerLabels = speakerLabels;
            return this;
        }

        /**
         * <p>The replacement logic for detected PII, can be &quot;entity_type&quot; or &quot;hash&quot;. See <a href="https://www.assemblyai.com/docs/models/pii-redaction">PII redaction</a> for more details.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage redactPiiSub(SubstitutionPolicy redactPiiSub) {
            this.redactPiiSub = Optional.of(redactPiiSub);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "redact_pii_sub", nulls = Nulls.SKIP)
        public _FinalStage redactPiiSub(Optional<SubstitutionPolicy> redactPiiSub) {
            this.redactPiiSub = redactPiiSub;
            return this;
        }

        /**
         * <p>The list of PII Redaction policies that were enabled, if PII Redaction is enabled.
         * See <a href="https://www.assemblyai.com/docs/models/pii-redaction">PII redaction</a> for more information.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage redactPiiPolicies(List<PiiPolicy> redactPiiPolicies) {
            this.redactPiiPolicies = Optional.of(redactPiiPolicies);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "redact_pii_policies", nulls = Nulls.SKIP)
        public _FinalStage redactPiiPolicies(Optional<List<PiiPolicy>> redactPiiPolicies) {
            this.redactPiiPolicies = redactPiiPolicies;
            return this;
        }

        @java.lang.Override
        public _FinalStage redactPiiAudioQuality(RedactPiiAudioQuality redactPiiAudioQuality) {
            this.redactPiiAudioQuality = Optional.of(redactPiiAudioQuality);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "redact_pii_audio_quality", nulls = Nulls.SKIP)
        public _FinalStage redactPiiAudioQuality(Optional<RedactPiiAudioQuality> redactPiiAudioQuality) {
            this.redactPiiAudioQuality = redactPiiAudioQuality;
            return this;
        }

        /**
         * <p>Whether a redacted version of the audio file was generated,
         * either true or false. See <a href="https://www.assemblyai.com/docs/models/pii-redaction">PII redaction</a> for more information.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage redactPiiAudio(Boolean redactPiiAudio) {
            this.redactPiiAudio = Optional.of(redactPiiAudio);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "redact_pii_audio", nulls = Nulls.SKIP)
        public _FinalStage redactPiiAudio(Optional<Boolean> redactPiiAudio) {
            this.redactPiiAudio = redactPiiAudio;
            return this;
        }

        /**
         * <p>Whether <a href="https://www.assemblyai.com/docs/models/speech-recognition#profanity-filtering">Profanity Filtering</a> is enabled, either true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage filterProfanity(Boolean filterProfanity) {
            this.filterProfanity = Optional.of(filterProfanity);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "filter_profanity", nulls = Nulls.SKIP)
        public _FinalStage filterProfanity(Optional<Boolean> filterProfanity) {
            this.filterProfanity = filterProfanity;
            return this;
        }

        /**
         * <p>The word boost parameter value</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage boostParam(String boostParam) {
            this.boostParam = Optional.of(boostParam);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "boost_param", nulls = Nulls.SKIP)
        public _FinalStage boostParam(Optional<String> boostParam) {
            this.boostParam = boostParam;
            return this;
        }

        /**
         * <p>The list of custom vocabulary to boost transcription probability for</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage wordBoost(List<String> wordBoost) {
            this.wordBoost = Optional.of(wordBoost);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "word_boost", nulls = Nulls.SKIP)
        public _FinalStage wordBoost(Optional<List<String>> wordBoost) {
            this.wordBoost = wordBoost;
            return this;
        }

        /**
         * <p>The point in time, in milliseconds, in the file at which the transcription was terminated</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage audioEndAt(Integer audioEndAt) {
            this.audioEndAt = Optional.of(audioEndAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "audio_end_at", nulls = Nulls.SKIP)
        public _FinalStage audioEndAt(Optional<Integer> audioEndAt) {
            this.audioEndAt = audioEndAt;
            return this;
        }

        /**
         * <p>The point in time, in milliseconds, in the file at which the transcription was started</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage audioStartFrom(Integer audioStartFrom) {
            this.audioStartFrom = Optional.of(audioStartFrom);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "audio_start_from", nulls = Nulls.SKIP)
        public _FinalStage audioStartFrom(Optional<Integer> audioStartFrom) {
            this.audioStartFrom = audioStartFrom;
            return this;
        }

        @java.lang.Override
        public _FinalStage autoHighlightsResult(AutoHighlightsResult autoHighlightsResult) {
            this.autoHighlightsResult = Optional.of(autoHighlightsResult);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "auto_highlights_result", nulls = Nulls.SKIP)
        public _FinalStage autoHighlightsResult(Optional<AutoHighlightsResult> autoHighlightsResult) {
            this.autoHighlightsResult = autoHighlightsResult;
            return this;
        }

        /**
         * <p>Whether speed boost is enabled</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage speedBoost(Boolean speedBoost) {
            this.speedBoost = Optional.of(speedBoost);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "speed_boost", nulls = Nulls.SKIP)
        public _FinalStage speedBoost(Optional<Boolean> speedBoost) {
            this.speedBoost = speedBoost;
            return this;
        }

        /**
         * <p>The header name which should be sent back with webhook calls</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage webhookAuthHeaderName(String webhookAuthHeaderName) {
            this.webhookAuthHeaderName = Optional.of(webhookAuthHeaderName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "webhook_auth_header_name", nulls = Nulls.SKIP)
        public _FinalStage webhookAuthHeaderName(Optional<String> webhookAuthHeaderName) {
            this.webhookAuthHeaderName = webhookAuthHeaderName;
            return this;
        }

        /**
         * <p>The status code we received from your server when delivering your webhook, if a webhook URL was provided</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage webhookStatusCode(Integer webhookStatusCode) {
            this.webhookStatusCode = Optional.of(webhookStatusCode);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "webhook_status_code", nulls = Nulls.SKIP)
        public _FinalStage webhookStatusCode(Optional<Integer> webhookStatusCode) {
            this.webhookStatusCode = webhookStatusCode;
            return this;
        }

        /**
         * <p>The URL to which we send webhooks upon trancription completion</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage webhookUrl(String webhookUrl) {
            this.webhookUrl = Optional.of(webhookUrl);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "webhook_url", nulls = Nulls.SKIP)
        public _FinalStage webhookUrl(Optional<String> webhookUrl) {
            this.webhookUrl = webhookUrl;
            return this;
        }

        /**
         * <p>Whether <a href="https://www.assemblyai.com/docs/models/speech-recognition#dual-channel-transcription">Dual channel transcription</a> was enabled in the transcription request, either true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage dualChannel(Boolean dualChannel) {
            this.dualChannel = Optional.of(dualChannel);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "dual_channel", nulls = Nulls.SKIP)
        public _FinalStage dualChannel(Optional<Boolean> dualChannel) {
            this.dualChannel = dualChannel;
            return this;
        }

        /**
         * <p>Whether Text Formatting is enabled, either true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage formatText(Boolean formatText) {
            this.formatText = Optional.of(formatText);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "format_text", nulls = Nulls.SKIP)
        public _FinalStage formatText(Optional<Boolean> formatText) {
            this.formatText = formatText;
            return this;
        }

        /**
         * <p>Whether Automatic Punctuation is enabled, either true or false</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage punctuate(Boolean punctuate) {
            this.punctuate = Optional.of(punctuate);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "punctuate", nulls = Nulls.SKIP)
        public _FinalStage punctuate(Optional<Boolean> punctuate) {
            this.punctuate = punctuate;
            return this;
        }

        /**
         * <p>The duration of this transcript object's media file, in seconds</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage audioDuration(Double audioDuration) {
            this.audioDuration = Optional.of(audioDuration);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "audio_duration", nulls = Nulls.SKIP)
        public _FinalStage audioDuration(Optional<Double> audioDuration) {
            this.audioDuration = audioDuration;
            return this;
        }

        /**
         * <p>The confidence score for the transcript, between 0.0 (low confidence) and 1.0 (high confidence)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage confidence(Double confidence) {
            this.confidence = Optional.of(confidence);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "confidence", nulls = Nulls.SKIP)
        public _FinalStage confidence(Optional<Double> confidence) {
            this.confidence = confidence;
            return this;
        }

        /**
         * <p>When dual_channel or speaker_labels is enabled, a list of turn-by-turn utterance objects.
         * See <a href="https://www.assemblyai.com/docs/models/speaker-diarization">Speaker diarization</a> for more information.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage utterances(List<TranscriptUtterance> utterances) {
            this.utterances = Optional.of(utterances);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "utterances", nulls = Nulls.SKIP)
        public _FinalStage utterances(Optional<List<TranscriptUtterance>> utterances) {
            this.utterances = utterances;
            return this;
        }

        /**
         * <p>An array of temporally-sequential word objects, one for each word in the transcript.
         * See <a href="https://www.assemblyai.com/docs/models/speech-recognition">Speech recognition</a> for more information.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage words(List<TranscriptWord> words) {
            this.words = Optional.of(words);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "words", nulls = Nulls.SKIP)
        public _FinalStage words(Optional<List<TranscriptWord>> words) {
            this.words = words;
            return this;
        }

        /**
         * <p>The textual transcript of your media file</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage text(String text) {
            this.text = Optional.of(text);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "text", nulls = Nulls.SKIP)
        public _FinalStage text(Optional<String> text) {
            this.text = text;
            return this;
        }

        /**
         * <p>The language of your audio file.
         * Possible values are found in <a href="https://www.assemblyai.com/docs/concepts/supported-languages">Supported Languages</a>.
         * The default value is 'en_us'.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage languageCode(TranscriptLanguageCode languageCode) {
            this.languageCode = Optional.of(languageCode);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "language_code", nulls = Nulls.SKIP)
        public _FinalStage languageCode(Optional<TranscriptLanguageCode> languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @java.lang.Override
        public _FinalStage speechModel(SpeechModel speechModel) {
            this.speechModel = Optional.of(speechModel);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "speech_model", nulls = Nulls.SKIP)
        public _FinalStage speechModel(Optional<SpeechModel> speechModel) {
            this.speechModel = speechModel;
            return this;
        }

        @java.lang.Override
        public Transcript build() {
            return new Transcript(
                    id,
                    speechModel,
                    languageModel,
                    acousticModel,
                    status,
                    languageCode,
                    audioUrl,
                    text,
                    words,
                    utterances,
                    confidence,
                    audioDuration,
                    punctuate,
                    formatText,
                    dualChannel,
                    webhookUrl,
                    webhookStatusCode,
                    webhookAuth,
                    webhookAuthHeaderName,
                    speedBoost,
                    autoHighlights,
                    autoHighlightsResult,
                    audioStartFrom,
                    audioEndAt,
                    wordBoost,
                    boostParam,
                    filterProfanity,
                    redactPii,
                    redactPiiAudio,
                    redactPiiAudioQuality,
                    redactPiiPolicies,
                    redactPiiSub,
                    speakerLabels,
                    speakersExpected,
                    contentSafety,
                    contentSafetyLabels,
                    iabCategories,
                    iabCategoriesResult,
                    languageDetection,
                    customSpelling,
                    autoChapters,
                    chapters,
                    summarization,
                    summaryType,
                    summaryModel,
                    summary,
                    customTopics,
                    topics,
                    disfluencies,
                    sentimentAnalysis,
                    sentimentAnalysisResults,
                    entityDetection,
                    entities,
                    speechThreshold,
                    throttled,
                    error,
                    additionalProperties);
        }
    }
}
