/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder = TranscriptUtterance.Builder.class)
public final class TranscriptUtterance {
    private final double confidence;

    private final int start;

    private final int end;

    private final String text;

    private final List<TranscriptWord> words;

    private final String speaker;

    private final Map<String, Object> additionalProperties;

    private TranscriptUtterance(
            double confidence,
            int start,
            int end,
            String text,
            List<TranscriptWord> words,
            String speaker,
            Map<String, Object> additionalProperties) {
        this.confidence = confidence;
        this.start = start;
        this.end = end;
        this.text = text;
        this.words = words;
        this.speaker = speaker;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The confidence score for the transcript of this utterance
     */
    @JsonProperty("confidence")
    public double getConfidence() {
        return confidence;
    }

    /**
     * @return The starting time, in milliseconds, of the utterance in the audio file
     */
    @JsonProperty("start")
    public int getStart() {
        return start;
    }

    /**
     * @return The ending time, in milliseconds, of the utterance in the audio file
     */
    @JsonProperty("end")
    public int getEnd() {
        return end;
    }

    /**
     * @return The text for this utterance
     */
    @JsonProperty("text")
    public String getText() {
        return text;
    }

    /**
     * @return The words in the utterance.
     */
    @JsonProperty("words")
    public List<TranscriptWord> getWords() {
        return words;
    }

    /**
     * @return The speaker of this utterance, where each speaker is assigned a sequential capital letter - e.g. &quot;A&quot; for Speaker A, &quot;B&quot; for Speaker B, etc.
     */
    @JsonProperty("speaker")
    public String getSpeaker() {
        return speaker;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TranscriptUtterance && equalTo((TranscriptUtterance) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TranscriptUtterance other) {
        return confidence == other.confidence
                && start == other.start
                && end == other.end
                && text.equals(other.text)
                && words.equals(other.words)
                && speaker.equals(other.speaker);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.confidence, this.start, this.end, this.text, this.words, this.speaker);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ConfidenceStage builder() {
        return new Builder();
    }

    public interface ConfidenceStage {
        StartStage confidence(double confidence);

        Builder from(TranscriptUtterance other);
    }

    public interface StartStage {
        EndStage start(int start);
    }

    public interface EndStage {
        TextStage end(int end);
    }

    public interface TextStage {
        SpeakerStage text(String text);
    }

    public interface SpeakerStage {
        _FinalStage speaker(String speaker);
    }

    public interface _FinalStage {
        TranscriptUtterance build();

        _FinalStage words(List<TranscriptWord> words);

        _FinalStage addWords(TranscriptWord words);

        _FinalStage addAllWords(List<TranscriptWord> words);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements ConfidenceStage, StartStage, EndStage, TextStage, SpeakerStage, _FinalStage {
        private double confidence;

        private int start;

        private int end;

        private String text;

        private String speaker;

        private List<TranscriptWord> words = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TranscriptUtterance other) {
            confidence(other.getConfidence());
            start(other.getStart());
            end(other.getEnd());
            text(other.getText());
            words(other.getWords());
            speaker(other.getSpeaker());
            return this;
        }

        /**
         * <p>The confidence score for the transcript of this utterance</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("confidence")
        public StartStage confidence(double confidence) {
            this.confidence = confidence;
            return this;
        }

        /**
         * <p>The starting time, in milliseconds, of the utterance in the audio file</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("start")
        public EndStage start(int start) {
            this.start = start;
            return this;
        }

        /**
         * <p>The ending time, in milliseconds, of the utterance in the audio file</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("end")
        public TextStage end(int end) {
            this.end = end;
            return this;
        }

        /**
         * <p>The text for this utterance</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("text")
        public SpeakerStage text(String text) {
            this.text = text;
            return this;
        }

        /**
         * <p>The speaker of this utterance, where each speaker is assigned a sequential capital letter - e.g. &quot;A&quot; for Speaker A, &quot;B&quot; for Speaker B, etc.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("speaker")
        public _FinalStage speaker(String speaker) {
            this.speaker = speaker;
            return this;
        }

        /**
         * <p>The words in the utterance.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllWords(List<TranscriptWord> words) {
            this.words.addAll(words);
            return this;
        }

        /**
         * <p>The words in the utterance.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addWords(TranscriptWord words) {
            this.words.add(words);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "words", nulls = Nulls.SKIP)
        public _FinalStage words(List<TranscriptWord> words) {
            this.words.clear();
            this.words.addAll(words);
            return this;
        }

        @java.lang.Override
        public TranscriptUtterance build() {
            return new TranscriptUtterance(confidence, start, end, text, words, speaker, additionalProperties);
        }
    }
}
