/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.realtime.types.FinalTranscript;
import com.assemblyai.api.resources.realtime.types.PartialTranscript;
import com.assemblyai.api.resources.realtime.types.RealtimeError;
import com.assemblyai.api.resources.realtime.types.RealtimeMessage;
import com.assemblyai.api.resources.realtime.types.RealtimeTranscript;
import com.assemblyai.api.resources.realtime.types.SessionBegins;
import com.assemblyai.api.resources.realtime.types.SessionTerminated;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RealtimeTranscriber
implements AutoCloseable {
    private static final String BASE_URL = "wss://api.assemblyai.com";
    private static final OkHttpClient OK_HTTP_CLIENT = new OkHttpClient.Builder().build();
    private final String apiKey;
    private final int sampleRate;
    private final Optional<List<String>> wordBoost;
    private final Optional<Integer> endUtteranceSilenceThreshold;
    private final Consumer<SessionBegins> onSessionBegins;
    private final Consumer<PartialTranscript> onPartialTranscript;
    private final Consumer<FinalTranscript> onFinalTranscript;
    private final Consumer<RealtimeTranscript> onTranscript;
    private final Consumer<Throwable> onError;
    private final BiConsumer<Integer, String> onClose;
    private final RealtimeMessageVisitor realtimeMessageVisitor;
    private WebSocket webSocket;
    private final HashMap<Integer, String> closeCodeErrorMessages = new HashMap<Integer, String>(){
        {
            this.put(4000, "Sample rate must be a positive integer");
            this.put(4001, "Not Authorized");
            this.put(4002, "Insufficient funds or you are using a free account. This feature is paid-only and requires you to add a credit card. Please visit https://assemblyai.com/dashboard/ to add a credit card to your account.");
            this.put(4004, "Session ID does not exist");
            this.put(4008, "Session has expired");
            this.put(4010, "Session is closed");
            this.put(4029, "Rate limited");
            this.put(4030, "Unique session violation");
            this.put(4031, "Session Timeout");
            this.put(4032, "Audio too short");
            this.put(4033, "Audio too long");
            this.put(4100, "Bad JSON");
            this.put(4101, "Bad schema");
            this.put(4102, "Too many streams");
            this.put(4103, "Reconnected");
            this.put(1013, "Reconnect attempts exhausted");
        }
    };

    private RealtimeTranscriber(String apiKey, int sampleRate, Optional<List<String>> wordBoost, Optional<Integer> endUtteranceSilenceThreshold, Consumer<SessionBegins> onSessionBegins, Consumer<PartialTranscript> onPartialTranscript, Consumer<FinalTranscript> onFinalTranscript, Consumer<RealtimeTranscript> onTranscript, Consumer<Throwable> onError, BiConsumer<Integer, String> onClose) {
        this.apiKey = apiKey;
        this.sampleRate = sampleRate;
        this.wordBoost = wordBoost;
        this.endUtteranceSilenceThreshold = endUtteranceSilenceThreshold;
        this.onSessionBegins = onSessionBegins;
        this.onPartialTranscript = onPartialTranscript;
        this.onFinalTranscript = onFinalTranscript;
        this.onTranscript = onTranscript;
        this.onError = onError;
        this.onClose = onClose;
        this.realtimeMessageVisitor = new RealtimeMessageVisitor();
    }

    public void connect() {
        String url = "wss://api.assemblyai.com/v2/realtime/ws?sample_rate=" + this.sampleRate;
        if (this.wordBoost.isPresent() && !this.wordBoost.get().isEmpty()) {
            try {
                url = url + "&word_boost=" + ObjectMappers.JSON_MAPPER.writeValueAsString(this.wordBoost.get());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to serialize word boosts");
            }
        }
        Request request = new Request.Builder().url(url).addHeader("Authorization", this.apiKey).build();
        this.webSocket = OK_HTTP_CLIENT.newWebSocket(request, (WebSocketListener)new Listener(response -> this.endUtteranceSilenceThreshold.ifPresent(this::configureEndUtteranceSilenceThreshold)));
    }

    public void sendAudio(byte[] audio) {
        this.webSocket.send(ByteString.of((byte[])audio));
    }

    public void sendAudio(String audio) {
        this.sendAudio(Base64.getDecoder().decode(audio));
    }

    public void forceEndUtterance() {
        this.webSocket.send("{\"force_end_utterance\":true}");
    }

    public void configureEndUtteranceSilenceThreshold(int threshold) {
        this.webSocket.send(String.format("{\"end_utterance_silence_threshold\":%d}", threshold));
    }

    @Override
    public void close() {
        boolean closed = this.webSocket.close(1000, "Shutting down");
        if (!closed) {
            this.webSocket.cancel();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private final class RealtimeMessageVisitor
    implements RealtimeMessage.Visitor<Void> {
        private RealtimeMessageVisitor() {
        }

        @Override
        public Void visit(SessionBegins value) {
            if (RealtimeTranscriber.this.onSessionBegins == null) {
                return null;
            }
            RealtimeTranscriber.this.onSessionBegins.accept(value);
            return null;
        }

        @Override
        public Void visit(PartialTranscript value) {
            if (RealtimeTranscriber.this.onPartialTranscript != null) {
                RealtimeTranscriber.this.onPartialTranscript.accept(value);
            }
            if (RealtimeTranscriber.this.onTranscript != null) {
                RealtimeTranscriber.this.onTranscript.accept(RealtimeTranscript.of(value));
            }
            return null;
        }

        @Override
        public Void visit(FinalTranscript value) {
            if (RealtimeTranscriber.this.onFinalTranscript != null) {
                RealtimeTranscriber.this.onFinalTranscript.accept(value);
            }
            if (RealtimeTranscriber.this.onTranscript != null) {
                RealtimeTranscriber.this.onTranscript.accept(RealtimeTranscript.of(value));
            }
            return null;
        }

        @Override
        public Void visit(SessionTerminated value) {
            return null;
        }

        @Override
        public Void visit(RealtimeError value) {
            if (RealtimeTranscriber.this.onError == null) {
                return null;
            }
            RealtimeTranscriber.this.onError.accept(new Exception(value.getError()));
            return null;
        }
    }

    private final class Listener
    extends WebSocketListener {
        private final Consumer<Response> onOpen;

        public Listener(Consumer<Response> onOpen) {
            this.onOpen = onOpen;
        }

        public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
            if (this.onOpen != null) {
                this.onOpen.accept(response);
            }
        }

        public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
            try {
                RealtimeMessage realtimeMessage = (RealtimeMessage)ObjectMappers.JSON_MAPPER.readValue(text, RealtimeMessage.class);
                realtimeMessage.visit(RealtimeTranscriber.this.realtimeMessageVisitor);
            }
            catch (JsonProcessingException e) {
                if (RealtimeTranscriber.this.onError == null) {
                    return;
                }
                RealtimeTranscriber.this.onError.accept(e);
            }
        }

        public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
            if (RealtimeTranscriber.this.onError == null) {
                return;
            }
            RealtimeTranscriber.this.onError.accept(t);
        }

        public void onClosing(@NotNull WebSocket webSocket, int code, String reason) {
            if (RealtimeTranscriber.this.onClose == null) {
                return;
            }
            if (reason == null || reason.isEmpty()) {
                reason = RealtimeTranscriber.this.closeCodeErrorMessages.getOrDefault(code, null);
            }
            RealtimeTranscriber.this.onClose.accept(code, reason);
            super.onClosing(webSocket, code, reason);
        }
    }

    public static final class Builder {
        private static final int DEFAULT_SAMPLE_RATE = 16000;
        private String apiKey;
        private Integer sampleRate;
        private List<String> wordBoost;
        private Optional<Integer> endUtteranceSilenceThreshold = Optional.empty();
        private Consumer<SessionBegins> onSessionBegins;
        private Consumer<PartialTranscript> onPartialTranscript;
        private Consumer<FinalTranscript> onFinalTranscript;
        private Consumer<RealtimeTranscript> onTranscript;
        private Consumer<Throwable> onError;
        private BiConsumer<Integer, String> onClose;

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder sampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public Builder wordBoost(List<String> wordBoost) {
            this.wordBoost = wordBoost;
            return this;
        }

        public Builder endUtteranceSilenceThreshold(int threshold) {
            this.endUtteranceSilenceThreshold = Optional.of(threshold);
            return this;
        }

        public Builder onSessionStart(Consumer<SessionBegins> onSessionStart) {
            this.onSessionBegins(onSessionStart);
            return this;
        }

        public Builder onSessionBegins(Consumer<SessionBegins> onSessionBegins) {
            this.onSessionBegins = onSessionBegins;
            return this;
        }

        public Builder onPartialTranscript(Consumer<PartialTranscript> onPartialTranscript) {
            this.onPartialTranscript = onPartialTranscript;
            return this;
        }

        public Builder onFinalTranscript(Consumer<FinalTranscript> onFinalTranscript) {
            this.onFinalTranscript = onFinalTranscript;
            return this;
        }

        public Builder onTranscript(Consumer<RealtimeTranscript> onTranscript) {
            this.onTranscript = onTranscript;
            return this;
        }

        public Builder onError(Consumer<Throwable> onError) {
            this.onError = onError;
            return this;
        }

        public Builder onClose(BiConsumer<Integer, String> onClose) {
            this.onClose = onClose;
            return this;
        }

        public RealtimeTranscriber build() {
            if (this.apiKey == null) {
                throw new RuntimeException("apiKey must be specified to construct RealtimeTranscriber");
            }
            return new RealtimeTranscriber(this.apiKey, this.sampleRate == null ? 16000 : this.sampleRate, Optional.ofNullable(this.wordBoost), this.endUtteranceSilenceThreshold, this.onSessionBegins, this.onPartialTranscript, this.onFinalTranscript, this.onTranscript, this.onError, this.onClose);
        }
    }
}

