/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.core;

import com.assemblyai.api.core.Environment;
import com.assemblyai.api.core.RequestOptions;
import com.assemblyai.api.core.RetryInterceptor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public final class ClientOptions {
    private final Environment environment;
    private final Map<String, String> headers;
    private final Map<String, Supplier<String>> headerSuppliers;
    private final OkHttpClient httpClient;

    private ClientOptions(Environment environment, Map<String, String> headers, Map<String, Supplier<String>> headerSuppliers, OkHttpClient httpClient) {
        this.environment = environment;
        this.headers = new HashMap<String, String>();
        this.headers.putAll(headers);
        this.headers.putAll(Map.of("X-Fern-SDK-Name", "com.assemblyai.fern:api-sdk", "X-Fern-SDK-Version", "1.0.9", "X-Fern-Language", "JAVA"));
        this.headerSuppliers = headerSuppliers;
        this.httpClient = httpClient;
    }

    public Environment environment() {
        return this.environment;
    }

    public Map<String, String> headers(RequestOptions requestOptions) {
        HashMap<String, String> values = new HashMap<String, String>(this.headers);
        this.headerSuppliers.forEach((key, supplier) -> values.put((String)key, (String)supplier.get()));
        if (requestOptions != null) {
            values.putAll(requestOptions.getHeaders());
        }
        return values;
    }

    public OkHttpClient httpClient() {
        return this.httpClient;
    }

    public OkHttpClient httpClientWithTimeout(RequestOptions requestOptions) {
        if (requestOptions == null) {
            return this.httpClient;
        }
        return this.httpClient.newBuilder().callTimeout((long)requestOptions.getTimeout().get().intValue(), requestOptions.getTimeoutTimeUnit()).connectTimeout(0L, TimeUnit.SECONDS).writeTimeout(0L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.SECONDS).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Environment environment;
        private final Map<String, String> headers = new HashMap<String, String>();
        private final Map<String, Supplier<String>> headerSuppliers = new HashMap<String, Supplier<String>>();
        private boolean disableTimeouts = false;

        public Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public Builder addHeader(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder addHeader(String key, Supplier<String> value) {
            this.headerSuppliers.put(key, value);
            return this;
        }

        public Builder disableTimeouts() {
            this.disableTimeouts = true;
            return this;
        }

        public ClientOptions build() {
            OkHttpClient.Builder okhttpClientBuilder = new OkHttpClient.Builder().addInterceptor((Interceptor)new RetryInterceptor(3));
            if (this.disableTimeouts) {
                okhttpClientBuilder.callTimeout(0L, TimeUnit.SECONDS).connectTimeout(0L, TimeUnit.SECONDS).writeTimeout(0L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.SECONDS);
            }
            return new ClientOptions(this.environment, this.headers, this.headerSuppliers, okhttpClientBuilder.build());
        }
    }
}

