/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.files;

import com.assemblyai.api.core.ApiError;
import com.assemblyai.api.core.ClientOptions;
import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.core.RequestOptions;
import com.assemblyai.api.resources.files.types.UploadedFile;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class FilesClient {
    protected final ClientOptions clientOptions;

    public FilesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public UploadedFile upload(byte[] request) {
        return this.upload(request, null);
    }

    public UploadedFile upload(byte[] request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/upload").build();
        RequestBody body = RequestBody.create((byte[])request);
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/octet-stream").build();
        try {
            Response response;
            OkHttpClient client = this.clientOptions.httpClient();
            if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
                client = this.clientOptions.httpClientWithTimeout(requestOptions);
            }
            if ((response = client.newCall(okhttpRequest).execute()).isSuccessful()) {
                return (UploadedFile)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), UploadedFile.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

