/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.realtime.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class MessageType {
    public static final MessageType SESSION_BEGINS = new MessageType(Value.SESSION_BEGINS, "SessionBegins");
    public static final MessageType SESSION_TERMINATED = new MessageType(Value.SESSION_TERMINATED, "SessionTerminated");
    public static final MessageType PARTIAL_TRANSCRIPT = new MessageType(Value.PARTIAL_TRANSCRIPT, "PartialTranscript");
    public static final MessageType FINAL_TRANSCRIPT = new MessageType(Value.FINAL_TRANSCRIPT, "FinalTranscript");
    private final Value value;
    private final String string;

    MessageType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof MessageType && this.string.equals(((MessageType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case SESSION_BEGINS: {
                return visitor.visitSessionBegins();
            }
            case SESSION_TERMINATED: {
                return visitor.visitSessionTerminated();
            }
            case PARTIAL_TRANSCRIPT: {
                return visitor.visitPartialTranscript();
            }
            case FINAL_TRANSCRIPT: {
                return visitor.visitFinalTranscript();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static MessageType valueOf(String value) {
        switch (value) {
            case "SessionBegins": {
                return SESSION_BEGINS;
            }
            case "SessionTerminated": {
                return SESSION_TERMINATED;
            }
            case "PartialTranscript": {
                return PARTIAL_TRANSCRIPT;
            }
            case "FinalTranscript": {
                return FINAL_TRANSCRIPT;
            }
        }
        return new MessageType(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitSessionBegins();

        public T visitPartialTranscript();

        public T visitFinalTranscript();

        public T visitSessionTerminated();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        SESSION_BEGINS,
        PARTIAL_TRANSCRIPT,
        FINAL_TRANSCRIPT,
        SESSION_TERMINATED,
        UNKNOWN;

    }
}

