/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.realtime.types;

import com.assemblyai.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class SessionBegins {
    private final String sessionId;
    private final OffsetDateTime expiresAt;
    private final Map<String, Object> additionalProperties;

    private SessionBegins(String sessionId, OffsetDateTime expiresAt, String messageType, Map<String, Object> additionalProperties) {
        if (!messageType.equals("SessionBegins")) {
            throw new IllegalArgumentException("messageType must be SessionBegins");
        }
        this.sessionId = sessionId;
        this.expiresAt = expiresAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="message_type")
    public String getMessageType() {
        return "SessionBegins";
    }

    @JsonProperty(value="session_id")
    public String getSessionId() {
        return this.sessionId;
    }

    @JsonProperty(value="expires_at")
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SessionBegins && this.equalTo((SessionBegins)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SessionBegins other) {
        return this.sessionId.equals(other.sessionId) && this.expiresAt.equals(other.expiresAt);
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.expiresAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SessionIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SessionIdStage,
    ExpiresAtStage,
    _FinalStage {
        @JsonSetter(value="message_type")
        private String messageType = "SessionBegins";
        private String sessionId;
        private OffsetDateTime expiresAt;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SessionBegins other) {
            this.sessionId(other.getSessionId());
            this.expiresAt(other.getExpiresAt());
            return this;
        }

        @Override
        @JsonSetter(value="session_id")
        public ExpiresAtStage sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        @JsonSetter(value="expires_at")
        public _FinalStage expiresAt(OffsetDateTime expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        @Override
        public SessionBegins build() {
            return new SessionBegins(this.sessionId, this.expiresAt, this.messageType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SessionBegins build();
    }

    public static interface ExpiresAtStage {
        public _FinalStage expiresAt(OffsetDateTime var1);
    }

    public static interface SessionIdStage {
        public ExpiresAtStage sessionId(String var1);

        public Builder from(SessionBegins var1);
    }
}

