/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.lemur;

import com.assemblyai.api.core.ApiError;
import com.assemblyai.api.core.ClientOptions;
import com.assemblyai.api.core.MediaTypes;
import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.core.RequestOptions;
import com.assemblyai.api.resources.lemur.requests.LemurActionItemsParams;
import com.assemblyai.api.resources.lemur.requests.LemurQuestionAnswerParams;
import com.assemblyai.api.resources.lemur.requests.LemurSummaryParams;
import com.assemblyai.api.resources.lemur.requests.LemurTaskParams;
import com.assemblyai.api.resources.lemur.types.LemurActionItemsResponse;
import com.assemblyai.api.resources.lemur.types.LemurQuestionAnswerResponse;
import com.assemblyai.api.resources.lemur.types.LemurSummaryResponse;
import com.assemblyai.api.resources.lemur.types.LemurTaskResponse;
import com.assemblyai.api.resources.lemur.types.PurgeLemurRequestDataResponse;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class LemurClient {
    protected final ClientOptions clientOptions;

    public LemurClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public LemurTaskResponse task(LemurTaskParams request) {
        return this.task(request, null);
    }

    public LemurTaskResponse task(LemurTaskParams request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("lemur/v3/generate/task").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response;
            OkHttpClient client = this.clientOptions.httpClient();
            if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
                client = this.clientOptions.httpClientWithTimeout(requestOptions);
            }
            if ((response = client.newCall(okhttpRequest).execute()).isSuccessful()) {
                return (LemurTaskResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), LemurTaskResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public LemurSummaryResponse summary() {
        return this.summary(LemurSummaryParams.builder().build());
    }

    public LemurSummaryResponse summary(LemurSummaryParams request) {
        return this.summary(request, null);
    }

    public LemurSummaryResponse summary(LemurSummaryParams request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("lemur/v3/generate/summary").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response;
            OkHttpClient client = this.clientOptions.httpClient();
            if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
                client = this.clientOptions.httpClientWithTimeout(requestOptions);
            }
            if ((response = client.newCall(okhttpRequest).execute()).isSuccessful()) {
                return (LemurSummaryResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), LemurSummaryResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public LemurQuestionAnswerResponse questionAnswer(LemurQuestionAnswerParams request) {
        return this.questionAnswer(request, null);
    }

    public LemurQuestionAnswerResponse questionAnswer(LemurQuestionAnswerParams request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("lemur/v3/generate/question-answer").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response;
            OkHttpClient client = this.clientOptions.httpClient();
            if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
                client = this.clientOptions.httpClientWithTimeout(requestOptions);
            }
            if ((response = client.newCall(okhttpRequest).execute()).isSuccessful()) {
                return (LemurQuestionAnswerResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), LemurQuestionAnswerResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public LemurActionItemsResponse actionItems() {
        return this.actionItems(LemurActionItemsParams.builder().build());
    }

    public LemurActionItemsResponse actionItems(LemurActionItemsParams request) {
        return this.actionItems(request, null);
    }

    public LemurActionItemsResponse actionItems(LemurActionItemsParams request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("lemur/v3/generate/action-items").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response;
            OkHttpClient client = this.clientOptions.httpClient();
            if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
                client = this.clientOptions.httpClientWithTimeout(requestOptions);
            }
            if ((response = client.newCall(okhttpRequest).execute()).isSuccessful()) {
                return (LemurActionItemsResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), LemurActionItemsResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public PurgeLemurRequestDataResponse purgeRequestData(String requestId) {
        return this.purgeRequestData(requestId, null);
    }

    public PurgeLemurRequestDataResponse purgeRequestData(String requestId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("lemur/v3").addPathSegment(requestId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        try {
            Response response;
            OkHttpClient client = this.clientOptions.httpClient();
            if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
                client = this.clientOptions.httpClientWithTimeout(requestOptions);
            }
            if ((response = client.newCall(okhttpRequest).execute()).isSuccessful()) {
                return (PurgeLemurRequestDataResponse)ObjectMappers.JSON_MAPPER.readValue(response.body().string(), PurgeLemurRequestDataResponse.class);
            }
            throw new ApiError(response.code(), ObjectMappers.JSON_MAPPER.readValue(response.body().string(), Object.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

