/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.assemblyai.api.core.ObjectMappers;
import com.assemblyai.api.resources.transcripts.types.AudioIntelligenceModelStatus;
import com.assemblyai.api.resources.transcripts.types.ContentSafetyLabelResult;
import com.assemblyai.api.resources.transcripts.types.SeverityScoreSummary;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ContentSafetyLabelsResult {
    private final AudioIntelligenceModelStatus status;
    private final List<ContentSafetyLabelResult> results;
    private final Map<String, Double> summary;
    private final Map<String, SeverityScoreSummary> severityScoreSummary;
    private final Map<String, Object> additionalProperties;

    private ContentSafetyLabelsResult(AudioIntelligenceModelStatus status, List<ContentSafetyLabelResult> results, Map<String, Double> summary, Map<String, SeverityScoreSummary> severityScoreSummary, Map<String, Object> additionalProperties) {
        this.status = status;
        this.results = results;
        this.summary = summary;
        this.severityScoreSummary = severityScoreSummary;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="status")
    public AudioIntelligenceModelStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="results")
    public List<ContentSafetyLabelResult> getResults() {
        return this.results;
    }

    @JsonProperty(value="summary")
    public Map<String, Double> getSummary() {
        return this.summary;
    }

    @JsonProperty(value="severity_score_summary")
    public Map<String, SeverityScoreSummary> getSeverityScoreSummary() {
        return this.severityScoreSummary;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContentSafetyLabelsResult && this.equalTo((ContentSafetyLabelsResult)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContentSafetyLabelsResult other) {
        return this.status.equals(other.status) && this.results.equals(other.results) && this.summary.equals(other.summary) && this.severityScoreSummary.equals(other.severityScoreSummary);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.results, this.summary, this.severityScoreSummary);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static StatusStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements StatusStage,
    _FinalStage {
        private AudioIntelligenceModelStatus status;
        private Map<String, SeverityScoreSummary> severityScoreSummary = new LinkedHashMap<String, SeverityScoreSummary>();
        private Map<String, Double> summary = new LinkedHashMap<String, Double>();
        private List<ContentSafetyLabelResult> results = new ArrayList<ContentSafetyLabelResult>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ContentSafetyLabelsResult other) {
            this.status(other.getStatus());
            this.results(other.getResults());
            this.summary(other.getSummary());
            this.severityScoreSummary(other.getSeverityScoreSummary());
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public _FinalStage status(AudioIntelligenceModelStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage severityScoreSummary(String key, SeverityScoreSummary value) {
            this.severityScoreSummary.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllSeverityScoreSummary(Map<String, SeverityScoreSummary> severityScoreSummary) {
            this.severityScoreSummary.putAll(severityScoreSummary);
            return this;
        }

        @Override
        @JsonSetter(value="severity_score_summary", nulls=Nulls.SKIP)
        public _FinalStage severityScoreSummary(Map<String, SeverityScoreSummary> severityScoreSummary) {
            this.severityScoreSummary.clear();
            this.severityScoreSummary.putAll(severityScoreSummary);
            return this;
        }

        @Override
        public _FinalStage summary(String key, Double value) {
            this.summary.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllSummary(Map<String, Double> summary) {
            this.summary.putAll(summary);
            return this;
        }

        @Override
        @JsonSetter(value="summary", nulls=Nulls.SKIP)
        public _FinalStage summary(Map<String, Double> summary) {
            this.summary.clear();
            this.summary.putAll(summary);
            return this;
        }

        @Override
        public _FinalStage addAllResults(List<ContentSafetyLabelResult> results) {
            this.results.addAll(results);
            return this;
        }

        @Override
        public _FinalStage addResults(ContentSafetyLabelResult results) {
            this.results.add(results);
            return this;
        }

        @Override
        @JsonSetter(value="results", nulls=Nulls.SKIP)
        public _FinalStage results(List<ContentSafetyLabelResult> results) {
            this.results.clear();
            this.results.addAll(results);
            return this;
        }

        @Override
        public ContentSafetyLabelsResult build() {
            return new ContentSafetyLabelsResult(this.status, this.results, this.summary, this.severityScoreSummary, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ContentSafetyLabelsResult build();

        public _FinalStage results(List<ContentSafetyLabelResult> var1);

        public _FinalStage addResults(ContentSafetyLabelResult var1);

        public _FinalStage addAllResults(List<ContentSafetyLabelResult> var1);

        public _FinalStage summary(Map<String, Double> var1);

        public _FinalStage putAllSummary(Map<String, Double> var1);

        public _FinalStage summary(String var1, Double var2);

        public _FinalStage severityScoreSummary(Map<String, SeverityScoreSummary> var1);

        public _FinalStage putAllSeverityScoreSummary(Map<String, SeverityScoreSummary> var1);

        public _FinalStage severityScoreSummary(String var1, SeverityScoreSummary var2);
    }

    public static interface StatusStage {
        public _FinalStage status(AudioIntelligenceModelStatus var1);

        public Builder from(ContentSafetyLabelsResult var1);
    }
}

