/*
 * Decompiled with CFR 0.152.
 */
package com.assemblyai.api.resources.transcripts.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public final class SummaryType {
    public static final SummaryType GIST = new SummaryType(Value.GIST, "gist");
    public static final SummaryType HEADLINE = new SummaryType(Value.HEADLINE, "headline");
    public static final SummaryType BULLETS = new SummaryType(Value.BULLETS, "bullets");
    public static final SummaryType BULLETS_VERBOSE = new SummaryType(Value.BULLETS_VERBOSE, "bullets_verbose");
    public static final SummaryType PARAGRAPH = new SummaryType(Value.PARAGRAPH, "paragraph");
    private final Value value;
    private final String string;

    SummaryType(Value value, String string) {
        this.value = value;
        this.string = string;
    }

    public Value getEnumValue() {
        return this.value;
    }

    @JsonValue
    public String toString() {
        return this.string;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof SummaryType && this.string.equals(((SummaryType)other).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public <T> T visit(Visitor<T> visitor) {
        switch (this.value) {
            case GIST: {
                return visitor.visitGist();
            }
            case HEADLINE: {
                return visitor.visitHeadline();
            }
            case BULLETS: {
                return visitor.visitBullets();
            }
            case BULLETS_VERBOSE: {
                return visitor.visitBulletsVerbose();
            }
            case PARAGRAPH: {
                return visitor.visitParagraph();
            }
        }
        return visitor.visitUnknown(this.string);
    }

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public static SummaryType valueOf(String value) {
        switch (value) {
            case "gist": {
                return GIST;
            }
            case "headline": {
                return HEADLINE;
            }
            case "bullets": {
                return BULLETS;
            }
            case "bullets_verbose": {
                return BULLETS_VERBOSE;
            }
            case "paragraph": {
                return PARAGRAPH;
            }
        }
        return new SummaryType(Value.UNKNOWN, value);
    }

    public static interface Visitor<T> {
        public T visitBullets();

        public T visitBulletsVerbose();

        public T visitGist();

        public T visitHeadline();

        public T visitParagraph();

        public T visitUnknown(String var1);
    }

    public static enum Value {
        BULLETS,
        BULLETS_VERBOSE,
        GIST,
        HEADLINE,
        PARAGRAPH,
        UNKNOWN;

    }
}

