/*
 * Decompiled with CFR 0.152.
 */
package com.assertthat.plugins.standalone;

import com.assertthat.plugins.standalone.OkHttpClientBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.logging.Logger;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class APIUtil {
    private static final Logger LOGGER = Logger.getLogger(APIUtil.class.getName());
    private static final String USER_AGENT = "Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:47.0) Gecko/20100101 Firefox/47.0";
    private String featuresUrl;
    private String reportUrl;
    private OkHttpClient client;

    public APIUtil(String projectId, String accessKey, String secretKey, String token, String proxyURI, String proxyUsername, String proxyPassword, String jiraServerURL, boolean ignoreCertErrors) {
        if (jiraServerURL != null) {
            this.featuresUrl = jiraServerURL + "/rest/assertthat/latest/project/" + projectId + "/client/features";
            this.reportUrl = jiraServerURL + "/rest/assertthat/latest/project/" + projectId + "/client/report";
        } else {
            this.featuresUrl = "https://bdd.assertthat.app/rest/api/1/project/" + projectId + "/features";
            this.reportUrl = "https://bdd.assertthat.app/rest/api/1/project/" + projectId + "/report";
        }
        OkHttpClientBuilder builder = new OkHttpClientBuilder();
        builder.authenticated(accessKey, secretKey, token);
        if (ignoreCertErrors) {
            builder.ignoringCertificate();
        }
        if (proxyURI != null && !proxyURI.trim().isEmpty()) {
            URL url;
            try {
                url = new URL(proxyURI);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("[ERROR] Parsing proxy URL: " + e.getMessage());
            }
            builder.withProxy(url.getHost(), url.getPort());
        }
        if (proxyUsername != null && !proxyUsername.trim().isEmpty() && proxyPassword != null && !proxyPassword.trim().isEmpty()) {
            builder.withProxyAuth(proxyUsername, proxyPassword);
        }
        this.client = builder.build();
    }

    public File download(File targetDir, String mode, String jql, String tags, boolean isNumbered, boolean cleanupFeatures) throws IOException {
        if (cleanupFeatures && targetDir.exists()) {
            for (File f : targetDir.listFiles()) {
                if (!f.getName().endsWith(".feature")) continue;
                f.delete();
            }
        } else {
            targetDir.mkdirs();
        }
        HttpUrl.Builder httpBuilder = HttpUrl.parse((String)this.featuresUrl).newBuilder();
        if (mode != null) {
            httpBuilder.addQueryParameter("mode", mode.trim());
        }
        if (tags != null) {
            httpBuilder.addQueryParameter("tags", tags.trim());
        }
        if (jql != null) {
            httpBuilder.addQueryParameter("jql", jql.trim());
        }
        httpBuilder.addQueryParameter("numbered", String.valueOf(isNumbered));
        Request.Builder request = new Request.Builder().url(httpBuilder.build()).addHeader("User-Agent", USER_AGENT).addHeader("X-Atlassian-Token", "no-check");
        Response response = this.client.newCall(request.build()).execute();
        if (!response.isSuccessful()) {
            throw new IOException("Failed to download file: " + response);
        }
        File zip = File.createTempFile("arc", ".zip", targetDir);
        FileOutputStream fos = new FileOutputStream(zip);
        fos.write(response.body().bytes());
        fos.close();
        return zip;
    }

    public Long upload(Long runId, String runName, String filePath, String type, String metadata, String jql) throws IOException, JSONException {
        Request request;
        Response response;
        File fileToUpload = new File(filePath);
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", fileToUpload.getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (File)fileToUpload)).build();
        HttpUrl.Builder httpBuilder = HttpUrl.parse((String)this.reportUrl).newBuilder();
        httpBuilder.addQueryParameter("runName", runName);
        httpBuilder.addQueryParameter("runId", runId.toString());
        httpBuilder.addQueryParameter("type", type);
        if (jql != null) {
            httpBuilder.addQueryParameter("jql", jql.trim());
        }
        if (metadata != null) {
            httpBuilder.addQueryParameter("metadata", URLEncoder.encode(metadata, "UTF-8"));
        }
        if ((response = this.client.newCall(request = new Request.Builder().url(httpBuilder.build()).post((RequestBody)requestBody).addHeader("X-Atlassian-Token", "no-check").build()).execute()).isSuccessful()) {
            JSONObject responseJson = new JSONObject(response.body().string());
            return Long.valueOf(responseJson.getString("runId"));
        }
        LOGGER.warning(response.body().string());
        LOGGER.warning("Failed to process " + filePath);
        return runId;
    }
}

