/*
 * Decompiled with CFR 0.152.
 */
package com.assertthat.plugins.standalone;

import com.assertthat.plugins.standalone.APIUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

class OkHttpClientBuilder {
    private static final Logger LOGGER = Logger.getLogger(APIUtil.class.getName());
    private OkHttpClient.Builder builder = new OkHttpClient.Builder();

    OkHttpClientBuilder() {
    }

    OkHttpClientBuilder authenticated(String username, String password, String token) {
        this.builder.addInterceptor((Interceptor)(token != null ? new TokenAuthInterceptor(token) : new BasicAuthInterceptor(username, password)));
        return this;
    }

    OkHttpClientBuilder ignoringCertificate() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            this.builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]);
            this.builder.hostnameVerifier((hostname, session) -> true);
        }
        catch (Exception e) {
            LOGGER.severe("Error configuring ssl socket factory: " + e.getMessage());
        }
        return this;
    }

    OkHttpClientBuilder withProxy(String proxyHost, int proxyPort) {
        this.builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort)));
        return this;
    }

    OkHttpClientBuilder withProxyAuth(String username, String password) {
        Authenticator proxyAuthenticator = (route, response) -> {
            String credential = Credentials.basic((String)username, (String)password);
            return response.request().newBuilder().header("Proxy-Authorization", credential).build();
        };
        this.builder.proxyAuthenticator(proxyAuthenticator);
        return this;
    }

    OkHttpClient build() {
        return this.builder.build();
    }

    class TokenAuthInterceptor
    implements Interceptor {
        private String token;

        TokenAuthInterceptor(String token) {
            this.token = token;
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            Request authenticatedRequest = request.newBuilder().header("Authorization", "Bearer " + this.token).header("X-Atlassian-Token", "no-check").build();
            return chain.proceed(authenticatedRequest);
        }
    }

    class BasicAuthInterceptor
    implements Interceptor {
        private String credentials;

        BasicAuthInterceptor(String user, String password) {
            this.credentials = Credentials.basic((String)user, (String)password);
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            Request authenticatedRequest = request.newBuilder().header("Authorization", this.credentials).header("X-Atlassian-Token", "no-check").build();
            return chain.proceed(authenticatedRequest);
        }
    }
}

