/*
 * Decompiled with CFR 0.152.
 */
package com.assertthat.selenium_shutterbug.utils.image;

import com.assertthat.selenium_shutterbug.utils.file.FileUtil;
import com.assertthat.selenium_shutterbug.utils.image.UnableToCompareImagesException;
import com.assertthat.selenium_shutterbug.utils.web.Coordinates;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.io.File;

public class ImageProcessor {
    private static final int ARCH_SIZE = 10;
    private static float[] matrix = new float[49];
    private static double pixelError = Double.MAX_VALUE;

    public static BufferedImage blur(BufferedImage sourceImage) {
        ConvolveOp options = new ConvolveOp(new Kernel(7, 7, matrix), 1, null);
        return options.filter(sourceImage, null);
    }

    public static BufferedImage highlight(BufferedImage sourceImage, Coordinates coords, Color color, int lineWidth) {
        int defaultLineWidth = 3;
        Graphics2D g = sourceImage.createGraphics();
        g.setPaint(color);
        g.setStroke(new BasicStroke(lineWidth == 0 ? (float)defaultLineWidth : (float)lineWidth));
        g.drawRoundRect(coords.getX(), coords.getY(), coords.getWidth(), coords.getHeight(), 10, 10);
        g.dispose();
        return sourceImage;
    }

    public static BufferedImage addText(BufferedImage sourceImage, int x, int y, String text, Color color, Font font) {
        Graphics2D g = sourceImage.createGraphics();
        g.setPaint(color);
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        g.drawString(text, x, y);
        g.dispose();
        return sourceImage;
    }

    public static BufferedImage getElement(BufferedImage sourceImage, Coordinates coords) {
        return sourceImage.getSubimage(coords.getX(), coords.getY(), coords.getWidth(), coords.getHeight());
    }

    public static BufferedImage blurArea(BufferedImage sourceImage, Coordinates coords) {
        BufferedImage blurredImage = ImageProcessor.blur(sourceImage.getSubimage(coords.getX(), coords.getY(), coords.getWidth(), coords.getHeight()));
        BufferedImage combined = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 2);
        Graphics2D g = combined.createGraphics();
        g.drawImage((Image)sourceImage, 0, 0, null);
        g.drawImage((Image)blurredImage, coords.getX(), coords.getY(), null);
        g.dispose();
        return combined;
    }

    public static BufferedImage monochromeArea(BufferedImage sourceImage, Coordinates coords) {
        BufferedImage monochromedImage = ImageProcessor.convertToGrayAndWhite(sourceImage.getSubimage(coords.getX(), coords.getY(), coords.getWidth(), coords.getHeight()));
        BufferedImage combined = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 2);
        Graphics2D g = combined.createGraphics();
        g.drawImage((Image)sourceImage, 0, 0, null);
        g.drawImage((Image)monochromedImage, coords.getX(), coords.getY(), null);
        g.dispose();
        return combined;
    }

    public static BufferedImage blurExceptArea(BufferedImage sourceImage, Coordinates coords) {
        BufferedImage subImage = sourceImage.getSubimage(coords.getX(), coords.getY(), coords.getWidth(), coords.getHeight());
        BufferedImage blurredImage = ImageProcessor.blur(sourceImage);
        BufferedImage combined = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 2);
        Graphics2D g = combined.createGraphics();
        g.drawImage((Image)blurredImage, 0, 0, null);
        g.drawImage((Image)subImage, coords.getX(), coords.getY(), null);
        g.dispose();
        return combined;
    }

    public static BufferedImage cropAround(BufferedImage sourceImage, Coordinates coords, int offsetX, int offsetY) {
        BufferedImage subImage = sourceImage.getSubimage(coords.getX() - offsetX, coords.getY() - offsetY, coords.getWidth() + offsetX * 2, coords.getHeight() + offsetY * 2);
        return subImage;
    }

    public static BufferedImage addTitle(BufferedImage sourceImage, String title, Color color, Font textFont) {
        int textOffset = 5;
        BufferedImage combined = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight() + textFont.getSize(), 2);
        Graphics2D g = combined.createGraphics();
        g.drawImage((Image)sourceImage, 0, textFont.getSize() + textOffset, null);
        ImageProcessor.addText(combined, 0, textFont.getSize(), title, color, textFont);
        g.dispose();
        return combined;
    }

    public static BufferedImage convertToGrayAndWhite(BufferedImage sourceImage) {
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        op.filter(sourceImage, sourceImage);
        return sourceImage;
    }

    public static boolean imagesAreEquals(BufferedImage image1, BufferedImage image2, double deviation) {
        int width1 = image1.getWidth(null);
        int width2 = image2.getWidth(null);
        int height1 = image1.getHeight(null);
        int height2 = image2.getHeight(null);
        if (width1 != width2 || height1 != height2) {
            throw new UnableToCompareImagesException("Images dimensions mismatch: image1 - " + width1 + "x" + height1 + "; image2 - " + width2 + "x" + height2);
        }
        long diff = 0L;
        for (int y = 0; y < height1; ++y) {
            for (int x = 0; x < width1; ++x) {
                int rgb1 = image1.getRGB(x, y);
                int rgb2 = image2.getRGB(x, y);
                int r1 = rgb1 >> 16 & 0xFF;
                int g1 = rgb1 >> 8 & 0xFF;
                int b1 = rgb1 & 0xFF;
                int r2 = rgb2 >> 16 & 0xFF;
                int g2 = rgb2 >> 8 & 0xFF;
                int b2 = rgb2 & 0xFF;
                diff += (long)Math.abs(r1 - r2);
                diff += (long)Math.abs(g1 - g2);
                diff += (long)Math.abs(b1 - b2);
            }
        }
        double n = width1 * height1 * 3;
        double p = (double)diff / n / 255.0;
        return p == 0.0 || p <= deviation;
    }

    public static boolean imagesAreEqualsWithDiff(BufferedImage image1, BufferedImage image2, String pathFileName, double deviation) {
        BufferedImage output = new BufferedImage(image1.getWidth(), image1.getHeight(), 1);
        int width1 = image1.getWidth(null);
        int width2 = image2.getWidth(null);
        int height1 = image1.getHeight(null);
        int height2 = image2.getHeight(null);
        if (width1 != width2 || height1 != height2) {
            throw new UnableToCompareImagesException("Images dimensions mismatch: image1 - " + width1 + "x" + height1 + "; image2 - " + width2 + "x" + height2);
        }
        long diff = 0L;
        long recordedDiff = 0L;
        for (int y = 0; y < height1; ++y) {
            for (int x = 0; x < width1; ++x) {
                recordedDiff = diff;
                int rgb1 = image1.getRGB(x, y);
                int rgb2 = image2.getRGB(x, y);
                int r1 = rgb1 >> 16 & 0xFF;
                int g1 = rgb1 >> 8 & 0xFF;
                int b1 = rgb1 & 0xFF;
                int r2 = rgb2 >> 16 & 0xFF;
                int g2 = rgb2 >> 8 & 0xFF;
                int b2 = rgb2 & 0xFF;
                diff += (long)Math.abs(r1 - r2);
                diff += (long)Math.abs(g1 - g2);
                if ((diff += (long)Math.abs(b1 - b2)) > recordedDiff) {
                    output.setRGB(x, y, new Color(255, 0, 0).getRGB() & rgb1);
                    continue;
                }
                output.setRGB(x, y, rgb1);
            }
        }
        int colourSpaceBytes = 3;
        double totalPixels = width1 * height1 * colourSpaceBytes;
        pixelError = (double)diff / totalPixels / 255.0;
        if (pixelError > 0.0) {
            FileUtil.writeImage(output, "png", new File(pathFileName + ".png"));
        }
        return pixelError == 0.0 || pixelError <= deviation;
    }

    public static BufferedImage scale(BufferedImage source, double ratio) {
        int w = (int)((double)source.getWidth() * ratio);
        int h = (int)((double)source.getHeight() * ratio);
        BufferedImage scaledImage = ImageProcessor.getCompatibleImage(w, h);
        Graphics2D resultGraphics = scaledImage.createGraphics();
        resultGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        resultGraphics.drawImage(source, 0, 0, w, h, null);
        resultGraphics.dispose();
        return scaledImage;
    }

    private static BufferedImage getCompatibleImage(int w, int h) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(w, h);
        return image;
    }

    static {
        for (int i = 0; i < 49; ++i) {
            ImageProcessor.matrix[i] = 0.020408163f;
        }
    }
}

