/*
 * Decompiled with CFR 0.152.
 */
package com.assertthat.selenium_shutterbug.core;

import com.assertthat.selenium_shutterbug.core.ElementSnapshot;
import com.assertthat.selenium_shutterbug.core.PageSnapshot;
import com.assertthat.selenium_shutterbug.utils.web.Browser;
import com.assertthat.selenium_shutterbug.utils.web.ScrollStrategy;
import java.util.function.Function;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;

public class Shutterbug {
    private static final int DEFAULT_SCROLL_TIMEOUT = 100;
    private static Function<WebDriver, ?> beforeShootCondition;
    private static int beforeShootTimeout;

    private Shutterbug() {
    }

    public static PageSnapshot shootPage(WebDriver driver) {
        return Shutterbug.shootPage(driver, true);
    }

    public static PageSnapshot shootPage(WebDriver driver, boolean useDevicePixelRatio) {
        Browser browser = new Browser(driver, useDevicePixelRatio);
        PageSnapshot pageScreenshot = new PageSnapshot(driver, browser.getDevicePixelRatio());
        pageScreenshot.setImage(browser.takeScreenshot());
        return pageScreenshot;
    }

    public static PageSnapshot shootPage(WebDriver driver, ScrollStrategy scroll) {
        return Shutterbug.shootPage(driver, scroll, 100);
    }

    public static PageSnapshot shootPage(WebDriver driver, ScrollStrategy scroll, int betweenScrollTimeout) {
        return Shutterbug.shootPage(driver, scroll, betweenScrollTimeout, true);
    }

    public static Shutterbug wait(ExpectedCondition<?> cond, int timeout) {
        beforeShootCondition = cond;
        beforeShootTimeout = timeout;
        return null;
    }

    public static Shutterbug wait(int timeout) {
        beforeShootTimeout = timeout;
        return null;
    }

    public static PageSnapshot shootPage(WebDriver driver, ScrollStrategy scroll, boolean useDevicePixelRatio) {
        return Shutterbug.shootPage(driver, scroll, 0, useDevicePixelRatio);
    }

    public static PageSnapshot shootPage(WebDriver driver, ScrollStrategy scroll, int betweenScrollTimeout, boolean useDevicePixelRatio) {
        Browser browser = new Browser(driver, useDevicePixelRatio);
        browser.setBetweenScrollTimeout(betweenScrollTimeout);
        if (beforeShootCondition != null) {
            browser.setBeforeShootTimeout(beforeShootTimeout);
            browser.setBeforeShootCondition(beforeShootCondition);
        } else if (beforeShootTimeout != 0) {
            browser.setBeforeShootTimeout(beforeShootTimeout);
        }
        PageSnapshot pageScreenshot = new PageSnapshot(driver, browser.getDevicePixelRatio());
        switch (scroll) {
            case VIEWPORT_ONLY: {
                pageScreenshot.setImage(browser.takeScreenshot());
                break;
            }
            case WHOLE_PAGE: {
                pageScreenshot.setImage(browser.takeScreenshotEntirePage());
                break;
            }
            case WHOLE_PAGE_SCROLL_AND_STITCH: {
                pageScreenshot.setImage(browser.takeScreenshotEntirePageDefault());
            }
        }
        return pageScreenshot;
    }

    public static ElementSnapshot shootElementVerticallyCentered(WebDriver driver, WebElement element) {
        return Shutterbug.shootElementVerticallyCentered(driver, element, true);
    }

    public static ElementSnapshot shootElement(WebDriver driver, WebElement element) {
        return Shutterbug.shootElement(driver, element, true);
    }

    public static ElementSnapshot shootElement(WebDriver driver, WebElement element, boolean useDevicePixelRatio) {
        Browser browser = new Browser(driver, useDevicePixelRatio);
        ElementSnapshot elementSnapshot = new ElementSnapshot(driver, browser.getDevicePixelRatio());
        browser.scrollToElement(element);
        elementSnapshot.setImage(browser.takeScreenshot(), browser.getBoundingClientRect(element));
        return elementSnapshot;
    }

    public static ElementSnapshot shootElementVerticallyCentered(WebDriver driver, WebElement element, boolean useDevicePixelRatio) {
        Browser browser = new Browser(driver, useDevicePixelRatio);
        ElementSnapshot elementSnapshot = new ElementSnapshot(driver, browser.getDevicePixelRatio());
        browser.scrollToElementVerticalCentered(element);
        elementSnapshot.setImage(browser.takeScreenshot(), browser.getBoundingClientRect(element));
        return elementSnapshot;
    }
}

