package com.assertthat.selenium_shutterbug.core;

import com.assertthat.selenium_shutterbug.utils.web.ScrollStrategy;
import org.openqa.selenium.*;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;


import java.awt.*;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;



/**
 * Created by Glib_Briia on 29/04/2017.
 */
public class Main {

    public static void main(String ...args) throws InterruptedException {
        System.setProperty("webdriver.chrome.driver", "C:\\work\\drivers\\chromedriver.exe");
        WebDriver driver = new ChromeDriver();
        driver.get("https://www.google.com/imghp");
        WebElement googleLogo = driver.findElement(By.id("hplogo"));
        WebElement searchBox = driver.findElement(By.className("gsfi"));

        searchBox.sendKeys("Testing");

        Shutterbug.shootPage(driver, ScrollStrategy.WHOLE_PAGE_CHROME)
                .blur(searchBox)
                .monochrome(googleLogo)
                .highlightWithText(googleLogo, Color.blue, 3, "Monochromed logo",Color.blue, new Font("SansSerif", Font.BOLD, 20))
                .highlightWithText(searchBox, "Blurred secret words")
                .withTitle("Google home page - " + new Date())
                .withName("home_page")
                .withThumbnail(0.7)
                .save("C:\\testing\\screenshots\\");
        driver.quit();


    }
}
