/*
 * Decompiled with CFR 0.152.
 */
package com.assertthat.selenium_shutterbug.utils.web;

import com.assertthat.selenium_shutterbug.utils.file.FileUtil;
import com.assertthat.selenium_shutterbug.utils.web.Coordinates;
import com.assertthat.selenium_shutterbug.utils.web.UnableTakeSnapshotException;
import com.google.common.collect.ImmutableMap;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import javax.imageio.ImageIO;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.support.events.EventFiringWebDriver;

public class Browser {
    public static final String RELATIVE_COORDS_JS = "js/relative-element-coords.js";
    public static final String MAX_DOC_WIDTH_JS = "js/max-document-width.js";
    public static final String MAX_DOC_HEIGHT_JS = "js/max-document-height.js";
    public static final String VIEWPORT_HEIGHT_JS = "js/viewport-height.js";
    public static final String VIEWPORT_WIDTH_JS = "js/viewport-width.js";
    public static final String SCROLL_TO_JS = "js/scroll-to.js";
    public static final String SCROLL_INTO_VIEW_JS = "js/scroll-element-into-view.js";
    public static final String CURRENT_SCROLL_Y_JS = "js/get-current-scrollY.js";
    public static final String CURRENT_SCROLL_X_JS = "js/get-current-scrollX.js";
    public static final String DEVICE_PIXEL_RATIO = "js/get-device-pixel-ratio.js";
    public static final String ALL_METRICS = "js/all-metrics.js";
    private WebDriver driver;
    private int docHeight = -1;
    private int docWidth = -1;
    private int viewportWidth = -1;
    private int viewportHeight = -1;
    private int scrollTimeout;
    private Double devicePixelRatio = 1.0;

    public Browser(WebDriver driver, boolean useDevicePixelRatio) {
        this.driver = driver;
        if (useDevicePixelRatio) {
            Object devicePixelRatio = this.executeJsScript(DEVICE_PIXEL_RATIO, new Object[0]);
            this.devicePixelRatio = devicePixelRatio instanceof Double ? (Double)devicePixelRatio : (double)((Long)devicePixelRatio).longValue() * 1.0;
        }
    }

    public Double getDevicePixelRatio() {
        return this.devicePixelRatio;
    }

    public static void wait(int milis) {
        try {
            Thread.sleep(milis);
        }
        catch (InterruptedException e) {
            throw new UnableTakeSnapshotException(e);
        }
    }

    public void setScrollTimeout(int scrollTimeout) {
        this.scrollTimeout = scrollTimeout;
    }

    public BufferedImage takeScreenshot() {
        File srcFile = (File)((TakesScreenshot)this.getUnderlyingDriver()).getScreenshotAs(OutputType.FILE);
        try {
            BufferedImage bufferedImage = ImageIO.read(srcFile);
            return bufferedImage;
        }
        catch (IOException e) {
            throw new UnableTakeSnapshotException(e);
        }
        finally {
            if (srcFile.exists()) {
                srcFile.delete();
            }
        }
    }

    public BufferedImage takeScreenshotEntirePage() {
        int _docWidth = this.getDocWidth();
        int _docHeight = this.getDocHeight();
        BufferedImage combinedImage = new BufferedImage(_docWidth, _docHeight, 2);
        Graphics2D g = combinedImage.createGraphics();
        int _viewportWidth = this.getViewportWidth();
        int _viewportHeight = this.getViewportHeight();
        int scrollBarMaxWidth = 40;
        if (_viewportWidth < _docWidth || _viewportHeight < _docHeight && _viewportWidth - 40 < _docWidth) {
            _viewportHeight -= 40;
        }
        if (_viewportHeight < _docHeight) {
            _viewportWidth -= 40;
        }
        int horizontalIterations = (int)Math.ceil((double)_docWidth / (double)_viewportWidth);
        int verticalIterations = (int)Math.ceil((double)_docHeight / (double)_viewportHeight);
        block0: for (int j = 0; j < verticalIterations; ++j) {
            this.scrollTo(0, j * _viewportHeight);
            for (int i = 0; i < horizontalIterations; ++i) {
                this.scrollTo(i * _viewportWidth, _viewportHeight * j);
                Browser.wait(this.scrollTimeout);
                BufferedImage image = this.takeScreenshot();
                g.drawImage((Image)image, this.getCurrentScrollX(), this.getCurrentScrollY(), null);
                if (_docWidth == ((Image)image).getWidth(null) && _docHeight == ((Image)image).getHeight(null)) break block0;
            }
        }
        g.dispose();
        return combinedImage;
    }

    public BufferedImage takeScreenshotEntirePageUsingChromeCommand() {
        BufferedImage bImageFromConvert;
        this.driver = this.getDriverAfterValidation(this.driver);
        try {
            CommandInfo cmd = new CommandInfo("/session/:sessionId/chromium/send_command_and_get_result", HttpMethod.POST);
            Method defineCommand = HttpCommandExecutor.class.getDeclaredMethod("defineCommand", String.class, CommandInfo.class);
            defineCommand.setAccessible(true);
            defineCommand.invoke((Object)((RemoteWebDriver)this.driver).getCommandExecutor(), "sendCommand", cmd);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        int verticalIterations = (int)Math.ceil((double)this.getDocHeight() / (double)this.getViewportHeight());
        for (int j = 0; j < verticalIterations; ++j) {
            this.scrollTo(0, j * this.getViewportHeight());
            Browser.wait(this.scrollTimeout);
        }
        Object metrics = this.evaluate(FileUtil.getJsScript(ALL_METRICS));
        this.sendCommand("Emulation.setDeviceMetricsOverride", metrics);
        Object result = this.sendCommand("Page.captureScreenshot", ImmutableMap.of((Object)"format", (Object)"png", (Object)"fromSurface", (Object)true));
        String base64EncodedPng = (String)((Map)result).get("data");
        ByteArrayInputStream in = new ByteArrayInputStream((byte[])OutputType.BYTES.convertFromBase64Png(base64EncodedPng));
        try {
            bImageFromConvert = ImageIO.read(in);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while converting results from bytes to BufferedImage");
        }
        return bImageFromConvert;
    }

    private RemoteWebDriver getDriverAfterValidation(WebDriver driver) {
        if (driver instanceof EventFiringWebDriver) {
            driver = ((EventFiringWebDriver)this.driver).getWrappedDriver();
        }
        if (driver instanceof ChromeDriver) {
            return (ChromeDriver)driver;
        }
        if (driver instanceof RemoteWebDriver && ((RemoteWebDriver)driver).getCapabilities().getBrowserName().equals("chrome")) {
            return (RemoteWebDriver)driver;
        }
        throw new UnsupportedOperationException("ScrollStrategy.WHOLE_PAGE_CHROME is only applicable for Chrome driver");
    }

    public BufferedImage takeScreenshotScrollHorizontally() {
        BufferedImage combinedImage = new BufferedImage(this.getDocWidth(), this.getViewportHeight(), 2);
        Graphics2D g = combinedImage.createGraphics();
        int horizontalIterations = (int)Math.ceil((double)this.getDocWidth() / (double)this.getViewportWidth());
        for (int i = 0; i < horizontalIterations; ++i) {
            this.scrollTo(i * this.getViewportWidth(), 0);
            Browser.wait(this.scrollTimeout);
            BufferedImage image = this.takeScreenshot();
            g.drawImage((Image)image, this.getCurrentScrollX(), 0, null);
            if (this.getDocWidth() == ((Image)image).getWidth(null)) break;
        }
        g.dispose();
        return combinedImage;
    }

    public BufferedImage takeScreenshotScrollVertically() {
        BufferedImage combinedImage = new BufferedImage(this.getViewportWidth(), this.getDocHeight(), 2);
        Graphics2D g = combinedImage.createGraphics();
        int verticalIterations = (int)Math.ceil((double)this.getDocHeight() / (double)this.getViewportHeight());
        for (int j = 0; j < verticalIterations; ++j) {
            this.scrollTo(0, j * this.getViewportHeight());
            Browser.wait(this.scrollTimeout);
            BufferedImage image = this.takeScreenshot();
            g.drawImage((Image)image, 0, this.getCurrentScrollY(), null);
            if (this.getDocHeight() == ((Image)image).getHeight(null)) break;
        }
        g.dispose();
        return combinedImage;
    }

    public WebDriver getUnderlyingDriver() {
        return this.driver;
    }

    public int getCurrentScrollX() {
        return (int)((double)((Long)this.executeJsScript(CURRENT_SCROLL_X_JS, new Object[0])).longValue() * this.devicePixelRatio);
    }

    public int getCurrentScrollY() {
        return (int)((double)((Long)this.executeJsScript(CURRENT_SCROLL_Y_JS, new Object[0])).longValue() * this.devicePixelRatio);
    }

    public int getDocWidth() {
        return this.docWidth != -1 ? this.docWidth : (int)((double)((Long)this.executeJsScript(MAX_DOC_WIDTH_JS, new Object[0])).longValue() * this.devicePixelRatio);
    }

    public int getDocHeight() {
        return this.docHeight != -1 ? this.docHeight : (int)((double)((Long)this.executeJsScript(MAX_DOC_HEIGHT_JS, new Object[0])).longValue() * this.devicePixelRatio);
    }

    public int getViewportWidth() {
        return this.viewportWidth != -1 ? this.viewportWidth : (int)((double)((Long)this.executeJsScript(VIEWPORT_WIDTH_JS, new Object[0])).longValue() * this.devicePixelRatio);
    }

    public int getViewportHeight() {
        return this.viewportHeight != -1 ? this.viewportHeight : (int)((double)((Long)this.executeJsScript(VIEWPORT_HEIGHT_JS, new Object[0])).intValue() * this.devicePixelRatio);
    }

    public Coordinates getBoundingClientRect(WebElement element) {
        String script = FileUtil.getJsScript(RELATIVE_COORDS_JS);
        ArrayList list = (ArrayList)this.executeJsScript(RELATIVE_COORDS_JS, element);
        Point start = new Point(Integer.parseInt((String)list.get(0)), Integer.parseInt((String)list.get(1)));
        Dimension size = new Dimension(Integer.parseInt((String)list.get(2)), Integer.parseInt((String)list.get(3)));
        return new Coordinates(start, size, this.devicePixelRatio);
    }

    public void scrollToElement(WebElement element) {
        this.executeJsScript(SCROLL_INTO_VIEW_JS, element);
    }

    public void scrollTo(int x, int y) {
        this.executeJsScript(SCROLL_TO_JS, (double)x / this.devicePixelRatio, (double)y / this.devicePixelRatio);
    }

    public Object executeJsScript(String filePath, Object ... arg) {
        String script = FileUtil.getJsScript(filePath);
        JavascriptExecutor js = (JavascriptExecutor)this.driver;
        return js.executeScript(script, arg);
    }

    public Object sendCommand(String cmd, Object params) {
        try {
            Method execute = RemoteWebDriver.class.getDeclaredMethod("execute", String.class, Map.class);
            execute.setAccessible(true);
            Response res = (Response)execute.invoke((Object)this.driver, "sendCommand", ImmutableMap.of((Object)"cmd", (Object)cmd, (Object)"params", (Object)params));
            return res.getValue();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Object evaluate(String script) {
        Object response = this.sendCommand("Runtime.evaluate", ImmutableMap.of((Object)"returnByValue", (Object)true, (Object)"expression", (Object)script));
        Object result = ((Map)response).get("result");
        return ((Map)result).get("value");
    }
}

