/*
 * Decompiled with CFR 0.152.
 */
package com.assertthat.selenium_shutterbug.core;

import com.assertthat.selenium_shutterbug.core.Capture;
import com.assertthat.selenium_shutterbug.core.ElementSnapshot;
import com.assertthat.selenium_shutterbug.core.PageSnapshot;
import com.assertthat.selenium_shutterbug.utils.web.Browser;
import com.assertthat.selenium_shutterbug.utils.web.Coordinates;
import java.util.function.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;

public class Shutterbug {
    private static final int DEFAULT_SCROLL_TIMEOUT = 100;
    private static Function<WebDriver, ?> beforeShootCondition;
    private static int beforeShootTimeout;

    private Shutterbug() {
    }

    public static PageSnapshot shootPage(WebDriver driver) {
        return Shutterbug.shootPage(driver, true);
    }

    public static PageSnapshot shootPage(WebDriver driver, boolean useDevicePixelRatio) {
        Browser browser = new Browser(driver, useDevicePixelRatio);
        PageSnapshot pageScreenshot = new PageSnapshot(driver, browser.getDevicePixelRatio());
        pageScreenshot.setImage(browser.takeScreenshot());
        return pageScreenshot;
    }

    public static PageSnapshot shootPage(WebDriver driver, Capture capture) {
        return Shutterbug.shootPage(driver, capture, 100);
    }

    public static PageSnapshot shootPage(WebDriver driver, Capture capture, int betweenScrollTimeout) {
        return Shutterbug.shootPage(driver, capture, betweenScrollTimeout, true);
    }

    public static Shutterbug wait(ExpectedCondition<?> cond, int timeout) {
        beforeShootCondition = cond;
        beforeShootTimeout = timeout;
        return null;
    }

    public static Shutterbug wait(int timeout) {
        beforeShootTimeout = timeout;
        return null;
    }

    public static PageSnapshot shootPage(WebDriver driver, Capture capture, boolean useDevicePixelRatio) {
        return Shutterbug.shootPage(driver, capture, 0, useDevicePixelRatio);
    }

    public static PageSnapshot shootPage(WebDriver driver, Capture capture, int betweenScrollTimeout, boolean useDevicePixelRatio) {
        Browser browser = new Browser(driver, useDevicePixelRatio);
        browser.setBetweenScrollTimeout(betweenScrollTimeout);
        if (beforeShootCondition != null) {
            browser.setBeforeShootTimeout(beforeShootTimeout);
            browser.setBeforeShootCondition(beforeShootCondition);
        } else if (beforeShootTimeout != 0) {
            browser.setBeforeShootTimeout(beforeShootTimeout);
        }
        PageSnapshot pageScreenshot = new PageSnapshot(driver, browser.getDevicePixelRatio());
        switch (capture) {
            case VIEWPORT: {
                pageScreenshot.setImage(browser.takeScreenshot());
                break;
            }
            case FULL: {
                pageScreenshot.setImage(browser.takeFullPageScreenshot());
                break;
            }
            case VERTICAL_SCROLL: {
                pageScreenshot.setImage(browser.takeFullPageVerticalScreenshot(false, null));
                break;
            }
            case HORIZONTAL_SCROLL: {
                pageScreenshot.setImage(browser.takeFullPageHorizontalScreenshot(false, null));
                break;
            }
            case FULL_SCROLL: {
                pageScreenshot.setImage(browser.takeFullPageScreenshotScroll(false, null));
            }
        }
        return pageScreenshot;
    }

    public static ElementSnapshot shootElementVerticallyCentered(WebDriver driver, WebElement element) {
        return Shutterbug.shootElementVerticallyCentered(driver, element, true);
    }

    public static ElementSnapshot shootElement(WebDriver driver, WebElement element) {
        return Shutterbug.shootElement(driver, element, true);
    }

    public static ElementSnapshot shootElement(WebDriver driver, WebElement element, Capture capture) {
        return Shutterbug.shootElement(driver, element, capture, true);
    }

    public static ElementSnapshot shootElement(WebDriver driver, WebElement element, boolean useDevicePixelRatio) {
        Browser browser = new Browser(driver, useDevicePixelRatio);
        ElementSnapshot elementSnapshot = new ElementSnapshot(driver, browser.getDevicePixelRatio());
        browser.scrollToElement(element);
        elementSnapshot.setImage(browser.takeScreenshot(), browser.getBoundingClientRect(element));
        return elementSnapshot;
    }

    public static ElementSnapshot shootElement(WebDriver driver, WebElement element, Capture capture, boolean useDevicePixelRatio) {
        Browser browser = new Browser(driver, useDevicePixelRatio);
        ElementSnapshot elementSnapshot = new ElementSnapshot(driver, browser.getDevicePixelRatio());
        browser.scrollToElement(element);
        switch (capture) {
            case VIEWPORT: {
                elementSnapshot.setImage(browser.takeElementViewportScreenshot(element));
                break;
            }
            case VERTICAL_SCROLL: {
                elementSnapshot.setImage(browser.takeFullElementVerticalScreenshot(element));
                break;
            }
            case HORIZONTAL_SCROLL: {
                elementSnapshot.setImage(browser.takeFullElementHorizontalScreenshot(element));
                break;
            }
            default: {
                elementSnapshot.setImage(browser.takeFullElementScreenshot(element));
            }
        }
        return elementSnapshot;
    }

    public static ElementSnapshot shootElementVerticallyCentered(WebDriver driver, WebElement element, boolean useDevicePixelRatio) {
        Browser browser = new Browser(driver, useDevicePixelRatio);
        ElementSnapshot elementSnapshot = new ElementSnapshot(driver, browser.getDevicePixelRatio());
        browser.scrollToElementVerticalCentered(element);
        elementSnapshot.setImage(browser.takeScreenshot(), browser.getBoundingClientRect(element));
        return elementSnapshot;
    }

    public static PageSnapshot shootFrame(WebDriver driver, String frameId, Capture capture, boolean useDevicePixelRatio) {
        WebElement frame = driver.findElement(By.id((String)frameId));
        return Shutterbug.shootFrame(driver, frame, capture, 0, useDevicePixelRatio);
    }

    public static PageSnapshot shootFrame(WebDriver driver, WebElement frame, Capture capture, boolean useDevicePixelRatio) {
        return Shutterbug.shootFrame(driver, frame, capture, 0, useDevicePixelRatio);
    }

    public static PageSnapshot shootFrame(WebDriver driver, WebElement frame, Capture capture) {
        return Shutterbug.shootFrame(driver, frame, capture, 0, true);
    }

    public static PageSnapshot shootFrame(WebDriver driver, WebElement frame, Capture capture, int betweenScrollTimeout, boolean useDevicePixelRatio) {
        Browser browser = new Browser(driver, useDevicePixelRatio);
        browser.setBetweenScrollTimeout(betweenScrollTimeout);
        browser.scrollToElement(frame);
        Coordinates coordinates = browser.getBoundingClientRect(frame);
        driver.switchTo().frame(frame);
        if (beforeShootCondition != null) {
            browser.setBeforeShootTimeout(beforeShootTimeout);
            browser.setBeforeShootCondition(beforeShootCondition);
        } else if (beforeShootTimeout != 0) {
            browser.setBeforeShootTimeout(beforeShootTimeout);
        }
        PageSnapshot pageScreenshot = new PageSnapshot(driver, browser.getDevicePixelRatio());
        switch (capture) {
            case VIEWPORT: {
                pageScreenshot.setImage(browser.takeFrameViewportScreenshot());
                break;
            }
            case VERTICAL_SCROLL: {
                pageScreenshot.setImage(browser.takeFullPageVerticalScreenshot(true, coordinates));
                break;
            }
            case HORIZONTAL_SCROLL: {
                pageScreenshot.setImage(browser.takeFullPageHorizontalScreenshot(true, coordinates));
                break;
            }
            default: {
                pageScreenshot.setImage(browser.takeFullPageScreenshotScroll(true, coordinates));
            }
        }
        return pageScreenshot;
    }

    public static PageSnapshot shootFrame(WebDriver driver, String frameId, Capture capture) {
        WebElement frame = driver.findElement(By.id((String)frameId));
        return Shutterbug.shootFrame(driver, frame, capture, true);
    }

    public static PageSnapshot shootFrame(WebDriver driver, String frameId) {
        WebElement frame = driver.findElement(By.id((String)frameId));
        return Shutterbug.shootFrame(driver, frame, Capture.FULL_SCROLL, true);
    }
}

