/*
 * Decompiled with CFR 0.152.
 */
package com.assertthat.selenium_shutterbug.utils.web;

import com.assertthat.selenium_shutterbug.utils.file.FileUtil;
import com.assertthat.selenium_shutterbug.utils.web.Coordinates;
import com.assertthat.selenium_shutterbug.utils.web.UnableTakeSnapshotException;
import com.github.zafarkhaja.semver.Version;
import com.google.common.collect.ImmutableMap;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import javax.imageio.ImageIO;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.support.ui.FluentWait;

public class Browser {
    private static final String RELATIVE_COORDS_JS = "js/relative-element-coords.js";
    private static final String MAX_DOC_WIDTH_JS = "js/max-document-width.js";
    private static final String MAX_DOC_HEIGHT_JS = "js/max-document-height.js";
    private static final String VIEWPORT_HEIGHT_JS = "js/viewport-height.js";
    private static final String VIEWPORT_WIDTH_JS = "js/viewport-width.js";
    private static final String SCROLL_TO_JS = "js/scroll-to.js";
    private static final String SCROLL_ELEMENT = "js/scroll-element.js";
    private static final String SCROLL_INTO_VIEW_JS = "js/scroll-element-into-view.js";
    private static final String SCROLL_INTO_VIEW_VERTICAL_CENTERED_JS = "js/scroll-element-into-view-vertical-centered.js";
    private static final String CURRENT_SCROLL_Y_JS = "js/get-current-scrollY.js";
    private static final String CURRENT_SCROLL_X_JS = "js/get-current-scrollX.js";
    private static final String DEVICE_PIXEL_RATIO = "js/get-device-pixel-ratio.js";
    private static final String ALL_METRICS = "js/all-metrics.js";
    private static final String ELEMENT_CURRENT_SCROLL_X_JS = "js/get-current-element-scrollX.js";
    private static final String ELEMENT_CURRENT_SCROLL_Y_JS = "js/get-current-element-scrollY.js";
    private WebDriver driver;
    private int docHeight = -1;
    private int docWidth = -1;
    private int viewportWidth = -1;
    private int viewportHeight = -1;
    private int betweenScrollTimeout;
    private Function<WebDriver, ?> beforeShootCondition;
    private int beforeShootTimeout;
    private Double devicePixelRatio = 1.0;

    public Browser(WebDriver driver, boolean useDevicePixelRatio) {
        this.driver = driver;
        if (useDevicePixelRatio) {
            Object devicePixelRatio = this.executeJsScript(DEVICE_PIXEL_RATIO, new Object[0]);
            this.devicePixelRatio = devicePixelRatio instanceof Double ? (Double)devicePixelRatio : (double)((Long)devicePixelRatio).longValue() * 1.0;
        }
    }

    public static void wait(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            throw new UnableTakeSnapshotException(e);
        }
    }

    public Double getDevicePixelRatio() {
        return this.devicePixelRatio;
    }

    public void wait(Function<WebDriver, ?> condition, int timeout) {
        if (condition != null) {
            new FluentWait((Object)this.driver).withTimeout(Duration.ofSeconds(timeout)).ignoring(StaleElementReferenceException.class, NoSuchMethodException.class).until(condition);
        } else if (timeout > 0) {
            Browser.wait(timeout);
        }
    }

    public void setBetweenScrollTimeout(int betweenScrollTimeout) {
        this.betweenScrollTimeout = betweenScrollTimeout;
    }

    public void setBeforeShootTimeout(int beforeShootTimeout) {
        this.beforeShootTimeout = beforeShootTimeout;
    }

    public void setBeforeShootCondition(Function<WebDriver, ?> beforeShootCondition) {
        this.beforeShootCondition = beforeShootCondition;
    }

    public BufferedImage takeScreenshot() {
        this.wait(this.beforeShootCondition, this.beforeShootTimeout);
        File srcFile = (File)((TakesScreenshot)this.getUnderlyingDriver()).getScreenshotAs(OutputType.FILE);
        try {
            BufferedImage bufferedImage = ImageIO.read(srcFile);
            return bufferedImage;
        }
        catch (IOException e) {
            throw new UnableTakeSnapshotException(e);
        }
        finally {
            if (srcFile.exists()) {
                srcFile.delete();
            }
        }
    }

    public BufferedImage takeFullPageScreenshot() {
        this.driver = this.unwrapDriver();
        if (this.driver instanceof ChromeDriver) {
            return this.takeFullPageScreenshotChromeCommand();
        }
        if (this.driver instanceof FirefoxDriver) {
            return this.takeFullPageScreesnshotGeckoDriver();
        }
        if (this.driver instanceof RemoteWebDriver) {
            if (((RemoteWebDriver)this.driver).getCapabilities().getBrowserName().equals("chrome")) {
                return this.takeFullPageScreenshotChromeCommand();
            }
            if (((RemoteWebDriver)this.driver).getCapabilities().getBrowserName().equals("firefox")) {
                return this.takeFullPageScreesnshotGeckoDriver();
            }
        }
        return this.takeFullPageScreenshotScroll(false, null);
    }

    private WebDriver unwrapDriver() {
        String[] wrapperClassNames;
        for (String wrapperClassName : wrapperClassNames = new String[]{"org.openqa.selenium.WrapsDriver", "org.openqa.selenium.internal.WrapsDriver"}) {
            try {
                Class<?> clazz = Class.forName(wrapperClassName);
                if (!clazz.isInstance(this.driver)) continue;
                return (WebDriver)clazz.getMethod("getWrappedDriver", new Class[0]).invoke((Object)this.driver, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return this.driver;
    }

    public BufferedImage takeFullPageScreenshotScroll(boolean isFrame, Coordinates coordinates) {
        int docWidth = this.getDocWidth();
        int docHeight = this.getDocHeight();
        BufferedImage combinedImage = new BufferedImage(docWidth, docHeight, 2);
        Graphics2D g = combinedImage.createGraphics();
        int viewportWidth = this.getViewportWidth();
        int viewportHeight = this.getViewportHeight();
        int scrollBarMaxWidth = 40;
        if (viewportWidth < docWidth || viewportHeight < docHeight && viewportWidth - 40 < docWidth) {
            viewportHeight -= 40;
        }
        if (viewportHeight < docHeight) {
            viewportWidth -= 40;
        }
        int horizontalIterations = (int)Math.ceil((double)docWidth / (double)viewportWidth);
        int verticalIterations = (int)Math.ceil((double)docHeight / (double)viewportHeight);
        this.wait(this.beforeShootCondition, this.beforeShootTimeout);
        block0: for (int j = 0; j < verticalIterations; ++j) {
            this.scrollTo(0, j * viewportHeight);
            for (int i = 0; i < horizontalIterations; ++i) {
                this.scrollTo(i * viewportWidth, viewportHeight * j);
                Browser.wait(this.betweenScrollTimeout);
                BufferedImage image = this.takeScreenshot();
                if (isFrame && coordinates != null) {
                    image = image.getSubimage(coordinates.getX() + 1, coordinates.getY() + 1, coordinates.getWidth(), coordinates.getHeight());
                }
                g.drawImage((Image)image, this.getCurrentScrollX(), this.getCurrentScrollY(), null);
                if (docWidth == image.getWidth(null) && docHeight == image.getHeight(null)) break block0;
            }
        }
        g.dispose();
        return combinedImage;
    }

    public BufferedImage takeFullPageHorizontalScreenshot(boolean isFrame, Coordinates coordinates) {
        int docWidth = this.getDocWidth();
        int docHeight = this.getDocHeight();
        int viewportWidth = this.getViewportWidth();
        int viewportHeight = this.getViewportHeight();
        int scrollBarMaxWidth = 40;
        if (viewportWidth < docWidth || viewportHeight < docHeight && viewportWidth - 40 < docWidth) {
            viewportHeight -= 40;
        }
        if (viewportHeight < docHeight) {
            viewportWidth -= 40;
        }
        BufferedImage combinedImage = new BufferedImage(docWidth, viewportHeight, 2);
        Graphics2D g = combinedImage.createGraphics();
        int horizontalIterations = (int)Math.ceil((double)docWidth / (double)viewportWidth);
        for (int i = 0; i < horizontalIterations; ++i) {
            this.scrollTo(i * viewportWidth, 0);
            Browser.wait(this.betweenScrollTimeout);
            BufferedImage image = this.takeScreenshot();
            if (isFrame && coordinates != null) {
                image = image.getSubimage(coordinates.getX() + 1, coordinates.getY(), coordinates.getWidth(), coordinates.getHeight());
            }
            g.drawImage((Image)image, this.getCurrentScrollX(), 0, null);
            if (docWidth == image.getWidth(null)) break;
        }
        g.dispose();
        return combinedImage;
    }

    public BufferedImage takeFullPageVerticalScreenshot(boolean isFrame, Coordinates coordinates) {
        int docWidth = this.getDocWidth();
        int docHeight = this.getDocHeight();
        int viewportWidth = this.getViewportWidth();
        int viewportHeight = this.getViewportHeight();
        int scrollBarMaxWidth = 40;
        if (viewportWidth < docWidth || viewportHeight < docHeight && viewportWidth - 40 < docWidth) {
            viewportHeight -= 40;
        }
        if (viewportHeight < docHeight) {
            viewportWidth -= 40;
        }
        BufferedImage combinedImage = new BufferedImage(viewportWidth, docHeight, 2);
        Graphics2D g = combinedImage.createGraphics();
        int verticalIterations = (int)Math.ceil((double)docHeight / (double)viewportHeight);
        for (int j = 0; j < verticalIterations; ++j) {
            this.scrollTo(0, j * viewportHeight);
            Browser.wait(this.betweenScrollTimeout);
            BufferedImage image = this.takeScreenshot();
            if (isFrame && coordinates != null) {
                image = image.getSubimage(coordinates.getX(), coordinates.getY() + 1, coordinates.getWidth(), coordinates.getHeight());
            }
            g.drawImage((Image)image, 0, this.getCurrentScrollY(), null);
            if (this.getDocHeight() == image.getHeight(null)) break;
        }
        g.dispose();
        return combinedImage;
    }

    public BufferedImage takeFullElementVerticalScreenshot(WebElement element) {
        Coordinates coordinates = this.getBoundingClientRect(element);
        int scrollableHeight = coordinates.getScrollHeight();
        int scrollableWidth = coordinates.getScrollWidth();
        int elementWidth = coordinates.getWidth();
        int elementHeight = coordinates.getHeight();
        int scrollBarMaxWidth = 20;
        if (elementWidth < scrollableWidth || elementHeight < scrollableHeight && elementWidth - 20 < scrollableWidth) {
            elementHeight -= 20;
        }
        if (elementHeight < scrollableHeight) {
            elementWidth -= 20;
        }
        BufferedImage combinedImage = new BufferedImage(elementWidth, scrollableHeight, 2);
        Graphics2D g = combinedImage.createGraphics();
        int verticalIterations = (int)Math.ceil((double)scrollableHeight / (double)elementHeight);
        for (int j = 0; j < verticalIterations; ++j) {
            this.scrollElement(element, 0, j * elementHeight);
            Browser.wait(this.betweenScrollTimeout);
            BufferedImage image = this.takeScreenshot();
            image = image.getSubimage(coordinates.getX(), coordinates.getY() + 1, elementWidth, elementHeight);
            g.drawImage((Image)image, 0, j * this.getElementCurrentScrollY(element), null);
            if (scrollableHeight == image.getHeight(null)) break;
        }
        g.dispose();
        return combinedImage;
    }

    public BufferedImage takeFullElementHorizontalScreenshot(WebElement element) {
        Coordinates coordinates = this.getBoundingClientRect(element);
        int scrollableHeight = coordinates.getScrollHeight();
        int scrollableWidth = coordinates.getScrollWidth();
        int elementWidth = coordinates.getWidth();
        int elementHeight = coordinates.getHeight();
        int scrollBarMaxWidth = 20;
        if (elementWidth < scrollableWidth || elementHeight < scrollableHeight && elementWidth - 20 < scrollableWidth) {
            elementHeight -= 20;
        }
        if (elementHeight < scrollableHeight) {
            elementWidth -= 20;
        }
        BufferedImage combinedImage = new BufferedImage(scrollableWidth, elementHeight, 2);
        Graphics2D g = combinedImage.createGraphics();
        int horizontalIterations = (int)Math.ceil((double)scrollableWidth / (double)elementWidth);
        for (int j = 0; j < horizontalIterations; ++j) {
            this.scrollElement(element, j * elementWidth, 0);
            Browser.wait(this.betweenScrollTimeout);
            BufferedImage image = this.takeScreenshot();
            image = image.getSubimage(coordinates.getX() + 1, coordinates.getY(), elementWidth, elementHeight);
            g.drawImage((Image)image, j * this.getElementCurrentScrollX(element), 0, null);
            if (scrollableWidth == image.getWidth(null)) break;
        }
        g.dispose();
        return combinedImage;
    }

    public BufferedImage takeFullElementScreenshot(WebElement element) {
        Coordinates coordinates = this.getBoundingClientRect(element);
        int scrollableHeight = coordinates.getScrollHeight();
        int scrollableWidth = coordinates.getScrollWidth();
        int elementWidth = coordinates.getWidth();
        int elementHeight = coordinates.getHeight();
        int scrollBarMaxWidth = 20;
        if (elementWidth < scrollableWidth || elementHeight < scrollableHeight && elementWidth - 20 < scrollableWidth) {
            elementHeight -= 20;
        }
        if (elementHeight < scrollableHeight) {
            elementWidth -= 20;
        }
        BufferedImage combinedImage = new BufferedImage(scrollableWidth, scrollableHeight, 2);
        Graphics2D g = combinedImage.createGraphics();
        int horizontalIterations = (int)Math.ceil((double)scrollableWidth / (double)elementWidth);
        int verticalIterations = (int)Math.ceil((double)scrollableHeight / (double)elementHeight);
        this.wait(this.beforeShootCondition, this.beforeShootTimeout);
        block0: for (int j = 0; j < verticalIterations; ++j) {
            this.scrollElement(element, 0, j * elementHeight);
            for (int i = 0; i < horizontalIterations; ++i) {
                this.scrollElement(element, i * elementWidth, elementHeight * j);
                Browser.wait(this.betweenScrollTimeout);
                BufferedImage image = this.takeScreenshot();
                image = image.getSubimage(coordinates.getX() + 1, coordinates.getY() + 1, coordinates.getWidth(), coordinates.getHeight());
                g.drawImage((Image)image, i * this.getElementCurrentScrollX(element), j * this.getElementCurrentScrollY(element), null);
                if (scrollableWidth == image.getWidth(null) && scrollableHeight == image.getHeight(null)) break block0;
            }
        }
        g.dispose();
        return combinedImage;
    }

    public BufferedImage takeElementViewportScreenshot(WebElement element) {
        Coordinates coordinates = this.getBoundingClientRect(element);
        int scrollableHeight = coordinates.getScrollHeight();
        int scrollableWidth = coordinates.getScrollWidth();
        int elementWidth = coordinates.getWidth();
        int elementHeight = coordinates.getHeight();
        int scrollBarMaxWidth = 20;
        if (elementWidth < scrollableWidth || elementHeight < scrollableHeight && elementWidth - 20 < scrollableWidth) {
            elementHeight -= 20;
        }
        if (elementHeight < scrollableHeight) {
            elementWidth -= 20;
        }
        BufferedImage combinedImage = new BufferedImage(elementWidth, elementHeight, 2);
        Graphics2D g = combinedImage.createGraphics();
        this.wait(this.beforeShootCondition, this.beforeShootTimeout);
        BufferedImage image = this.takeScreenshot();
        image = image.getSubimage(coordinates.getX() + 1, coordinates.getY() + 1, coordinates.getWidth(), coordinates.getHeight());
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        return combinedImage;
    }

    public BufferedImage takeFrameViewportScreenshot() {
        int docWidth = this.getDocWidth();
        int docHeight = this.getDocHeight();
        int viewportWidth = this.getViewportWidth();
        int viewportHeight = this.getViewportHeight();
        int scrollBarMaxWidth = 40;
        if (viewportWidth < docWidth || viewportHeight < docHeight && viewportWidth - 40 < docWidth) {
            viewportWidth -= 40;
        }
        if (viewportHeight < docHeight) {
            viewportHeight -= 40;
        }
        BufferedImage combinedImage = new BufferedImage(viewportWidth, viewportHeight, 2);
        Graphics2D g = combinedImage.createGraphics();
        this.wait(this.beforeShootCondition, this.beforeShootTimeout);
        BufferedImage image = this.takeScreenshot();
        g.drawImage((Image)image, this.getCurrentScrollX(), this.getCurrentScrollY(), null);
        g.dispose();
        return combinedImage;
    }

    public BufferedImage takeFullPageScreenshotChromeCommand() {
        Object devicePixelRatio = this.executeJsScript(DEVICE_PIXEL_RATIO, new Object[0]);
        this.devicePixelRatio = devicePixelRatio instanceof Double ? (Double)devicePixelRatio : (double)((Long)devicePixelRatio).longValue() * 1.0;
        this.defineCustomCommand("sendCommand", new CommandInfo("/session/:sessionId/chromium/sendcommandandgetresult", HttpMethod.POST));
        int verticalIterations = (int)Math.ceil((double)this.getDocHeight() / (double)this.getViewportHeight());
        for (int j = 0; j < verticalIterations; ++j) {
            this.scrollTo(0, j * this.getViewportHeight());
            Browser.wait(this.betweenScrollTimeout);
        }
        Object metrics = this.evaluate(FileUtil.getJsScript(ALL_METRICS));
        this.sendCommand("Emulation.setDeviceMetricsOverride", metrics);
        this.wait(this.beforeShootCondition, this.beforeShootTimeout);
        Object result = this.sendCommand("Page.captureScreenshot", ImmutableMap.of((Object)"format", (Object)"png", (Object)"fromSurface", (Object)true));
        this.sendCommand("Emulation.clearDeviceMetricsOverride", ImmutableMap.of());
        return this.decodeBase64EncodedPng((String)((Map)result).get("data"));
    }

    public BufferedImage takeFullPageScreesnshotGeckoDriver() {
        String base64EncodedPng;
        String version = (String)((RemoteWebDriver)this.driver).getCapabilities().getCapability("moz:geckodriverVersion");
        if (version == null || Version.valueOf((String)version).satisfies("<0.24.0")) {
            return this.takeFullPageScreenshotScroll(false, null);
        }
        this.defineCustomCommand("mozFullPageScreenshot", new CommandInfo("/session/:sessionId/moz/screenshot/full", HttpMethod.GET));
        Object result = this.executeCustomCommand("mozFullPageScreenshot");
        if (result instanceof String) {
            base64EncodedPng = (String)result;
        } else if (result instanceof byte[]) {
            base64EncodedPng = new String((byte[])result);
        } else {
            throw new RuntimeException(String.format("Unexpected result for /moz/screenshot/full command: %s", result == null ? "null" : result.getClass().getName() + "instance"));
        }
        return this.decodeBase64EncodedPng(base64EncodedPng);
    }

    public WebDriver getUnderlyingDriver() {
        return this.driver;
    }

    public int getCurrentScrollX() {
        return (int)((double)Integer.parseInt(this.executeJsScript(CURRENT_SCROLL_X_JS, new Object[0]).toString()) * this.devicePixelRatio);
    }

    public int getCurrentScrollY() {
        return (int)((double)Integer.parseInt(this.executeJsScript(CURRENT_SCROLL_Y_JS, new Object[0]).toString()) * this.devicePixelRatio);
    }

    public int getElementCurrentScrollX(WebElement element) {
        return (int)((double)Integer.parseInt(this.executeJsScript(ELEMENT_CURRENT_SCROLL_X_JS, element).toString()) * this.devicePixelRatio);
    }

    public int getElementCurrentScrollY(WebElement element) {
        return (int)((double)Integer.parseInt(this.executeJsScript(ELEMENT_CURRENT_SCROLL_Y_JS, element).toString()) * this.devicePixelRatio);
    }

    public int getDocWidth() {
        if (this.docWidth == -1) {
            this.docWidth = (int)((double)Integer.parseInt(this.executeJsScript(MAX_DOC_WIDTH_JS, new Object[0]).toString()) * this.devicePixelRatio);
        }
        return this.docWidth;
    }

    public int getDocHeight() {
        if (this.docHeight == -1) {
            this.docHeight = (int)((double)Integer.parseInt(this.executeJsScript(MAX_DOC_HEIGHT_JS, new Object[0]).toString()) * this.devicePixelRatio);
        }
        return this.docHeight;
    }

    public int getViewportWidth() {
        if (this.viewportWidth == -1) {
            this.viewportWidth = (int)((double)Integer.parseInt(this.executeJsScript(VIEWPORT_WIDTH_JS, new Object[0]).toString()) * this.devicePixelRatio);
        }
        return this.viewportWidth;
    }

    public int getViewportHeight() {
        if (this.viewportHeight == -1) {
            this.viewportHeight = (int)((double)Integer.parseInt(this.executeJsScript(VIEWPORT_HEIGHT_JS, new Object[0]).toString()) * this.devicePixelRatio);
        }
        return this.viewportHeight;
    }

    public Coordinates getBoundingClientRect(WebElement element) {
        ArrayList list = (ArrayList)this.executeJsScript(RELATIVE_COORDS_JS, element);
        Point start = new Point(Integer.parseInt((String)list.get(0)), Integer.parseInt((String)list.get(1)));
        Dimension size = new Dimension(Integer.parseInt((String)list.get(2)), Integer.parseInt((String)list.get(3)));
        return new Coordinates(start, size, Integer.parseInt((String)list.get(4)), Integer.parseInt((String)list.get(5)), this.devicePixelRatio);
    }

    public void scrollToElement(WebElement element) {
        this.executeJsScript(SCROLL_INTO_VIEW_JS, element);
    }

    public void scrollToElementVerticalCentered(WebElement element) {
        this.executeJsScript(SCROLL_INTO_VIEW_VERTICAL_CENTERED_JS, element);
    }

    public void scrollTo(int x, int y) {
        this.executeJsScript(SCROLL_TO_JS, (double)x / this.devicePixelRatio, (double)y / this.devicePixelRatio);
    }

    public void scrollElement(WebElement element, int x, int y) {
        this.executeJsScript(SCROLL_ELEMENT, element, (double)x / this.devicePixelRatio, (double)y / this.devicePixelRatio);
    }

    public Object executeJsScript(String filePath, Object ... arg) {
        String script = FileUtil.getJsScript(filePath);
        JavascriptExecutor js = (JavascriptExecutor)this.driver;
        return js.executeScript(script, arg);
    }

    public Object sendCommand(String cmd, Object params) {
        try {
            Method execute = RemoteWebDriver.class.getDeclaredMethod("execute", String.class, Map.class);
            execute.setAccessible(true);
            Response res = (Response)execute.invoke((Object)this.driver, "sendCommand", ImmutableMap.of((Object)"cmd", (Object)cmd, (Object)"params", (Object)params));
            return res.getValue();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Object evaluate(String script) {
        Object response = this.sendCommand("Runtime.evaluate", ImmutableMap.of((Object)"returnByValue", (Object)true, (Object)"expression", (Object)script));
        Object result = ((Map)response).get("result");
        return ((Map)result).get("value");
    }

    public Object executeCustomCommand(String commandName) {
        try {
            Method execute = RemoteWebDriver.class.getDeclaredMethod("execute", String.class);
            execute.setAccessible(true);
            Response res = (Response)execute.invoke((Object)this.driver, commandName);
            return res.getValue();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void defineCustomCommand(String name, CommandInfo info) {
        try {
            Method defineCommand = HttpCommandExecutor.class.getDeclaredMethod("defineCommand", String.class, CommandInfo.class);
            defineCommand.setAccessible(true);
            defineCommand.invoke((Object)((RemoteWebDriver)this.driver).getCommandExecutor(), name, info);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private BufferedImage decodeBase64EncodedPng(String base64EncodedPng) {
        BufferedImage bImageFromConvert;
        ByteArrayInputStream in = new ByteArrayInputStream((byte[])OutputType.BYTES.convertFromBase64Png(base64EncodedPng));
        try {
            bImageFromConvert = ImageIO.read(in);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while converting results from bytes to BufferedImage");
        }
        return bImageFromConvert;
    }
}

