/*
 * Decompiled with CFR 0.152.
 */
package com.assertthat.selenium_shutterbug.utils.web;

import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

public class Coordinates {
    private final int width;
    private final int scrollWidth;
    private final int height;
    private final int scrollHeight;
    private final int x;
    private final int y;

    public Coordinates(WebElement element, Double devicePixelRatio) {
        Point point = element.getLocation();
        Dimension size = element.getSize();
        this.width = (int)((double)size.getWidth() * devicePixelRatio);
        this.height = (int)((double)size.getHeight() * devicePixelRatio);
        this.x = (int)((double)point.getX() * devicePixelRatio);
        this.y = (int)((double)point.getY() * devicePixelRatio);
        this.scrollWidth = (int)((double)size.getWidth() * devicePixelRatio);
        this.scrollHeight = (int)((double)size.getHeight() * devicePixelRatio);
    }

    public Coordinates(Point point, Dimension size, int scrollWidth, int scrollHeight, Double devicePixelRatio) {
        this.width = (int)((double)size.getWidth() * devicePixelRatio);
        this.height = (int)((double)size.getHeight() * devicePixelRatio);
        this.x = (int)((double)point.getX() * devicePixelRatio);
        this.y = (int)((double)point.getY() * devicePixelRatio);
        this.scrollWidth = (int)((double)scrollWidth * devicePixelRatio);
        this.scrollHeight = (int)((double)scrollHeight * devicePixelRatio);
    }

    public int getWidth() {
        return this.width;
    }

    public int getScrollHeight() {
        return this.scrollHeight;
    }

    public int getScrollWidth() {
        return this.scrollWidth;
    }

    public int getHeight() {
        return this.height;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }
}

