/*
 * Decompiled with CFR 0.152.
 */
package com.assertthat.selenium_shutterbug.utils.image;

import com.assertthat.selenium_shutterbug.utils.image.UnableToCompareImagesException;
import com.assertthat.selenium_shutterbug.utils.image.model.ImageData;
import com.assertthat.selenium_shutterbug.utils.web.Coordinates;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageProcessor {
    private static final int ARCH_SIZE = 10;
    private static final float[] matrix = new float[49];
    private static double pixelError = Double.MAX_VALUE;

    public static BufferedImage blur(BufferedImage sourceImage) {
        ConvolveOp options = new ConvolveOp(new Kernel(7, 7, matrix), 1, null);
        return options.filter(sourceImage, null);
    }

    public static BufferedImage highlight(BufferedImage sourceImage, Coordinates coords, Color color, int lineWidth) {
        int defaultLineWidth = 3;
        Graphics2D g = sourceImage.createGraphics();
        g.setPaint(color);
        g.setStroke(new BasicStroke(lineWidth == 0 ? (float)defaultLineWidth : (float)lineWidth));
        g.drawRoundRect(coords.getX(), coords.getY(), coords.getWidth(), coords.getHeight(), 10, 10);
        g.dispose();
        return sourceImage;
    }

    public static BufferedImage addText(BufferedImage sourceImage, int x, int y, String text, Color color, Font font) {
        Graphics2D g = sourceImage.createGraphics();
        g.setPaint(color);
        g.setFont(font);
        g.drawString(text, x, y);
        g.dispose();
        return sourceImage;
    }

    public static BufferedImage getElement(BufferedImage sourceImage, Coordinates coords) {
        return sourceImage.getSubimage(coords.getX(), coords.getY(), coords.getWidth(), coords.getHeight());
    }

    public static BufferedImage blurArea(BufferedImage sourceImage, Coordinates coords) {
        BufferedImage blurredImage = ImageProcessor.blur(sourceImage.getSubimage(coords.getX(), coords.getY(), coords.getWidth(), coords.getHeight()));
        return ImageProcessor.getBufferedImage(sourceImage, coords, blurredImage, sourceImage);
    }

    public static BufferedImage monochromeArea(BufferedImage sourceImage, Coordinates coords) {
        BufferedImage monochromedImage = ImageProcessor.convertToGrayAndWhite(sourceImage.getSubimage(coords.getX(), coords.getY(), coords.getWidth(), coords.getHeight()));
        return ImageProcessor.getBufferedImage(sourceImage, coords, monochromedImage, sourceImage);
    }

    public static BufferedImage blurExceptArea(BufferedImage sourceImage, Coordinates coords) {
        BufferedImage subImage = sourceImage.getSubimage(coords.getX(), coords.getY(), coords.getWidth(), coords.getHeight());
        BufferedImage blurredImage = ImageProcessor.blur(sourceImage);
        return ImageProcessor.getBufferedImage(sourceImage, coords, subImage, blurredImage);
    }

    private static BufferedImage getBufferedImage(BufferedImage sourceImage, Coordinates coords, BufferedImage subImage, BufferedImage blurredImage) {
        BufferedImage combined = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 2);
        Graphics2D g = combined.createGraphics();
        g.drawImage((Image)blurredImage, 0, 0, null);
        g.drawImage((Image)subImage, coords.getX(), coords.getY(), null);
        g.dispose();
        return combined;
    }

    public static BufferedImage cropAround(BufferedImage sourceImage, Coordinates coords, int offsetX, int offsetY) {
        return sourceImage.getSubimage(coords.getX() - offsetX, coords.getY() - offsetY, coords.getWidth() + offsetX * 2, coords.getHeight() + offsetY * 2);
    }

    public static BufferedImage addTitle(BufferedImage sourceImage, String title, Color color, Font textFont) {
        int textOffset = 5;
        BufferedImage combined = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight() + textFont.getSize(), 2);
        Graphics2D g = combined.createGraphics();
        g.drawImage((Image)sourceImage, 0, textFont.getSize() + textOffset, null);
        ImageProcessor.addText(combined, 0, textFont.getSize(), title, color, textFont);
        g.dispose();
        return combined;
    }

    public static BufferedImage convertToGrayAndWhite(BufferedImage sourceImage) {
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        op.filter(sourceImage, sourceImage);
        return sourceImage;
    }

    public static boolean imagesAreEquals(BufferedImage image1, BufferedImage image2, double deviation) {
        ImageData image1Data = new ImageData(image1);
        ImageData image2Data = new ImageData(image2);
        if (image1Data.notEqualsDimensions(image2Data)) {
            throw new UnableToCompareImagesException("Images dimensions mismatch: image1 - " + image1Data.getWidth() + "x" + image1Data.getHeight() + "; image2 - " + image2Data.getWidth() + "x" + image2Data.getHeight());
        }
        return image1Data.equalsEachPixels(image2Data, deviation);
    }

    public static boolean imagesAreEqualsWithDiff(BufferedImage image1, BufferedImage image2, String pathFileName, double deviation) {
        ImageData image1Data = new ImageData(image1);
        ImageData image2Data = new ImageData(image2);
        if (image1Data.notEqualsDimensions(image2Data)) {
            throw new UnableToCompareImagesException("Images dimensions mismatch: image1 - " + image1Data.getWidth() + "x" + image1Data.getHeight() + "; image2 - " + image2Data.getWidth() + "x" + image2Data.getHeight());
        }
        return image1Data.equalsEachPixelsWithCreateDifferencesImage(image2Data, deviation, pathFileName);
    }

    public static BufferedImage scale(BufferedImage source, double ratio) {
        return ImageProcessor.cropAndScale(source, ratio, 1.0, 1.0);
    }

    public static BufferedImage cropAndScale(BufferedImage source, double ratio, double cropWidth, double cropHeight) {
        int w = (int)((double)source.getWidth() * ratio);
        int h = (int)((double)source.getHeight() * ratio);
        BufferedImage scaledImage = ImageProcessor.createAndDrawImage(source, w, h);
        return scaledImage.getSubimage(0, 0, (int)((double)w * cropWidth), (int)((double)h * cropHeight));
    }

    public static BufferedImage cropAndScale(BufferedImage source, double ratio, int maxWidth, int maxHeight) {
        int w = (int)((double)source.getWidth() * ratio);
        int h = (int)((double)source.getHeight() * ratio);
        BufferedImage scaledImage = ImageProcessor.createAndDrawImage(source, w, h);
        if (maxWidth != -1 && w > maxWidth) {
            w = maxWidth;
        }
        if (maxHeight != -1 && h > maxHeight) {
            h = maxHeight;
        }
        return scaledImage.getSubimage(0, 0, w, h);
    }

    private static BufferedImage createAndDrawImage(BufferedImage source, int w, int h) {
        BufferedImage scaledImage = ImageProcessor.getCompatibleImage(w, h, source);
        Graphics2D resultGraphics = scaledImage.createGraphics();
        resultGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        resultGraphics.drawImage(source, 0, 0, w, h, null);
        resultGraphics.dispose();
        return scaledImage;
    }

    private static BufferedImage getCompatibleImage(int w, int h, BufferedImage source) {
        BufferedImage bImage = null;
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gd = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            bImage = gc.createCompatibleImage(w, h);
        }
        catch (HeadlessException ge) {
            // empty catch block
        }
        if (bImage == null) {
            boolean hasAlpha = ImageProcessor.hasAlpha(source);
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bImage = new BufferedImage(w, h, type);
        }
        return bImage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bImage = (BufferedImage)image;
            return bImage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public static BufferedImage createImageFromBytes(byte[] imageData) {
        ByteArrayInputStream bais = new ByteArrayInputStream(imageData);
        try {
            return ImageIO.read(bais);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        for (int i = 0; i < 49; ++i) {
            ImageProcessor.matrix[i] = 0.020408163f;
        }
    }
}

