/*
 * Decompiled with CFR 0.152.
 */
package com.asual.lesscss.loader;

import com.asual.lesscss.loader.ResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class StreamResourceLoader
implements ResourceLoader {
    private static final Pattern PATTERN = Pattern.compile("^([\\w]{2,}):(.*)");

    protected abstract String getSchema();

    protected abstract InputStream openStream(String var1) throws IOException;

    @Override
    public boolean exists(String path) throws IOException {
        Matcher m = PATTERN.matcher(path);
        if (m.matches()) {
            if (m.group(1).equals(this.getSchema())) {
                return this.exists(m.group(2));
            }
            return false;
        }
        InputStream stream = this.openStream(path);
        if (stream != null) {
            stream.close();
            return true;
        }
        return false;
    }

    @Override
    public String load(String path, String charset) throws IOException {
        Matcher m = PATTERN.matcher(path);
        if (m.matches()) {
            if (m.group(1).equals(this.getSchema())) {
                return this.load(m.group(2), charset);
            }
            throw new IOException("No such file " + path);
        }
        InputStream is = this.openStream(path);
        if (is != null) {
            return this.readStream(is, charset);
        }
        throw new IOException("No such file " + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readStream(InputStream is, String charset) throws IOException {
        InputStreamReader r = new InputStreamReader(is, charset);
        StringWriter w = new StringWriter();
        try {
            char[] b = new char[4096];
            int c = 0;
            while (c >= 0) {
                c = r.read(b);
                if (c <= 0) continue;
                w.write(b, 0, c);
            }
            String string = w.toString();
            return string;
        }
        finally {
            w.close();
            ((Reader)r).close();
        }
    }
}

