/*
 * Decompiled with CFR 0.152.
 */
package com.asual.lesscss;

import com.asual.lesscss.LessEngine;
import com.asual.lesscss.LessException;
import com.asual.lesscss.ResourceNotFoundException;
import com.asual.lesscss.ResourceUtils;
import com.asual.lesscss.StyleResource;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LessResource
extends StyleResource {
    private final Log logger = LogFactory.getLog(this.getClass());
    private LessEngine engine;

    public LessResource(LessEngine engine, ServletContext servletContext, String uri, String charset, boolean cache, boolean compress) throws ResourceNotFoundException {
        super(servletContext, uri, charset, cache, compress);
        this.engine = engine;
    }

    @Override
    public byte[] getContent() throws LessException, IOException {
        if (this.content == null || !this.cache && this.lastModified < this.getLastModified()) {
            this.logger.debug((Object)"Not using cache.");
            if (this.engine != null) {
                this.logger.debug((Object)"LessEngine available, compiling.");
                this.content = (this.resource instanceof URL ? this.engine.compile((URL)this.resource) : this.engine.compile((File)this.resource)).replaceAll("\\\\n", "\n").getBytes(this.charset);
            } else {
                this.logger.debug((Object)"LessEngine not available, treating as regular resource.");
                this.content = this.resource instanceof URL ? ResourceUtils.readTextUrl((URL)this.resource, this.charset) : ResourceUtils.readTextFile((File)this.resource, this.charset);
            }
            this.lastModified = this.getLastModified();
            if (this.compress) {
                this.logger.debug((Object)"Compressing resource.");
                this.compress();
            }
        } else {
            this.logger.debug((Object)("Using cache, since lastModified: " + this.lastModified + " and getLastModified: " + this.getLastModified()));
        }
        return this.content;
    }

    @Override
    public long getLastModified() throws IOException {
        if (this.lastModified == null || !this.cache) {
            this.lastModified = super.getLastModified();
            String content = new String(this.resource instanceof URL ? ResourceUtils.readTextUrl((URL)this.resource, this.charset) : ResourceUtils.readTextFile((File)this.resource, this.charset));
            String folder = this.path.substring(0, this.path.lastIndexOf(System.getProperty("file.separator")) + 1);
            Pattern p = Pattern.compile("@import\\s+(\"[^\"]*\"|'[^']*')");
            Matcher m = p.matcher(content);
            while (m.find()) {
                long importLastModified;
                String path = folder + m.group(1).replaceAll("\"|'", "");
                File includedFile = new File(path);
                if (!includedFile.exists()) {
                    includedFile = new File(path + ".less");
                }
                if ((importLastModified = includedFile.lastModified()) <= this.lastModified) continue;
                this.lastModified = importLastModified;
            }
        }
        this.logger.debug((Object)("getLastModified() in LessResource: " + this.lastModified));
        return this.lastModified;
    }
}

