/*
 * Decompiled with CFR 0.152.
 */
package com.asual.lesscss;

import com.asual.lesscss.ResourceNotFoundException;
import com.asual.lesscss.ResourceUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Resource {
    protected ServletContext servletContext;
    protected String path;
    protected Object resource;
    protected String charset;
    protected boolean cache;
    protected byte[] content;
    protected Long lastModified;
    protected final Log logger = LogFactory.getLog(this.getClass());

    public Resource(ServletContext servletContext, String uri, String charset, boolean cache) throws ResourceNotFoundException {
        this.servletContext = servletContext;
        this.charset = charset;
        this.cache = cache;
        URL url = this.getUrl(uri);
        File file = this.getFile(uri);
        if (!(url != null || file != null && file.exists())) {
            this.logger.error((Object)("Error processing " + uri + "."));
            throw new ResourceNotFoundException("Error processing " + uri + ".");
        }
        this.path = url != null ? url.getPath() : file.getAbsolutePath();
        this.resource = url != null ? url : file;
    }

    public byte[] getContent() throws Exception {
        if (this.content == null || !this.cache && this.lastModified < this.getLastModified()) {
            this.content = this.resource instanceof URL ? ResourceUtils.readBinaryUrl((URL)this.resource) : ResourceUtils.readBinaryFile((File)this.resource);
            this.lastModified = this.getLastModified();
        }
        return this.content;
    }

    public long getLastModified() throws IOException {
        if (this.lastModified == null || !this.cache) {
            if (this.resource instanceof URL) {
                this.lastModified = ((URL)this.resource).openConnection().getLastModified();
                this.logger.debug((Object)("getLastModified(), URL resource: " + this.lastModified + " - for resource: " + this.resource));
            } else {
                this.lastModified = ((File)this.resource).lastModified();
                this.logger.debug((Object)("getLastModified(), File resource: " + this.lastModified + " - for resource: " + this.resource));
            }
        }
        this.logger.debug((Object)("getLastModified(): " + this.lastModified));
        return this.lastModified;
    }

    protected URL getUrl(String path) {
        try {
            URL url = this.servletContext.getResource("/META-INF" + path);
            if (url != null) {
                return url;
            }
            url = this.servletContext.getResource("/META-INF/resources" + path);
            if (url != null) {
                return url;
            }
            url = this.getClass().getClassLoader().getResource("META-INF" + path);
            if (url != null) {
                return url;
            }
            url = this.getClass().getClassLoader().getResource("META-INF/resources" + path);
            if (url != null) {
                return url;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    protected File getFile(String path) {
        try {
            return new File(this.servletContext.getRealPath(path));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

