/*
 * Decompiled with CFR 0.152.
 */
package com.asual.lesscss;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourcePackage {
    private static final Map<String, String> cache = new ConcurrentHashMap<String, String>();
    private static final Log logger = LogFactory.getLog(ResourcePackage.class);
    private static final List<String> extensions = Arrays.asList("css", "less", "js");
    private static int NAME_FLAG = 1;
    private static int VERSION_FLAG = 2;
    private static int DEFLATE = 32;
    private static String ENCODING = "UTF-8";
    private static String NEW_LINE = "\n";
    private static String SEPARATOR = "-";
    private String[] resources;
    private String version;
    private String name;
    private String extension;

    public ResourcePackage(String[] resources) {
        this.resources = resources;
    }

    public static ResourcePackage fromString(String source) {
        if (!StringUtils.isEmpty((String)source)) {
            try {
                String key;
                String path = null;
                String extension = null;
                int slashIndex = source.lastIndexOf("/");
                int dotIndex = source.lastIndexOf(".");
                if (dotIndex != -1 && slashIndex < dotIndex) {
                    extension = source.substring(dotIndex + 1);
                    path = source.substring(0, dotIndex);
                } else {
                    path = source;
                }
                if (extension != null && !extensions.contains(extension)) {
                    return null;
                }
                String[] parts = path.replaceFirst("^/", "").split(SEPARATOR);
                if (cache.containsValue(source)) {
                    key = ResourcePackage.getKeyFromValue(cache, source);
                } else {
                    key = parts[parts.length - 1];
                    byte[] bytes = null;
                    try {
                        bytes = Base64.decodeBase64((byte[])key.getBytes(ENCODING));
                        bytes = ResourcePackage.inflate(bytes);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    key = new String(bytes, ENCODING);
                }
                Object[] data = key.split(NEW_LINE);
                ResourcePackage rp = new ResourcePackage((String[])ArrayUtils.subarray((Object[])data, (int)1, (int)data.length));
                int mask = Integer.valueOf((String)data[0]);
                if ((mask & NAME_FLAG) != 0) {
                    rp.setName(parts[0]);
                }
                if ((mask & VERSION_FLAG) != 0) {
                    rp.setVersion(parts[rp.getName() != null ? 1 : 0]);
                }
                rp.setExtension(extension);
                return rp;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String toString() {
        try {
            String key;
            if (this.extension != null && !extensions.contains(this.extension)) {
                throw new Exception("Unsupported extension: " + this.extension);
            }
            int mask = 0;
            if (this.name != null) {
                mask |= NAME_FLAG;
            }
            if (this.version != null) {
                mask |= VERSION_FLAG;
            }
            if (!cache.containsKey(key = mask + NEW_LINE + StringUtils.join((Object[])this.resources, (String)NEW_LINE))) {
                byte[] bytes = key.getBytes(ENCODING);
                StringBuilder sb = new StringBuilder();
                sb.append("/");
                sb.append(this.name == null ? "" : this.name + SEPARATOR);
                sb.append(this.version == null ? "" : this.version + SEPARATOR);
                sb.append(Base64.encodeBase64URLSafeString((byte[])(bytes.length < DEFLATE ? bytes : ResourcePackage.deflate(bytes))).replaceAll("-", "+"));
                sb.append(this.extension == null ? "" : "." + this.extension);
                cache.put(key, sb.toString());
            }
            return cache.get(key);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String[] getResources() {
        return this.resources;
    }

    public static <K, V> K getKeyFromValue(Map<K, V> m, V value) {
        for (K o : m.keySet()) {
            if (!m.get(o).equals(value)) continue;
            return o;
        }
        return null;
    }

    private static byte[] deflate(byte[] input) throws IOException {
        Deflater deflater = new Deflater();
        deflater.setLevel(9);
        deflater.setInput(input);
        deflater.finish();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(input.length);
        byte[] buf = new byte[1024];
        while (!deflater.finished()) {
            int count = deflater.deflate(buf);
            baos.write(buf, 0, count);
        }
        baos.close();
        return baos.toByteArray();
    }

    private static byte[] inflate(byte[] output) throws DataFormatException, IOException {
        Inflater inflater = new Inflater();
        inflater.setInput(output);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(output.length);
        byte[] buf = new byte[1024];
        while (!inflater.finished()) {
            int count = inflater.inflate(buf);
            baos.write(buf, 0, count);
        }
        baos.close();
        return baos.toByteArray();
    }
}

