/*
 * Decompiled with CFR 0.152.
 */
package com.asual.lesscss;

import com.asual.lesscss.Resource;
import com.asual.lesscss.ResourceNotFoundException;
import com.asual.lesscss.ResourcePackage;
import com.asual.lesscss.ScriptResource;
import com.asual.lesscss.StyleResource;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 413708886190444579L;
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected Context initialContext = null;
    protected String charset = "UTF-8";
    protected boolean cache = true;
    protected boolean compress = true;
    protected int maxAge = 31556926;
    protected long milliseconds = 1000L;
    protected Map<String, Resource> resources = new HashMap<String, Resource>();
    protected Map<String, String> mimeTypes = new HashMap<String, String>();

    public ResourceServlet() {
        this.mimeTypes.put("css", "text/css");
        this.mimeTypes.put("less", "text/css");
        this.mimeTypes.put("html", "text/html");
        this.mimeTypes.put("htm", "text/html");
        this.mimeTypes.put("js", "text/javascript");
        this.mimeTypes.put("txt", "text/plain");
        this.mimeTypes.put("xml", "text/xml");
        this.mimeTypes.put("gif", "image/gif");
        this.mimeTypes.put("ico", "image/x-icon");
        this.mimeTypes.put("jpeg", "image/jpeg");
        this.mimeTypes.put("jpg", "image/jpeg");
        this.mimeTypes.put("png", "image/png");
        this.mimeTypes.put("svg", "image/svg+xml");
        this.mimeTypes.put("oga", "audio/ogg");
        this.mimeTypes.put("ogg", "audio/ogg");
        this.mimeTypes.put("ogv", "video/ogg");
        this.mimeTypes.put("mp4", "video/mp4");
        this.mimeTypes.put("webm", "video/webm");
        this.mimeTypes.put("ttf", "font/truetype");
        this.mimeTypes.put("otf", "font/opentype");
        this.mimeTypes.put("eot", "application/vnd.ms-fontobject");
        this.mimeTypes.put("woff", "application/x-font-woff");
    }

    public void init() {
        if (this.getServletConfig() != null) {
            if (this.getInitParameter("charset") != null) {
                this.charset = this.getInitParameter("charset");
            }
            if (this.getInitParameter("cache") != null) {
                this.cache = Boolean.valueOf(this.getInitParameter("cache"));
            }
            if (this.getInitParameter("compress") != null) {
                this.compress = Boolean.valueOf(this.getInitParameter("compress"));
            }
        }
        try {
            this.initialContext = new InitialContext();
        }
        catch (NamingException e) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        if (this.initialContext != null) {
            if (this.getJndiParameter("/resource/Charset") != null) {
                this.charset = (String)this.getJndiParameter("/resource/Charset");
            }
            if (this.getJndiParameter("/resource/Cache") != null) {
                this.cache = (Boolean)this.getJndiParameter("/resource/Cache");
            }
            if (this.getJndiParameter("/resource/Compress") != null) {
                this.compress = (Boolean)this.getJndiParameter("/resource/Compress");
            }
        }
    }

    protected Object getJndiParameter(String name) {
        try {
            return this.initialContext.lookup("java:comp/env" + name);
        }
        catch (NamingException namingException) {
            return null;
        }
    }

    protected Resource getResource(String uri) throws ResourceNotFoundException {
        String mimeType = this.getResourceMimeType(uri);
        if (!this.resources.containsKey(uri)) {
            if ("text/css".equals(mimeType)) {
                this.resources.put(uri, new StyleResource(this.getServletContext(), uri, this.charset, this.cache, this.compress));
            } else if ("text/javascript".equals(mimeType)) {
                this.resources.put(uri, new ScriptResource(this.getServletContext(), uri, this.charset, this.cache, this.compress));
            } else {
                this.resources.put(uri, new Resource(this.getServletContext(), uri, this.charset, this.cache));
            }
        }
        return this.resources.get(uri);
    }

    protected byte[] getResourceContent(String uri) throws Exception {
        Resource resource = this.getResource(uri);
        return resource.getContent();
    }

    protected long getResourceLastModified(String uri) throws IOException {
        Resource resource = this.getResource(uri);
        return resource.getLastModified();
    }

    protected String getResourceMimeType(String uri) {
        String extension = uri.substring(uri.lastIndexOf(".") + 1);
        String mimeType = this.mimeTypes.containsKey(extension) ? this.mimeTypes.get(extension) : this.getServletContext().getMimeType(uri);
        return mimeType != null ? mimeType : "application/octet-stream";
    }

    protected byte[] mergeContent(byte[] c1, byte[] c2) throws UnsupportedEncodingException {
        int i;
        byte[] line = "\n".getBytes(this.charset);
        int l1 = c1.length;
        int l2 = l1 != 0 ? line.length : 0;
        int l3 = c2.length;
        byte[] result = new byte[l1 + l2 + l3];
        for (i = 0; i < l1; ++i) {
            result[i] = c1[i];
        }
        for (i = 0; i < l2; ++i) {
            result[i + l1] = line[i];
        }
        for (i = 0; i < l3; ++i) {
            result[i + l1 + l2] = c2[i];
        }
        return result;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            String[] stringArray;
            ResourcePackage rp = ResourcePackage.fromString(request.getPathInfo());
            if (rp != null) {
                stringArray = rp.getResources();
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = request.getRequestURI().replaceAll("/+", "/");
            }
            String[] uri = stringArray;
            String mimeType = this.getResourceMimeType(uri[0]);
            long lastModified = 0L;
            byte[] content = new byte[]{};
            for (String resource : uri) {
                resource = resource.replaceAll("^" + request.getContextPath(), "");
                try {
                    content = this.mergeContent(content, this.getResourceContent(resource));
                }
                catch (IOException e) {
                    this.logger.error((Object)("Cannot find " + resource + "."));
                    response.setStatus(404);
                    return;
                }
                lastModified = Math.max(lastModified, this.getResourceLastModified(resource));
            }
            long ifModifiedSince = request.getDateHeader("If-Modified-Since");
            if (ifModifiedSince != 0L && ifModifiedSince / this.milliseconds == lastModified / this.milliseconds) {
                this.logger.debug((Object)("Return with SC_NOT_MODIFIED, since " + ifModifiedSince + " == " + lastModified));
                response.setStatus(304);
                return;
            }
            if (this.cache) {
                this.maxAge = 0;
            }
            response.setContentType(mimeType + (mimeType.startsWith("text/") ? ";charset=" + this.charset : ""));
            response.setDateHeader("Last-Modified", lastModified);
            response.setDateHeader("Expires", System.currentTimeMillis() + (long)this.maxAge * this.milliseconds);
            response.setHeader("Cache-control", "max-age=" + this.maxAge);
            response.setContentLength(content.length);
            response.getOutputStream().write(content);
            response.getOutputStream().flush();
            response.getOutputStream().close();
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }
}

