/*
 * Decompiled with CFR 0.152.
 */
package com.asual.lesscss;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceUtils {
    private static final Log logger = LogFactory.getLog(ResourceUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readTextUrl(URL source, String encoding) throws IOException {
        byte[] result;
        try {
            URLConnection urlc = source.openConnection();
            StringBuffer sb = new StringBuffer(1024);
            InputStream input = urlc.getInputStream();
            UnicodeReader reader = new UnicodeReader(input, encoding);
            try {
                int r;
                char[] cbuf = new char[32];
                while ((r = reader.read(cbuf, 0, 32)) != -1) {
                    sb.append(cbuf, 0, r);
                }
                result = sb.toString().getBytes(reader.getEncoding());
            }
            finally {
                reader.close();
                input.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)("Can't read '" + source.getFile() + "'."));
            throw e;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readTextFile(File source, String encoding) throws IOException {
        byte[] result;
        try {
            StringBuffer sb = new StringBuffer(1024);
            FileInputStream input = new FileInputStream(source);
            UnicodeReader reader = new UnicodeReader(input, encoding);
            try {
                int r;
                char[] cbuf = new char[32];
                while ((r = reader.read(cbuf, 0, 32)) != -1) {
                    sb.append(cbuf, 0, r);
                }
                result = sb.toString().getBytes(reader.getEncoding());
            }
            finally {
                reader.close();
                input.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)("Can't read '" + source.getAbsolutePath() + "'."));
            throw e;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBinaryUrl(URL source) throws IOException {
        byte[] result;
        try {
            URLConnection urlc = source.openConnection();
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            InputStream input = urlc.getInputStream();
            try {
                byte[] buffer = new byte[1024];
                int bytesRead = -1;
                while ((bytesRead = input.read(buffer)) != -1) {
                    byteStream.write(buffer, 0, bytesRead);
                }
                result = byteStream.toByteArray();
            }
            finally {
                byteStream.close();
                input.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)("Can't read '" + source.getFile() + "'."));
            throw e;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBinaryFile(File source) throws IOException {
        byte[] result;
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            FileInputStream input = new FileInputStream(source);
            try {
                byte[] buffer = new byte[1024];
                int bytesRead = -1;
                while ((bytesRead = input.read(buffer)) != -1) {
                    byteStream.write(buffer, 0, bytesRead);
                }
                result = byteStream.toByteArray();
            }
            finally {
                byteStream.close();
                input.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)("Can't read '" + source.getAbsolutePath() + "'."));
            throw e;
        }
        return result;
    }

    private static class UnicodeReader
    extends Reader {
        PushbackInputStream internalIn;
        InputStreamReader internalIn2 = null;
        String defaultEnc;
        private static final int BOM_SIZE = 4;

        public UnicodeReader(InputStream in, String defaultEnc) {
            this.internalIn = new PushbackInputStream(in, 4);
            this.defaultEnc = defaultEnc;
        }

        public String getEncoding() {
            if (this.internalIn2 == null) {
                return null;
            }
            return this.internalIn2.getEncoding();
        }

        protected void init() throws IOException {
            int unread;
            String encoding;
            if (this.internalIn2 != null) {
                return;
            }
            byte[] bom = new byte[4];
            int n = this.internalIn.read(bom, 0, bom.length);
            if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
                encoding = "UTF-32BE";
                unread = n - 4;
            } else if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
                encoding = "UTF-32LE";
                unread = n - 4;
            } else if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
                encoding = "UTF-8";
                unread = n - 3;
            } else if (bom[0] == -2 && bom[1] == -1) {
                encoding = "UTF-16BE";
                unread = n - 2;
            } else if (bom[0] == -1 && bom[1] == -2) {
                encoding = "UTF-16LE";
                unread = n - 2;
            } else {
                encoding = this.defaultEnc;
                unread = n;
            }
            if (unread > 0) {
                this.internalIn.unread(bom, n - unread, unread);
            }
            this.internalIn2 = encoding == null ? new InputStreamReader(this.internalIn) : new InputStreamReader((InputStream)this.internalIn, encoding);
        }

        @Override
        public void close() throws IOException {
            this.init();
            this.internalIn2.close();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            this.init();
            return this.internalIn2.read(cbuf, off, len);
        }
    }
}

