/*
 * Decompiled with CFR 0.152.
 */
package com.asual.lesscss;

import com.asual.lesscss.Resource;
import com.asual.lesscss.ResourceNotFoundException;
import com.asual.lesscss.ResourceUtils;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSSourceFile;
import com.google.javascript.jscomp.Result;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;

public class ScriptResource
extends Resource {
    protected boolean compress;

    public ScriptResource(ServletContext servletContext, String uri, String charset, boolean cache, boolean compress) throws ResourceNotFoundException {
        super(servletContext, uri, charset, cache);
        this.compress = compress;
    }

    @Override
    public byte[] getContent() throws IOException {
        if (this.content == null || this.content != null && !this.cache && this.lastModified < this.getLastModified()) {
            this.content = this.resource instanceof URL ? ResourceUtils.readTextUrl((URL)this.resource, this.charset) : ResourceUtils.readTextFile((File)this.resource, this.charset);
            this.lastModified = this.getLastModified();
            if (this.compress) {
                this.compress();
            }
        }
        return this.content;
    }

    private void compress() throws UnsupportedEncodingException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayInputStream is = new ByteArrayInputStream(this.content);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)baos, this.charset);
        CompilerOptions options = new CompilerOptions();
        CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(options);
        Compiler.setLoggingLevel((Level)Level.OFF);
        Compiler compiler = new Compiler();
        compiler.disableThreads();
        Result result = compiler.compile(new JSSourceFile[0], new JSSourceFile[]{JSSourceFile.fromInputStream((String)"is", (InputStream)is)}, options);
        if (result.success) {
            Pattern pattern = Pattern.compile("^/\\*.*?\\*/\\s?", 32);
            Matcher matcher = pattern.matcher(new String(this.content, this.charset));
            while (matcher.find()) {
                out.write(matcher.group());
            }
            out.write(compiler.toSource());
            ((Writer)out).flush();
            this.content = baos.toByteArray();
        }
        ((InputStream)is).close();
        ((Writer)out).close();
    }
}

