/*
 * Decompiled with CFR 0.152.
 */
package com.asual.lesscss;

import com.asual.lesscss.Resource;
import com.asual.lesscss.ResourceNotFoundException;
import com.asual.lesscss.ResourceUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import javax.servlet.ServletContext;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.shell.Global;

public class StyleResource
extends Resource {
    protected boolean compress;

    public StyleResource(ServletContext servletContext, String uri, String charset, boolean cache, boolean compress) throws ResourceNotFoundException {
        super(servletContext, uri, charset, cache);
        this.compress = compress;
    }

    public byte[] getContent(String path) throws IOException {
        if (this.content == null || !this.cache && this.lastModified < this.getLastModified()) {
            this.content = this.resource instanceof URL ? ResourceUtils.readTextUrl((URL)this.resource, this.charset) : ResourceUtils.readTextFile((File)this.resource, this.charset);
            this.lastModified = this.getLastModified();
            if (this.compress) {
                this.compress();
            }
        }
        return this.content;
    }

    protected void compress() throws IOException {
        URL cssmin = this.getClass().getClassLoader().getResource("META-INF/cssmin.js");
        Context cx = Context.enter();
        cx.setOptimizationLevel(9);
        Global global = new Global();
        global.init(cx);
        Scriptable scope = cx.initStandardObjects((ScriptableObject)global);
        cx.evaluateString(scope, "var exports = {};", "exports", 1, null);
        cx.evaluateReader(scope, (Reader)new InputStreamReader(cssmin.openConnection().getInputStream()), cssmin.getFile(), 1, null);
        Scriptable exports = (Scriptable)scope.get("exports", scope);
        Scriptable compressor = (Scriptable)exports.get("compressor", exports);
        Function fn = (Function)compressor.get("cssmin", compressor);
        this.content = ((String)Context.call(null, (Callable)fn, (Scriptable)compressor, (Scriptable)compressor, (Object[])new Object[]{new String(this.content, this.charset).replaceFirst("^/\\*", "/*!")})).getBytes(this.charset);
        Context.exit();
    }
}

