/*
 * Decompiled with CFR 0.152.
 */
package com.asual.lesscss;

import com.asual.lesscss.LessEngine;
import com.asual.lesscss.LessException;
import com.asual.lesscss.ResourceNotFoundException;
import com.asual.lesscss.ResourceUtils;
import com.asual.lesscss.StyleResource;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LessResource
extends StyleResource {
    private final Log logger = LogFactory.getLog(this.getClass());
    private LessEngine engine;

    public LessResource(LessEngine engine, ServletContext servletContext, String uri, String charset, boolean cache, boolean compress) throws ResourceNotFoundException {
        super(servletContext, uri, charset, cache, compress);
        this.engine = engine;
    }

    @Override
    public byte[] getContent() throws LessException, IOException {
        if (this.content == null || !this.cache) {
            this.logger.debug((Object)"Not using cache.");
            if (this.engine != null) {
                this.logger.debug((Object)"LessEngine available, compiling.");
                this.content = (this.resource instanceof URL ? this.engine.compile((URL)this.resource) : this.engine.compile((File)this.resource)).replaceAll("\\\\n", "\n").getBytes(this.charset);
            } else {
                this.logger.debug((Object)"LessEngine not available, treating as regular resource.");
                this.content = this.resource instanceof URL ? ResourceUtils.readTextUrl((URL)this.resource, this.charset) : ResourceUtils.readTextFile((File)this.resource, this.charset);
            }
            this.lastModified = super.getLastModified();
            if (this.compress) {
                this.logger.debug((Object)"Compressing resource.");
                this.compress();
            }
        } else {
            this.logger.debug((Object)("Using cache, since lastModified: " + this.lastModified + " and getLastModified: " + this.getLastModified()));
        }
        return this.content;
    }
}

