/*
 * Decompiled with CFR 0.152.
 */
package com.asual.lesscss;

import com.asual.lesscss.LessEngine;
import com.asual.lesscss.LessOptions;
import com.asual.lesscss.LessResource;
import com.asual.lesscss.Resource;
import com.asual.lesscss.ResourceNotFoundException;
import com.asual.lesscss.ResourceServlet;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LessServlet
extends ResourceServlet {
    private static final long serialVersionUID = 413708886190444579L;
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected LessEngine engine;
    protected boolean css;
    protected String lineNumbers;

    @Override
    public void init() {
        if (this.getServletConfig() != null) {
            if (this.getInitParameter("charset") != null) {
                this.charset = this.getInitParameter("charset");
            }
            if (this.getInitParameter("cache") != null) {
                this.cache = Boolean.valueOf(this.getInitParameter("cache"));
            }
            if (this.getInitParameter("compress") != null) {
                this.compress = Boolean.valueOf(this.getInitParameter("compress"));
            }
            if (this.getInitParameter("css") != null) {
                this.css = Boolean.valueOf(this.getInitParameter("css"));
            }
            if (this.getInitParameter("lineNumbers") != null) {
                this.lineNumbers = this.getInitParameter("lineNumbers");
            }
        }
        try {
            this.initialContext = new InitialContext();
        }
        catch (NamingException e) {
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        if (this.initialContext != null) {
            if (this.getJndiParameter("/less/Charset") != null) {
                this.charset = (String)this.getJndiParameter("/less/Charset");
            }
            if (this.getJndiParameter("/less/Cache") != null) {
                this.cache = (Boolean)this.getJndiParameter("/less/Cache");
            }
            if (this.getJndiParameter("/less/Compress") != null) {
                this.compress = (Boolean)this.getJndiParameter("/less/Compress");
            }
            if (this.getJndiParameter("/less/Css") != null) {
                this.css = (Boolean)this.getJndiParameter("/less/Css");
            }
            if (this.getJndiParameter("/less/LineNumbers") != null) {
                this.lineNumbers = (String)this.getJndiParameter("/less/LineNumbers");
            }
        }
        LessOptions options = new LessOptions();
        options.setCharset(this.charset);
        options.setCss(this.css);
        options.setLineNumbers(this.lineNumbers);
        options.setOptimization(Integer.valueOf(this.cache ? 3 : 0));
        this.engine = new LessEngine(options);
    }

    @Override
    protected Resource getResource(String uri) throws ResourceNotFoundException {
        String mimeType = this.getResourceMimeType(uri);
        if (!this.resources.containsKey(uri)) {
            this.logger.debug((Object)("Using new LessResource for uri " + uri));
            if ("text/css".equals(mimeType)) {
                this.resources.put(uri, new LessResource(this.engine, this.getServletContext(), uri, this.charset, this.cache, this.compress));
                return (Resource)this.resources.get(uri);
            }
            return super.getResource(uri);
        }
        this.logger.debug((Object)("Using existing LessResource for uri " + uri));
        return (Resource)this.resources.get(uri);
    }
}

