/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v2.jackson;

import com.asyncapi.v2.model.schema.Schema;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class MessagePayloadDeserializer
extends JsonDeserializer<Object> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectCodec objectCodec = p.getCodec();
        JsonNode node = (JsonNode)objectCodec.readTree(p);
        return this.chooseKnownPojo(node);
    }

    private Object chooseKnownPojo(JsonNode traitsValue) {
        try {
            return this.objectMapper.readValue(traitsValue.toString(), Schema.class);
        }
        catch (Exception e) {
            return traitsValue;
        }
    }
}

