/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v2.jackson;

import com.asyncapi.v2.model.Reference;
import com.asyncapi.v2.model.channel.operation.OperationTrait;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OperationTraitsDeserializer
extends JsonDeserializer<List<Object>> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public List<Object> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectCodec objectCodec = p.getCodec();
        JsonNode node = (JsonNode)objectCodec.readTree(p);
        ArrayList<Object> traits = new ArrayList<Object>();
        node.forEach(traitsValue -> {
            try {
                traits.add(this.chooseKnownPojo((JsonNode)traitsValue));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return traits;
    }

    private Object chooseKnownPojo(JsonNode traitsValue) throws IOException {
        if (traitsValue.get("$ref") != null) {
            return this.objectMapper.readValue(traitsValue.toString(), Reference.class);
        }
        return this.objectMapper.readValue(traitsValue.toString(), OperationTrait.class);
    }
}

