/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v2.model.security_scheme;

import com.asyncapi.v2.model.security_scheme.SecurityScheme;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;

public class OpenIdConnectSecurityScheme
extends SecurityScheme {
    @Nonnull
    @NonNull
    private String openIdConnectUrl;

    public OpenIdConnectSecurityScheme(@Nonnull @NonNull SecurityScheme.Type type, @Nullable String description, @Nonnull @NonNull String openIdConnectUrl) {
        super(type, description);
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (openIdConnectUrl == null) {
            throw new NullPointerException("openIdConnectUrl is marked non-null but is null");
        }
        this.openIdConnectUrl = openIdConnectUrl;
    }

    public static OpenIdConnectSecuritySchemeBuilder openIdConnectSecurityScheme() {
        return new OpenIdConnectSecuritySchemeBuilder();
    }

    @Nonnull
    @NonNull
    public String getOpenIdConnectUrl() {
        return this.openIdConnectUrl;
    }

    public void setOpenIdConnectUrl(@Nonnull @NonNull String openIdConnectUrl) {
        if (openIdConnectUrl == null) {
            throw new NullPointerException("openIdConnectUrl is marked non-null but is null");
        }
        this.openIdConnectUrl = openIdConnectUrl;
    }

    @Override
    public String toString() {
        return "OpenIdConnectSecurityScheme(openIdConnectUrl=" + this.getOpenIdConnectUrl() + ")";
    }

    public OpenIdConnectSecurityScheme() {
    }

    public OpenIdConnectSecurityScheme(@Nonnull @NonNull String openIdConnectUrl) {
        if (openIdConnectUrl == null) {
            throw new NullPointerException("openIdConnectUrl is marked non-null but is null");
        }
        this.openIdConnectUrl = openIdConnectUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenIdConnectSecurityScheme)) {
            return false;
        }
        OpenIdConnectSecurityScheme other = (OpenIdConnectSecurityScheme)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$openIdConnectUrl = this.getOpenIdConnectUrl();
        String other$openIdConnectUrl = other.getOpenIdConnectUrl();
        return !(this$openIdConnectUrl == null ? other$openIdConnectUrl != null : !this$openIdConnectUrl.equals(other$openIdConnectUrl));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OpenIdConnectSecurityScheme;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $openIdConnectUrl = this.getOpenIdConnectUrl();
        result = result * 59 + ($openIdConnectUrl == null ? 43 : $openIdConnectUrl.hashCode());
        return result;
    }

    public static class OpenIdConnectSecuritySchemeBuilder {
        private SecurityScheme.Type type;
        private String description;
        private String openIdConnectUrl;

        OpenIdConnectSecuritySchemeBuilder() {
        }

        public OpenIdConnectSecuritySchemeBuilder type(@Nonnull @NonNull SecurityScheme.Type type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        public OpenIdConnectSecuritySchemeBuilder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public OpenIdConnectSecuritySchemeBuilder openIdConnectUrl(@Nonnull @NonNull String openIdConnectUrl) {
            if (openIdConnectUrl == null) {
                throw new NullPointerException("openIdConnectUrl is marked non-null but is null");
            }
            this.openIdConnectUrl = openIdConnectUrl;
            return this;
        }

        public OpenIdConnectSecurityScheme build() {
            return new OpenIdConnectSecurityScheme(this.type, this.description, this.openIdConnectUrl);
        }

        public String toString() {
            return "OpenIdConnectSecurityScheme.OpenIdConnectSecuritySchemeBuilder(type=" + (Object)((Object)this.type) + ", description=" + this.description + ", openIdConnectUrl=" + this.openIdConnectUrl + ")";
        }
    }
}

