/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v2.model.security_scheme.http;

import com.asyncapi.v2.model.security_scheme.SecurityScheme;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;

public class HttpApiKeySecurityScheme
extends SecurityScheme {
    @Nonnull
    @NonNull
    private String name;
    @CheckForNull
    private ApiKeyLocation in;

    public HttpApiKeySecurityScheme(@Nonnull @NonNull SecurityScheme.Type type, @Nullable String description, @Nonnull @NonNull String name, @Nullable ApiKeyLocation in) {
        super(type, description);
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        this.in = in;
    }

    public static HttpApiKeySecuritySchemeBuilder httpApiKeySecuritySchemeBuilder() {
        return new HttpApiKeySecuritySchemeBuilder();
    }

    @Nonnull
    @NonNull
    public String getName() {
        return this.name;
    }

    @CheckForNull
    public ApiKeyLocation getIn() {
        return this.in;
    }

    public void setName(@Nonnull @NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    public void setIn(@CheckForNull ApiKeyLocation in) {
        this.in = in;
    }

    @Override
    public String toString() {
        return "HttpApiKeySecurityScheme(name=" + this.getName() + ", in=" + (Object)((Object)this.getIn()) + ")";
    }

    public HttpApiKeySecurityScheme() {
    }

    public HttpApiKeySecurityScheme(@Nonnull @NonNull String name, @CheckForNull ApiKeyLocation in) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        this.in = in;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpApiKeySecurityScheme)) {
            return false;
        }
        HttpApiKeySecurityScheme other = (HttpApiKeySecurityScheme)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ApiKeyLocation this$in = this.getIn();
        ApiKeyLocation other$in = other.getIn();
        return !(this$in == null ? other$in != null : !((Object)((Object)this$in)).equals((Object)other$in));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HttpApiKeySecurityScheme;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ApiKeyLocation $in = this.getIn();
        result = result * 59 + ($in == null ? 43 : ((Object)((Object)$in)).hashCode());
        return result;
    }

    public static class HttpApiKeySecuritySchemeBuilder {
        private SecurityScheme.Type type;
        private String description;
        private String name;
        private ApiKeyLocation in;

        HttpApiKeySecuritySchemeBuilder() {
        }

        public HttpApiKeySecuritySchemeBuilder type(@Nonnull @NonNull SecurityScheme.Type type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        public HttpApiKeySecuritySchemeBuilder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public HttpApiKeySecuritySchemeBuilder name(@Nonnull @NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public HttpApiKeySecuritySchemeBuilder in(@Nullable ApiKeyLocation in) {
            this.in = in;
            return this;
        }

        public HttpApiKeySecurityScheme build() {
            return new HttpApiKeySecurityScheme(this.type, this.description, this.name, this.in);
        }

        public String toString() {
            return "HttpApiKeySecurityScheme.HttpApiKeySecuritySchemeBuilder(type=" + (Object)((Object)this.type) + ", description=" + this.description + ", name=" + this.name + ", in=" + (Object)((Object)this.in) + ")";
        }
    }

    public static enum ApiKeyLocation {
        QUERY,
        HEADER,
        COOKIE;

    }
}

