/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v2.model.security_scheme.http;

import com.asyncapi.v2.model.security_scheme.SecurityScheme;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;

public class HttpSecurityScheme
extends SecurityScheme {
    @Nonnull
    @NonNull
    private String scheme;
    @CheckForNull
    private String bearerFormat;

    public HttpSecurityScheme(@Nonnull @NonNull SecurityScheme.Type type, @Nullable String description, @Nonnull @NonNull String scheme, @Nullable String bearerFormat) {
        super(type, description);
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (scheme == null) {
            throw new NullPointerException("scheme is marked non-null but is null");
        }
        this.scheme = scheme;
        this.bearerFormat = bearerFormat;
    }

    public static HttpSecuritySchemeBuilder httpSecuritySchemeBuilder() {
        return new HttpSecuritySchemeBuilder();
    }

    @Nonnull
    @NonNull
    public String getScheme() {
        return this.scheme;
    }

    @CheckForNull
    public String getBearerFormat() {
        return this.bearerFormat;
    }

    public void setScheme(@Nonnull @NonNull String scheme) {
        if (scheme == null) {
            throw new NullPointerException("scheme is marked non-null but is null");
        }
        this.scheme = scheme;
    }

    public void setBearerFormat(@CheckForNull String bearerFormat) {
        this.bearerFormat = bearerFormat;
    }

    @Override
    public String toString() {
        return "HttpSecurityScheme(scheme=" + this.getScheme() + ", bearerFormat=" + this.getBearerFormat() + ")";
    }

    public HttpSecurityScheme() {
    }

    public HttpSecurityScheme(@Nonnull @NonNull String scheme, @CheckForNull String bearerFormat) {
        if (scheme == null) {
            throw new NullPointerException("scheme is marked non-null but is null");
        }
        this.scheme = scheme;
        this.bearerFormat = bearerFormat;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpSecurityScheme)) {
            return false;
        }
        HttpSecurityScheme other = (HttpSecurityScheme)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$scheme = this.getScheme();
        String other$scheme = other.getScheme();
        if (this$scheme == null ? other$scheme != null : !this$scheme.equals(other$scheme)) {
            return false;
        }
        String this$bearerFormat = this.getBearerFormat();
        String other$bearerFormat = other.getBearerFormat();
        return !(this$bearerFormat == null ? other$bearerFormat != null : !this$bearerFormat.equals(other$bearerFormat));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HttpSecurityScheme;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $scheme = this.getScheme();
        result = result * 59 + ($scheme == null ? 43 : $scheme.hashCode());
        String $bearerFormat = this.getBearerFormat();
        result = result * 59 + ($bearerFormat == null ? 43 : $bearerFormat.hashCode());
        return result;
    }

    public static class HttpSecuritySchemeBuilder {
        private SecurityScheme.Type type;
        private String description;
        private String scheme;
        private String bearerFormat;

        HttpSecuritySchemeBuilder() {
        }

        public HttpSecuritySchemeBuilder type(@Nonnull @NonNull SecurityScheme.Type type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        public HttpSecuritySchemeBuilder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public HttpSecuritySchemeBuilder scheme(@Nonnull @NonNull String scheme) {
            if (scheme == null) {
                throw new NullPointerException("scheme is marked non-null but is null");
            }
            this.scheme = scheme;
            return this;
        }

        public HttpSecuritySchemeBuilder bearerFormat(@Nullable String bearerFormat) {
            this.bearerFormat = bearerFormat;
            return this;
        }

        public HttpSecurityScheme build() {
            return new HttpSecurityScheme(this.type, this.description, this.scheme, this.bearerFormat);
        }

        public String toString() {
            return "HttpSecurityScheme.HttpSecuritySchemeBuilder(type=" + (Object)((Object)this.type) + ", description=" + this.description + ", scheme=" + this.scheme + ", bearerFormat=" + this.bearerFormat + ")";
        }
    }
}

