/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v2.model.security_scheme.oauth2;

import com.asyncapi.v2.model.security_scheme.SecurityScheme;
import com.asyncapi.v2.model.security_scheme.oauth2.OAuthFlows;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;

public class OAuth2SecurityScheme
extends SecurityScheme {
    @Nonnull
    @NonNull
    private OAuthFlows flows;

    public OAuth2SecurityScheme(@Nonnull @NonNull SecurityScheme.Type type, @Nullable String description, @Nonnull @NonNull OAuthFlows flows) {
        super(type, description);
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (flows == null) {
            throw new NullPointerException("flows is marked non-null but is null");
        }
        this.flows = flows;
    }

    public static OAuth2SecuritySchemeBuilder oauth2SecuritySchemeBuilder() {
        return new OAuth2SecuritySchemeBuilder();
    }

    @Nonnull
    @NonNull
    public OAuthFlows getFlows() {
        return this.flows;
    }

    public void setFlows(@Nonnull @NonNull OAuthFlows flows) {
        if (flows == null) {
            throw new NullPointerException("flows is marked non-null but is null");
        }
        this.flows = flows;
    }

    @Override
    public String toString() {
        return "OAuth2SecurityScheme(flows=" + this.getFlows() + ")";
    }

    public OAuth2SecurityScheme() {
    }

    public OAuth2SecurityScheme(@Nonnull @NonNull OAuthFlows flows) {
        if (flows == null) {
            throw new NullPointerException("flows is marked non-null but is null");
        }
        this.flows = flows;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2SecurityScheme)) {
            return false;
        }
        OAuth2SecurityScheme other = (OAuth2SecurityScheme)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OAuthFlows this$flows = this.getFlows();
        OAuthFlows other$flows = other.getFlows();
        return !(this$flows == null ? other$flows != null : !((Object)this$flows).equals(other$flows));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OAuth2SecurityScheme;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OAuthFlows $flows = this.getFlows();
        result = result * 59 + ($flows == null ? 43 : ((Object)$flows).hashCode());
        return result;
    }

    public static class OAuth2SecuritySchemeBuilder {
        private SecurityScheme.Type type;
        private String description;
        private OAuthFlows flows;

        OAuth2SecuritySchemeBuilder() {
        }

        public OAuth2SecuritySchemeBuilder type(@Nonnull @NonNull SecurityScheme.Type type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        public OAuth2SecuritySchemeBuilder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public OAuth2SecuritySchemeBuilder flows(@Nonnull @NonNull OAuthFlows flows) {
            if (flows == null) {
                throw new NullPointerException("flows is marked non-null but is null");
            }
            this.flows = flows;
            return this;
        }

        public OAuth2SecurityScheme build() {
            return new OAuth2SecurityScheme(this.type, this.description, this.flows);
        }

        public String toString() {
            return "OAuth2SecurityScheme.OAuth2SecuritySchemeBuilder(type=" + (Object)((Object)this.type) + ", description=" + this.description + ", flows=" + this.flows + ")";
        }
    }
}

