/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v2.model.security_scheme.oauth2.flow;

import com.asyncapi.v2.model.security_scheme.oauth2.flow.OAuthFlow;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;

public class ImplicitOAuthFlow
extends OAuthFlow {
    @Nonnull
    @NonNull
    private String authorizationUrl;

    public ImplicitOAuthFlow(@Nullable String refreshUrl, @Nonnull @NonNull Map<String, String> scopes, @Nonnull @NonNull String authorizationUrl) {
        super(refreshUrl, scopes);
        if (scopes == null) {
            throw new NullPointerException("scopes is marked non-null but is null");
        }
        if (authorizationUrl == null) {
            throw new NullPointerException("authorizationUrl is marked non-null but is null");
        }
        this.authorizationUrl = authorizationUrl;
    }

    public static ImplicitOAuthFlowBuilder implicitOAuthFlowBuilder() {
        return new ImplicitOAuthFlowBuilder();
    }

    @Nonnull
    @NonNull
    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public void setAuthorizationUrl(@Nonnull @NonNull String authorizationUrl) {
        if (authorizationUrl == null) {
            throw new NullPointerException("authorizationUrl is marked non-null but is null");
        }
        this.authorizationUrl = authorizationUrl;
    }

    @Override
    public String toString() {
        return "ImplicitOAuthFlow(authorizationUrl=" + this.getAuthorizationUrl() + ")";
    }

    public ImplicitOAuthFlow() {
    }

    public ImplicitOAuthFlow(@Nonnull @NonNull String authorizationUrl) {
        if (authorizationUrl == null) {
            throw new NullPointerException("authorizationUrl is marked non-null but is null");
        }
        this.authorizationUrl = authorizationUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImplicitOAuthFlow)) {
            return false;
        }
        ImplicitOAuthFlow other = (ImplicitOAuthFlow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$authorizationUrl = this.getAuthorizationUrl();
        String other$authorizationUrl = other.getAuthorizationUrl();
        return !(this$authorizationUrl == null ? other$authorizationUrl != null : !this$authorizationUrl.equals(other$authorizationUrl));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ImplicitOAuthFlow;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $authorizationUrl = this.getAuthorizationUrl();
        result = result * 59 + ($authorizationUrl == null ? 43 : $authorizationUrl.hashCode());
        return result;
    }

    public static class ImplicitOAuthFlowBuilder {
        private String refreshUrl;
        private Map<String, String> scopes;
        private String authorizationUrl;

        ImplicitOAuthFlowBuilder() {
        }

        public ImplicitOAuthFlowBuilder refreshUrl(@Nullable String refreshUrl) {
            this.refreshUrl = refreshUrl;
            return this;
        }

        public ImplicitOAuthFlowBuilder scopes(@Nonnull @NonNull Map<String, String> scopes) {
            if (scopes == null) {
                throw new NullPointerException("scopes is marked non-null but is null");
            }
            this.scopes = scopes;
            return this;
        }

        public ImplicitOAuthFlowBuilder authorizationUrl(@Nonnull @NonNull String authorizationUrl) {
            if (authorizationUrl == null) {
                throw new NullPointerException("authorizationUrl is marked non-null but is null");
            }
            this.authorizationUrl = authorizationUrl;
            return this;
        }

        public ImplicitOAuthFlow build() {
            return new ImplicitOAuthFlow(this.refreshUrl, this.scopes, this.authorizationUrl);
        }

        public String toString() {
            return "ImplicitOAuthFlow.ImplicitOAuthFlowBuilder(refreshUrl=" + this.refreshUrl + ", scopes=" + this.scopes + ", authorizationUrl=" + this.authorizationUrl + ")";
        }
    }
}

