/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v2.model.server;

import com.asyncapi.v2.binding.ServerBinding;
import com.asyncapi.v2.binding.ServerBindingsDeserializer;
import com.asyncapi.v2.model.server.ServerVariable;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import lombok.NonNull;

public class Server {
    @Nonnull
    @NonNull
    private String url;
    @Nonnull
    @NonNull
    private String protocol;
    @CheckForNull
    private String protocolVersion;
    @CheckForNull
    private String description;
    @CheckForNull
    private Map<String, ServerVariable> variables;
    @CheckForNull
    private List<Map<String, List<String>>> security;
    @CheckForNull
    @JsonDeserialize(using=ServerBindingsDeserializer.class)
    private Map<String, ? extends ServerBinding> bindings;

    public static ServerBuilder builder() {
        return new ServerBuilder();
    }

    @Nonnull
    @NonNull
    public String getUrl() {
        return this.url;
    }

    @Nonnull
    @NonNull
    public String getProtocol() {
        return this.protocol;
    }

    @CheckForNull
    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    @CheckForNull
    public Map<String, ServerVariable> getVariables() {
        return this.variables;
    }

    @CheckForNull
    public List<Map<String, List<String>>> getSecurity() {
        return this.security;
    }

    @CheckForNull
    public Map<String, ? extends ServerBinding> getBindings() {
        return this.bindings;
    }

    public void setUrl(@Nonnull @NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.url = url;
    }

    public void setProtocol(@Nonnull @NonNull String protocol) {
        if (protocol == null) {
            throw new NullPointerException("protocol is marked non-null but is null");
        }
        this.protocol = protocol;
    }

    public void setProtocolVersion(@CheckForNull String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setDescription(@CheckForNull String description) {
        this.description = description;
    }

    public void setVariables(@CheckForNull Map<String, ServerVariable> variables) {
        this.variables = variables;
    }

    public void setSecurity(@CheckForNull List<Map<String, List<String>>> security) {
        this.security = security;
    }

    public void setBindings(@CheckForNull Map<String, ? extends ServerBinding> bindings) {
        this.bindings = bindings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Server)) {
            return false;
        }
        Server other = (Server)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        String this$protocolVersion = this.getProtocolVersion();
        String other$protocolVersion = other.getProtocolVersion();
        if (this$protocolVersion == null ? other$protocolVersion != null : !this$protocolVersion.equals(other$protocolVersion)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Map<String, ServerVariable> this$variables = this.getVariables();
        Map<String, ServerVariable> other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
            return false;
        }
        List<Map<String, List<String>>> this$security = this.getSecurity();
        List<Map<String, List<String>>> other$security = other.getSecurity();
        if (this$security == null ? other$security != null : !((Object)this$security).equals(other$security)) {
            return false;
        }
        Map<String, ? extends ServerBinding> this$bindings = this.getBindings();
        Map<String, ? extends ServerBinding> other$bindings = other.getBindings();
        return !(this$bindings == null ? other$bindings != null : !((Object)this$bindings).equals(other$bindings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Server;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        String $protocolVersion = this.getProtocolVersion();
        result = result * 59 + ($protocolVersion == null ? 43 : $protocolVersion.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Map<String, ServerVariable> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        List<Map<String, List<String>>> $security = this.getSecurity();
        result = result * 59 + ($security == null ? 43 : ((Object)$security).hashCode());
        Map<String, ? extends ServerBinding> $bindings = this.getBindings();
        result = result * 59 + ($bindings == null ? 43 : ((Object)$bindings).hashCode());
        return result;
    }

    public String toString() {
        return "Server(url=" + this.getUrl() + ", protocol=" + this.getProtocol() + ", protocolVersion=" + this.getProtocolVersion() + ", description=" + this.getDescription() + ", variables=" + this.getVariables() + ", security=" + this.getSecurity() + ", bindings=" + this.getBindings() + ")";
    }

    public Server() {
    }

    public Server(@Nonnull @NonNull String url, @Nonnull @NonNull String protocol, @CheckForNull String protocolVersion, @CheckForNull String description, @CheckForNull Map<String, ServerVariable> variables, @CheckForNull List<Map<String, List<String>>> security, @CheckForNull Map<String, ? extends ServerBinding> bindings) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (protocol == null) {
            throw new NullPointerException("protocol is marked non-null but is null");
        }
        this.url = url;
        this.protocol = protocol;
        this.protocolVersion = protocolVersion;
        this.description = description;
        this.variables = variables;
        this.security = security;
        this.bindings = bindings;
    }

    public static class ServerBuilder {
        private String url;
        private String protocol;
        private String protocolVersion;
        private String description;
        private Map<String, ServerVariable> variables;
        private List<Map<String, List<String>>> security;
        private Map<String, ? extends ServerBinding> bindings;

        ServerBuilder() {
        }

        public ServerBuilder url(@Nonnull @NonNull String url) {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.url = url;
            return this;
        }

        public ServerBuilder protocol(@Nonnull @NonNull String protocol) {
            if (protocol == null) {
                throw new NullPointerException("protocol is marked non-null but is null");
            }
            this.protocol = protocol;
            return this;
        }

        public ServerBuilder protocolVersion(@CheckForNull String protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public ServerBuilder description(@CheckForNull String description) {
            this.description = description;
            return this;
        }

        public ServerBuilder variables(@CheckForNull Map<String, ServerVariable> variables) {
            this.variables = variables;
            return this;
        }

        public ServerBuilder security(@CheckForNull List<Map<String, List<String>>> security) {
            this.security = security;
            return this;
        }

        public ServerBuilder bindings(@CheckForNull Map<String, ? extends ServerBinding> bindings) {
            this.bindings = bindings;
            return this;
        }

        public Server build() {
            return new Server(this.url, this.protocol, this.protocolVersion, this.description, this.variables, this.security, this.bindings);
        }

        public String toString() {
            return "Server.ServerBuilder(url=" + this.url + ", protocol=" + this.protocol + ", protocolVersion=" + this.protocolVersion + ", description=" + this.description + ", variables=" + this.variables + ", security=" + this.security + ", bindings=" + this.bindings + ")";
        }
    }
}

