/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v2.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class MapOfReferencesOrObjectsDeserializer<ObjectType>
extends JsonDeserializer<Map<String, Object>> {
    public abstract Class<ObjectType> objectTypeClass();

    public abstract Class<?> referenceClass();

    public Map<String, Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        ObjectCodec objectCodec = jsonParser.getCodec();
        JsonNode map = (JsonNode)objectCodec.readTree(jsonParser);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        map.fieldNames().forEachRemaining(fieldName -> {
            try {
                parameters.put((String)fieldName, this.chooseKnownPojo(map.get(fieldName), objectCodec));
            }
            catch (IOException ignore) {
                try {
                    parameters.put((String)fieldName, this.readAsObject(map.get(fieldName), objectCodec));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        return parameters;
    }

    private Object chooseKnownPojo(JsonNode jsonNode, ObjectCodec objectCodec) throws IOException {
        JsonNode ref = jsonNode.get("$ref");
        try (JsonParser jsonParser = jsonNode.traverse(objectCodec);){
            if (ref != null) {
                Object object = jsonParser.readValueAs(this.referenceClass());
                return object;
            }
            Object object = jsonParser.readValueAs(this.objectTypeClass());
            return object;
        }
    }

    private Object readAsObject(JsonNode jsonNode, ObjectCodec objectCodec) throws IOException {
        try (JsonParser jsonParser = jsonNode.traverse(objectCodec);){
            Object object = jsonParser.readValueAs(this.objectTypeClass());
            return object;
        }
    }
}

