/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v2.security_scheme.oauth2;

import com.asyncapi.v2.security_scheme.SecurityScheme;
import com.asyncapi.v2.security_scheme.oauth2.OAuthFlows;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OAuth2SecurityScheme
extends SecurityScheme {
    @NotNull
    private OAuthFlows flows;

    public OAuth2SecurityScheme(@NotNull SecurityScheme.Type type, @Nullable String description, @NotNull OAuthFlows flows) {
        super(type, description);
        this.flows = flows;
    }

    public static OAuth2SecuritySchemeBuilder oauth2SecuritySchemeBuilder() {
        return new OAuth2SecuritySchemeBuilder();
    }

    @NotNull
    public OAuthFlows getFlows() {
        return this.flows;
    }

    public void setFlows(@NotNull OAuthFlows flows) {
        if (flows == null) {
            throw new NullPointerException("flows is marked non-null but is null");
        }
        this.flows = flows;
    }

    @Override
    public String toString() {
        return "OAuth2SecurityScheme(flows=" + this.getFlows() + ")";
    }

    public OAuth2SecurityScheme() {
    }

    public OAuth2SecurityScheme(@NotNull OAuthFlows flows) {
        if (flows == null) {
            throw new NullPointerException("flows is marked non-null but is null");
        }
        this.flows = flows;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2SecurityScheme)) {
            return false;
        }
        OAuth2SecurityScheme other = (OAuth2SecurityScheme)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OAuthFlows this$flows = this.getFlows();
        OAuthFlows other$flows = other.getFlows();
        return !(this$flows == null ? other$flows != null : !((Object)this$flows).equals(other$flows));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OAuth2SecurityScheme;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OAuthFlows $flows = this.getFlows();
        result = result * 59 + ($flows == null ? 43 : ((Object)$flows).hashCode());
        return result;
    }

    public static class OAuth2SecuritySchemeBuilder {
        private SecurityScheme.Type type;
        private String description;
        private OAuthFlows flows;

        OAuth2SecuritySchemeBuilder() {
        }

        public OAuth2SecuritySchemeBuilder type(@NotNull SecurityScheme.Type type) {
            this.type = type;
            return this;
        }

        public OAuth2SecuritySchemeBuilder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public OAuth2SecuritySchemeBuilder flows(@NotNull OAuthFlows flows) {
            this.flows = flows;
            return this;
        }

        public OAuth2SecurityScheme build() {
            return new OAuth2SecurityScheme(this.type, this.description, this.flows);
        }

        public String toString() {
            return "OAuth2SecurityScheme.OAuth2SecuritySchemeBuilder(type=" + (Object)((Object)this.type) + ", description=" + this.description + ", flows=" + this.flows + ")";
        }
    }
}

