/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v2.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.io.IOException;

public abstract class ReferenceOrObjectDeserializer<ObjectType>
extends JsonDeserializer<Object> {
    public abstract Class<ObjectType> objectTypeClass();

    public abstract Class<?> referenceClass();

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectCodec objectCodec = p.getCodec();
        JsonNode node = (JsonNode)objectCodec.readTree(p);
        try {
            return this.chooseKnownPojo(node, objectCodec);
        }
        catch (UnrecognizedPropertyException unrecognizedPropertyException) {
            return this.readAsObject(node, objectCodec);
        }
    }

    private Object chooseKnownPojo(JsonNode jsonNode, ObjectCodec objectCodec) throws IOException {
        JsonNode ref = jsonNode.get("$ref");
        try (JsonParser jsonParser = jsonNode.traverse(objectCodec);){
            if (ref != null) {
                Object object = jsonParser.readValueAs(this.referenceClass());
                return object;
            }
            Object object = jsonParser.readValueAs(this.objectTypeClass());
            return object;
        }
    }

    private Object readAsObject(JsonNode jsonNode, ObjectCodec objectCodec) throws IOException {
        try (JsonParser jsonParser = jsonNode.traverse(objectCodec);){
            Object object = jsonParser.readValueAs(this.objectTypeClass());
            return object;
        }
    }
}

