/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v3.binding.channel.anypointmq;

import com.asyncapi.v3.binding.channel.ChannelBinding;
import com.asyncapi.v3.binding.channel.anypointmq.AnypointMQChannelDestinationType;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import org.jetbrains.annotations.Nullable;

@JsonClassDescription(value="Describes Anypoint MQ channel binding.")
public class AnypointMQChannelBinding
extends ChannelBinding {
    @JsonProperty(value="destination")
    @JsonPropertyDescription(value="The destination (queue or exchange) name for this channel. SHOULD only be specified if the channel name differs from the actual destination name, such as when the channel name is not a valid destination name in Anypoint MQ.")
    @Nullable
    private String destination;
    @JsonProperty(value="destinationType", defaultValue="queue")
    @JsonPropertyDescription(value="The type of destination, which MUST be either exchange or queue or fifo-queue. SHOULD be specified to document the messaging model (publish/subscribe, point-to-point, strict message ordering) supported by this channel.")
    @Nullable
    private AnypointMQChannelDestinationType destinationType;
    @JsonProperty(value="bindingVersion")
    @JsonPropertyDescription(value="The version of this binding.")
    @Nullable
    private String bindingVersion;

    private static AnypointMQChannelDestinationType $default$destinationType() {
        return AnypointMQChannelDestinationType.QUEUE;
    }

    private static String $default$bindingVersion() {
        return "0.0.1";
    }

    public static AnypointMQChannelBindingBuilder builder() {
        return new AnypointMQChannelBindingBuilder();
    }

    @Nullable
    public String getDestination() {
        return this.destination;
    }

    @Nullable
    public AnypointMQChannelDestinationType getDestinationType() {
        return this.destinationType;
    }

    @Nullable
    public String getBindingVersion() {
        return this.bindingVersion;
    }

    @JsonProperty(value="destination")
    public void setDestination(@Nullable String destination) {
        this.destination = destination;
    }

    @JsonProperty(value="destinationType", defaultValue="queue")
    public void setDestinationType(@Nullable AnypointMQChannelDestinationType destinationType) {
        this.destinationType = destinationType;
    }

    @JsonProperty(value="bindingVersion")
    public void setBindingVersion(@Nullable String bindingVersion) {
        this.bindingVersion = bindingVersion;
    }

    @Override
    public String toString() {
        return "AnypointMQChannelBinding(destination=" + this.getDestination() + ", destinationType=" + (Object)((Object)this.getDestinationType()) + ", bindingVersion=" + this.getBindingVersion() + ")";
    }

    public AnypointMQChannelBinding() {
        this.destinationType = AnypointMQChannelBinding.$default$destinationType();
        this.bindingVersion = AnypointMQChannelBinding.$default$bindingVersion();
    }

    public AnypointMQChannelBinding(@Nullable String destination, @Nullable AnypointMQChannelDestinationType destinationType, @Nullable String bindingVersion) {
        this.destination = destination;
        this.destinationType = destinationType;
        this.bindingVersion = bindingVersion;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnypointMQChannelBinding)) {
            return false;
        }
        AnypointMQChannelBinding other = (AnypointMQChannelBinding)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        AnypointMQChannelDestinationType this$destinationType = this.getDestinationType();
        AnypointMQChannelDestinationType other$destinationType = other.getDestinationType();
        if (this$destinationType == null ? other$destinationType != null : !((Object)((Object)this$destinationType)).equals((Object)other$destinationType)) {
            return false;
        }
        String this$bindingVersion = this.getBindingVersion();
        String other$bindingVersion = other.getBindingVersion();
        return !(this$bindingVersion == null ? other$bindingVersion != null : !this$bindingVersion.equals(other$bindingVersion));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AnypointMQChannelBinding;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        AnypointMQChannelDestinationType $destinationType = this.getDestinationType();
        result = result * 59 + ($destinationType == null ? 43 : ((Object)((Object)$destinationType)).hashCode());
        String $bindingVersion = this.getBindingVersion();
        result = result * 59 + ($bindingVersion == null ? 43 : $bindingVersion.hashCode());
        return result;
    }

    public static class AnypointMQChannelBindingBuilder {
        private String destination;
        private boolean destinationType$set;
        private AnypointMQChannelDestinationType destinationType$value;
        private boolean bindingVersion$set;
        private String bindingVersion$value;

        AnypointMQChannelBindingBuilder() {
        }

        @JsonProperty(value="destination")
        public AnypointMQChannelBindingBuilder destination(@Nullable String destination) {
            this.destination = destination;
            return this;
        }

        @JsonProperty(value="destinationType", defaultValue="queue")
        public AnypointMQChannelBindingBuilder destinationType(@Nullable AnypointMQChannelDestinationType destinationType) {
            this.destinationType$value = destinationType;
            this.destinationType$set = true;
            return this;
        }

        @JsonProperty(value="bindingVersion")
        public AnypointMQChannelBindingBuilder bindingVersion(@Nullable String bindingVersion) {
            this.bindingVersion$value = bindingVersion;
            this.bindingVersion$set = true;
            return this;
        }

        public AnypointMQChannelBinding build() {
            AnypointMQChannelDestinationType destinationType$value = this.destinationType$value;
            if (!this.destinationType$set) {
                destinationType$value = AnypointMQChannelBinding.$default$destinationType();
            }
            String bindingVersion$value = this.bindingVersion$value;
            if (!this.bindingVersion$set) {
                bindingVersion$value = AnypointMQChannelBinding.$default$bindingVersion();
            }
            return new AnypointMQChannelBinding(this.destination, destinationType$value, bindingVersion$value);
        }

        public String toString() {
            return "AnypointMQChannelBinding.AnypointMQChannelBindingBuilder(destination=" + this.destination + ", destinationType$value=" + (Object)((Object)this.destinationType$value) + ", bindingVersion$value=" + this.bindingVersion$value + ")";
        }
    }
}

