/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v3.binding.channel.ibmmq;

import com.asyncapi.v3.binding.channel.ChannelBinding;
import com.asyncapi.v3.binding.channel.ibmmq.IBMMQChannelDestinationType;
import com.asyncapi.v3.binding.channel.ibmmq.IBMMQChannelQueueProperties;
import com.asyncapi.v3.binding.channel.ibmmq.IBMMQChannelTopicProperties;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.jetbrains.annotations.Nullable;

@JsonClassDescription(value="Describes IBM MQ channel binding.")
public class IBMMQChannelBinding
extends ChannelBinding {
    @JsonProperty(value="destinationType", defaultValue="topic")
    @JsonPropertyDescription(value="Defines the type of AsyncAPI channel.")
    @Nullable
    private IBMMQChannelDestinationType destinationType;
    @JsonProperty(value="queue")
    @JsonPropertyDescription(value="Defines the properties of a queue.")
    @Nullable
    private IBMMQChannelQueueProperties queue;
    @JsonProperty(value="topic")
    @JsonPropertyDescription(value="Defines the properties of a topic.")
    @Nullable
    private IBMMQChannelTopicProperties topic;
    @Min(value=0L, message="Maximum length of the physical message (in bytes) must be greater or equals to 0")
    @Max(value=0x6400000L, message="Maximum length of the physical message (in bytes) must be lower or equals to 104857600")
    @JsonProperty(value="maxMsgLength")
    @JsonPropertyDescription(value="The maximum length of the physical message (in bytes) accepted by the Topic or Queue. Messages produced that are greater in size than this value may fail to be delivered. More information on the maximum message length can be found on this [page](https://www.ibm.com/support/knowledgecenter/SSFKSJ_latest/com.ibm.mq.ref.dev.doc/q097520_.html) in the IBM MQ Knowledge Center.")
    @Nullable
    private @Min(value=0L, message="Maximum length of the physical message (in bytes) must be greater or equals to 0") @Max(value=0x6400000L, message="Maximum length of the physical message (in bytes) must be lower or equals to 104857600") @Nullable Integer maxMsgLength;
    @JsonProperty(value="bindingVersion")
    @JsonPropertyDescription(value="The version of this binding.")
    private String bindingVersion;

    private static IBMMQChannelDestinationType $default$destinationType() {
        return IBMMQChannelDestinationType.TOPIC;
    }

    private static String $default$bindingVersion() {
        return "0.1.0";
    }

    public static IBMMQChannelBindingBuilder builder() {
        return new IBMMQChannelBindingBuilder();
    }

    @Nullable
    public IBMMQChannelDestinationType getDestinationType() {
        return this.destinationType;
    }

    @Nullable
    public IBMMQChannelQueueProperties getQueue() {
        return this.queue;
    }

    @Nullable
    public IBMMQChannelTopicProperties getTopic() {
        return this.topic;
    }

    @Nullable
    public Integer getMaxMsgLength() {
        return this.maxMsgLength;
    }

    public String getBindingVersion() {
        return this.bindingVersion;
    }

    @JsonProperty(value="destinationType", defaultValue="topic")
    public void setDestinationType(@Nullable IBMMQChannelDestinationType destinationType) {
        this.destinationType = destinationType;
    }

    @JsonProperty(value="queue")
    public void setQueue(@Nullable IBMMQChannelQueueProperties queue) {
        this.queue = queue;
    }

    @JsonProperty(value="topic")
    public void setTopic(@Nullable IBMMQChannelTopicProperties topic) {
        this.topic = topic;
    }

    @JsonProperty(value="maxMsgLength")
    public void setMaxMsgLength(@Nullable Integer maxMsgLength) {
        this.maxMsgLength = maxMsgLength;
    }

    @JsonProperty(value="bindingVersion")
    public void setBindingVersion(String bindingVersion) {
        this.bindingVersion = bindingVersion;
    }

    @Override
    public String toString() {
        return "IBMMQChannelBinding(destinationType=" + (Object)((Object)this.getDestinationType()) + ", queue=" + this.getQueue() + ", topic=" + this.getTopic() + ", maxMsgLength=" + this.getMaxMsgLength() + ", bindingVersion=" + this.getBindingVersion() + ")";
    }

    public IBMMQChannelBinding() {
        this.destinationType = IBMMQChannelBinding.$default$destinationType();
        this.bindingVersion = IBMMQChannelBinding.$default$bindingVersion();
    }

    public IBMMQChannelBinding(@Nullable IBMMQChannelDestinationType destinationType, @Nullable IBMMQChannelQueueProperties queue, @Nullable IBMMQChannelTopicProperties topic, @Nullable Integer maxMsgLength, String bindingVersion) {
        this.destinationType = destinationType;
        this.queue = queue;
        this.topic = topic;
        this.maxMsgLength = maxMsgLength;
        this.bindingVersion = bindingVersion;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IBMMQChannelBinding)) {
            return false;
        }
        IBMMQChannelBinding other = (IBMMQChannelBinding)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IBMMQChannelDestinationType this$destinationType = this.getDestinationType();
        IBMMQChannelDestinationType other$destinationType = other.getDestinationType();
        if (this$destinationType == null ? other$destinationType != null : !((Object)((Object)this$destinationType)).equals((Object)other$destinationType)) {
            return false;
        }
        IBMMQChannelQueueProperties this$queue = this.getQueue();
        IBMMQChannelQueueProperties other$queue = other.getQueue();
        if (this$queue == null ? other$queue != null : !((Object)this$queue).equals(other$queue)) {
            return false;
        }
        IBMMQChannelTopicProperties this$topic = this.getTopic();
        IBMMQChannelTopicProperties other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !((Object)this$topic).equals(other$topic)) {
            return false;
        }
        Integer this$maxMsgLength = this.getMaxMsgLength();
        Integer other$maxMsgLength = other.getMaxMsgLength();
        if (this$maxMsgLength == null ? other$maxMsgLength != null : !((Object)this$maxMsgLength).equals(other$maxMsgLength)) {
            return false;
        }
        String this$bindingVersion = this.getBindingVersion();
        String other$bindingVersion = other.getBindingVersion();
        return !(this$bindingVersion == null ? other$bindingVersion != null : !this$bindingVersion.equals(other$bindingVersion));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IBMMQChannelBinding;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        IBMMQChannelDestinationType $destinationType = this.getDestinationType();
        result = result * 59 + ($destinationType == null ? 43 : ((Object)((Object)$destinationType)).hashCode());
        IBMMQChannelQueueProperties $queue = this.getQueue();
        result = result * 59 + ($queue == null ? 43 : ((Object)$queue).hashCode());
        IBMMQChannelTopicProperties $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : ((Object)$topic).hashCode());
        Integer $maxMsgLength = this.getMaxMsgLength();
        result = result * 59 + ($maxMsgLength == null ? 43 : ((Object)$maxMsgLength).hashCode());
        String $bindingVersion = this.getBindingVersion();
        result = result * 59 + ($bindingVersion == null ? 43 : $bindingVersion.hashCode());
        return result;
    }

    public static class IBMMQChannelBindingBuilder {
        private boolean destinationType$set;
        private IBMMQChannelDestinationType destinationType$value;
        private IBMMQChannelQueueProperties queue;
        private IBMMQChannelTopicProperties topic;
        private Integer maxMsgLength;
        private boolean bindingVersion$set;
        private String bindingVersion$value;

        IBMMQChannelBindingBuilder() {
        }

        @JsonProperty(value="destinationType", defaultValue="topic")
        public IBMMQChannelBindingBuilder destinationType(@Nullable IBMMQChannelDestinationType destinationType) {
            this.destinationType$value = destinationType;
            this.destinationType$set = true;
            return this;
        }

        @JsonProperty(value="queue")
        public IBMMQChannelBindingBuilder queue(@Nullable IBMMQChannelQueueProperties queue) {
            this.queue = queue;
            return this;
        }

        @JsonProperty(value="topic")
        public IBMMQChannelBindingBuilder topic(@Nullable IBMMQChannelTopicProperties topic) {
            this.topic = topic;
            return this;
        }

        @JsonProperty(value="maxMsgLength")
        public IBMMQChannelBindingBuilder maxMsgLength(@Nullable Integer maxMsgLength) {
            this.maxMsgLength = maxMsgLength;
            return this;
        }

        @JsonProperty(value="bindingVersion")
        public IBMMQChannelBindingBuilder bindingVersion(String bindingVersion) {
            this.bindingVersion$value = bindingVersion;
            this.bindingVersion$set = true;
            return this;
        }

        public IBMMQChannelBinding build() {
            IBMMQChannelDestinationType destinationType$value = this.destinationType$value;
            if (!this.destinationType$set) {
                destinationType$value = IBMMQChannelBinding.$default$destinationType();
            }
            String bindingVersion$value = this.bindingVersion$value;
            if (!this.bindingVersion$set) {
                bindingVersion$value = IBMMQChannelBinding.$default$bindingVersion();
            }
            return new IBMMQChannelBinding(destinationType$value, this.queue, this.topic, this.maxMsgLength, bindingVersion$value);
        }

        public String toString() {
            return "IBMMQChannelBinding.IBMMQChannelBindingBuilder(destinationType$value=" + (Object)((Object)this.destinationType$value) + ", queue=" + this.queue + ", topic=" + this.topic + ", maxMsgLength=" + this.maxMsgLength + ", bindingVersion$value=" + this.bindingVersion$value + ")";
        }
    }
}

