/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v3.binding.channel.pulsar;

import com.asyncapi.v3.binding.channel.ChannelBinding;
import com.asyncapi.v3.binding.channel.pulsar.PulsarChannelPersistence;
import com.asyncapi.v3.binding.channel.pulsar.PulsarChannelRetentionDefinition;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonClassDescription(value="Describes Pulsar channel binding.")
public class PulsarChannelBinding
extends ChannelBinding {
    @NotNull
    @JsonProperty(value="namespace")
    @JsonPropertyDescription(value="The namespace the channel is associated with.")
    @org.jetbrains.annotations.NotNull
    private String namespace;
    @NotNull
    @JsonProperty(value="persistence", defaultValue="persistent")
    @JsonPropertyDescription(value="Persistence of the topic in Pulsar. It MUST be either persistent or non-persistent.")
    @org.jetbrains.annotations.NotNull
    private PulsarChannelPersistence persistence;
    @Min(value=0L, message="Topic compaction threshold must be greater or equals to 0.")
    @JsonProperty(value="compaction")
    @JsonPropertyDescription(value="Topic compaction threshold given in Megabytes.")
    @Nullable
    private @Min(value=0L, message="Topic compaction threshold must be greater or equals to 0.") @Nullable Integer compaction;
    @JsonProperty(value="geo-replication")
    @JsonPropertyDescription(value="A list of clusters the topic is replicated to.")
    @Nullable
    private List<String> geoReplication;
    @JsonProperty(value="retention")
    @JsonPropertyDescription(value="Topic retention policy.")
    @Nullable
    private PulsarChannelRetentionDefinition retention;
    @JsonProperty(value="ttl")
    @JsonPropertyDescription(value="Message time-to-live in seconds.")
    @Nullable
    private Integer ttl;
    @JsonProperty(value="deduplication")
    @JsonPropertyDescription(value="Message deduplication. When true, it ensures that each message produced on Pulsar topics is persisted to disk only once.")
    @Nullable
    private Boolean deduplication;
    @JsonProperty(value="bindingVersion")
    @JsonPropertyDescription(value="The version of this binding.")
    @Nullable
    private String bindingVersion;

    private static String $default$namespace() {
        return "";
    }

    private static PulsarChannelPersistence $default$persistence() {
        return PulsarChannelPersistence.PERSISTENT;
    }

    private static String $default$bindingVersion() {
        return "0.1.0";
    }

    public static PulsarChannelBindingBuilder builder() {
        return new PulsarChannelBindingBuilder();
    }

    @org.jetbrains.annotations.NotNull
    public String getNamespace() {
        return this.namespace;
    }

    @org.jetbrains.annotations.NotNull
    public PulsarChannelPersistence getPersistence() {
        return this.persistence;
    }

    @Nullable
    public Integer getCompaction() {
        return this.compaction;
    }

    @Nullable
    public List<String> getGeoReplication() {
        return this.geoReplication;
    }

    @Nullable
    public PulsarChannelRetentionDefinition getRetention() {
        return this.retention;
    }

    @Nullable
    public Integer getTtl() {
        return this.ttl;
    }

    @Nullable
    public Boolean getDeduplication() {
        return this.deduplication;
    }

    @Nullable
    public String getBindingVersion() {
        return this.bindingVersion;
    }

    @JsonProperty(value="namespace")
    public void setNamespace(@org.jetbrains.annotations.NotNull String namespace) {
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
        this.namespace = namespace;
    }

    @JsonProperty(value="persistence", defaultValue="persistent")
    public void setPersistence(@org.jetbrains.annotations.NotNull PulsarChannelPersistence persistence) {
        if (persistence == null) {
            throw new NullPointerException("persistence is marked non-null but is null");
        }
        this.persistence = persistence;
    }

    @JsonProperty(value="compaction")
    public void setCompaction(@Nullable Integer compaction) {
        this.compaction = compaction;
    }

    @JsonProperty(value="geo-replication")
    public void setGeoReplication(@Nullable List<String> geoReplication) {
        this.geoReplication = geoReplication;
    }

    @JsonProperty(value="retention")
    public void setRetention(@Nullable PulsarChannelRetentionDefinition retention) {
        this.retention = retention;
    }

    @JsonProperty(value="ttl")
    public void setTtl(@Nullable Integer ttl) {
        this.ttl = ttl;
    }

    @JsonProperty(value="deduplication")
    public void setDeduplication(@Nullable Boolean deduplication) {
        this.deduplication = deduplication;
    }

    @JsonProperty(value="bindingVersion")
    public void setBindingVersion(@Nullable String bindingVersion) {
        this.bindingVersion = bindingVersion;
    }

    @Override
    public String toString() {
        return "PulsarChannelBinding(namespace=" + this.getNamespace() + ", persistence=" + (Object)((Object)this.getPersistence()) + ", compaction=" + this.getCompaction() + ", geoReplication=" + this.getGeoReplication() + ", retention=" + this.getRetention() + ", ttl=" + this.getTtl() + ", deduplication=" + this.getDeduplication() + ", bindingVersion=" + this.getBindingVersion() + ")";
    }

    public PulsarChannelBinding() {
        this.namespace = PulsarChannelBinding.$default$namespace();
        this.persistence = PulsarChannelBinding.$default$persistence();
        this.bindingVersion = PulsarChannelBinding.$default$bindingVersion();
    }

    public PulsarChannelBinding(@org.jetbrains.annotations.NotNull String namespace, @org.jetbrains.annotations.NotNull PulsarChannelPersistence persistence, @Nullable Integer compaction, @Nullable List<String> geoReplication, @Nullable PulsarChannelRetentionDefinition retention, @Nullable Integer ttl, @Nullable Boolean deduplication, @Nullable String bindingVersion) {
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
        if (persistence == null) {
            throw new NullPointerException("persistence is marked non-null but is null");
        }
        this.namespace = namespace;
        this.persistence = persistence;
        this.compaction = compaction;
        this.geoReplication = geoReplication;
        this.retention = retention;
        this.ttl = ttl;
        this.deduplication = deduplication;
        this.bindingVersion = bindingVersion;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PulsarChannelBinding)) {
            return false;
        }
        PulsarChannelBinding other = (PulsarChannelBinding)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        PulsarChannelPersistence this$persistence = this.getPersistence();
        PulsarChannelPersistence other$persistence = other.getPersistence();
        if (this$persistence == null ? other$persistence != null : !((Object)((Object)this$persistence)).equals((Object)other$persistence)) {
            return false;
        }
        Integer this$compaction = this.getCompaction();
        Integer other$compaction = other.getCompaction();
        if (this$compaction == null ? other$compaction != null : !((Object)this$compaction).equals(other$compaction)) {
            return false;
        }
        List<String> this$geoReplication = this.getGeoReplication();
        List<String> other$geoReplication = other.getGeoReplication();
        if (this$geoReplication == null ? other$geoReplication != null : !((Object)this$geoReplication).equals(other$geoReplication)) {
            return false;
        }
        PulsarChannelRetentionDefinition this$retention = this.getRetention();
        PulsarChannelRetentionDefinition other$retention = other.getRetention();
        if (this$retention == null ? other$retention != null : !((Object)this$retention).equals(other$retention)) {
            return false;
        }
        Integer this$ttl = this.getTtl();
        Integer other$ttl = other.getTtl();
        if (this$ttl == null ? other$ttl != null : !((Object)this$ttl).equals(other$ttl)) {
            return false;
        }
        Boolean this$deduplication = this.getDeduplication();
        Boolean other$deduplication = other.getDeduplication();
        if (this$deduplication == null ? other$deduplication != null : !((Object)this$deduplication).equals(other$deduplication)) {
            return false;
        }
        String this$bindingVersion = this.getBindingVersion();
        String other$bindingVersion = other.getBindingVersion();
        return !(this$bindingVersion == null ? other$bindingVersion != null : !this$bindingVersion.equals(other$bindingVersion));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PulsarChannelBinding;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        PulsarChannelPersistence $persistence = this.getPersistence();
        result = result * 59 + ($persistence == null ? 43 : ((Object)((Object)$persistence)).hashCode());
        Integer $compaction = this.getCompaction();
        result = result * 59 + ($compaction == null ? 43 : ((Object)$compaction).hashCode());
        List<String> $geoReplication = this.getGeoReplication();
        result = result * 59 + ($geoReplication == null ? 43 : ((Object)$geoReplication).hashCode());
        PulsarChannelRetentionDefinition $retention = this.getRetention();
        result = result * 59 + ($retention == null ? 43 : ((Object)$retention).hashCode());
        Integer $ttl = this.getTtl();
        result = result * 59 + ($ttl == null ? 43 : ((Object)$ttl).hashCode());
        Boolean $deduplication = this.getDeduplication();
        result = result * 59 + ($deduplication == null ? 43 : ((Object)$deduplication).hashCode());
        String $bindingVersion = this.getBindingVersion();
        result = result * 59 + ($bindingVersion == null ? 43 : $bindingVersion.hashCode());
        return result;
    }

    public static class PulsarChannelBindingBuilder {
        private boolean namespace$set;
        private String namespace$value;
        private boolean persistence$set;
        private PulsarChannelPersistence persistence$value;
        private Integer compaction;
        private List<String> geoReplication;
        private PulsarChannelRetentionDefinition retention;
        private Integer ttl;
        private Boolean deduplication;
        private boolean bindingVersion$set;
        private String bindingVersion$value;

        PulsarChannelBindingBuilder() {
        }

        @JsonProperty(value="namespace")
        public PulsarChannelBindingBuilder namespace(@org.jetbrains.annotations.NotNull String namespace) {
            this.namespace$value = namespace;
            this.namespace$set = true;
            return this;
        }

        @JsonProperty(value="persistence", defaultValue="persistent")
        public PulsarChannelBindingBuilder persistence(@org.jetbrains.annotations.NotNull PulsarChannelPersistence persistence) {
            this.persistence$value = persistence;
            this.persistence$set = true;
            return this;
        }

        @JsonProperty(value="compaction")
        public PulsarChannelBindingBuilder compaction(@Nullable Integer compaction) {
            this.compaction = compaction;
            return this;
        }

        @JsonProperty(value="geo-replication")
        public PulsarChannelBindingBuilder geoReplication(@Nullable List<String> geoReplication) {
            this.geoReplication = geoReplication;
            return this;
        }

        @JsonProperty(value="retention")
        public PulsarChannelBindingBuilder retention(@Nullable PulsarChannelRetentionDefinition retention) {
            this.retention = retention;
            return this;
        }

        @JsonProperty(value="ttl")
        public PulsarChannelBindingBuilder ttl(@Nullable Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        @JsonProperty(value="deduplication")
        public PulsarChannelBindingBuilder deduplication(@Nullable Boolean deduplication) {
            this.deduplication = deduplication;
            return this;
        }

        @JsonProperty(value="bindingVersion")
        public PulsarChannelBindingBuilder bindingVersion(@Nullable String bindingVersion) {
            this.bindingVersion$value = bindingVersion;
            this.bindingVersion$set = true;
            return this;
        }

        public PulsarChannelBinding build() {
            String namespace$value = this.namespace$value;
            if (!this.namespace$set) {
                namespace$value = PulsarChannelBinding.$default$namespace();
            }
            PulsarChannelPersistence persistence$value = this.persistence$value;
            if (!this.persistence$set) {
                persistence$value = PulsarChannelBinding.$default$persistence();
            }
            String bindingVersion$value = this.bindingVersion$value;
            if (!this.bindingVersion$set) {
                bindingVersion$value = PulsarChannelBinding.$default$bindingVersion();
            }
            return new PulsarChannelBinding(namespace$value, persistence$value, this.compaction, this.geoReplication, this.retention, this.ttl, this.deduplication, bindingVersion$value);
        }

        public String toString() {
            return "PulsarChannelBinding.PulsarChannelBindingBuilder(namespace$value=" + this.namespace$value + ", persistence$value=" + (Object)((Object)this.persistence$value) + ", compaction=" + this.compaction + ", geoReplication=" + this.geoReplication + ", retention=" + this.retention + ", ttl=" + this.ttl + ", deduplication=" + this.deduplication + ", bindingVersion$value=" + this.bindingVersion$value + ")";
        }
    }
}

