/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v3.binding.message.kafka;

import com.asyncapi.v3.binding.message.MessageBinding;
import com.asyncapi.v3.binding.message.kafka.KafkaMessageSchemaIdLocation;
import com.asyncapi.v3.schema.Schema;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import org.jetbrains.annotations.Nullable;

public class KafkaMessageBinding
extends MessageBinding {
    @JsonProperty(value="key")
    @JsonPropertyDescription(value="The message key.")
    @Nullable
    private Schema key;
    @JsonProperty(value="schemaIdLocation")
    @JsonPropertyDescription(value="If a Schema Registry is used when performing this operation, tells where the id of schema is stored (e.g. header or payload).")
    @Nullable
    private KafkaMessageSchemaIdLocation schemaIdLocation;
    @JsonProperty(value="schemaIdPayloadEncoding")
    @JsonPropertyDescription(value="Number of bytes or vendor specific values when schema id is encoded in payload (e.g confluent/ apicurio-legacy / apicurio-new).")
    @Nullable
    private String schemaIdPayloadEncoding;
    @JsonProperty(value="schemaLookupStrategy")
    @JsonPropertyDescription(value="Freeform string for any naming strategy class to use. Clients should default to the vendor default if not supplied.")
    @Nullable
    private String schemaLookupStrategy;
    @JsonProperty(value="bindingVersion")
    @JsonPropertyDescription(value="The version of this binding.")
    @Nullable
    private String bindingVersion;

    private static String $default$bindingVersion() {
        return "0.4.0";
    }

    public static KafkaMessageBindingBuilder builder() {
        return new KafkaMessageBindingBuilder();
    }

    @Nullable
    public Schema getKey() {
        return this.key;
    }

    @Nullable
    public KafkaMessageSchemaIdLocation getSchemaIdLocation() {
        return this.schemaIdLocation;
    }

    @Nullable
    public String getSchemaIdPayloadEncoding() {
        return this.schemaIdPayloadEncoding;
    }

    @Nullable
    public String getSchemaLookupStrategy() {
        return this.schemaLookupStrategy;
    }

    @Nullable
    public String getBindingVersion() {
        return this.bindingVersion;
    }

    @JsonProperty(value="key")
    public void setKey(@Nullable Schema key) {
        this.key = key;
    }

    @JsonProperty(value="schemaIdLocation")
    public void setSchemaIdLocation(@Nullable KafkaMessageSchemaIdLocation schemaIdLocation) {
        this.schemaIdLocation = schemaIdLocation;
    }

    @JsonProperty(value="schemaIdPayloadEncoding")
    public void setSchemaIdPayloadEncoding(@Nullable String schemaIdPayloadEncoding) {
        this.schemaIdPayloadEncoding = schemaIdPayloadEncoding;
    }

    @JsonProperty(value="schemaLookupStrategy")
    public void setSchemaLookupStrategy(@Nullable String schemaLookupStrategy) {
        this.schemaLookupStrategy = schemaLookupStrategy;
    }

    @JsonProperty(value="bindingVersion")
    public void setBindingVersion(@Nullable String bindingVersion) {
        this.bindingVersion = bindingVersion;
    }

    @Override
    public String toString() {
        return "KafkaMessageBinding(key=" + this.getKey() + ", schemaIdLocation=" + (Object)((Object)this.getSchemaIdLocation()) + ", schemaIdPayloadEncoding=" + this.getSchemaIdPayloadEncoding() + ", schemaLookupStrategy=" + this.getSchemaLookupStrategy() + ", bindingVersion=" + this.getBindingVersion() + ")";
    }

    public KafkaMessageBinding() {
        this.bindingVersion = KafkaMessageBinding.$default$bindingVersion();
    }

    public KafkaMessageBinding(@Nullable Schema key, @Nullable KafkaMessageSchemaIdLocation schemaIdLocation, @Nullable String schemaIdPayloadEncoding, @Nullable String schemaLookupStrategy, @Nullable String bindingVersion) {
        this.key = key;
        this.schemaIdLocation = schemaIdLocation;
        this.schemaIdPayloadEncoding = schemaIdPayloadEncoding;
        this.schemaLookupStrategy = schemaLookupStrategy;
        this.bindingVersion = bindingVersion;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaMessageBinding)) {
            return false;
        }
        KafkaMessageBinding other = (KafkaMessageBinding)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Schema this$key = this.getKey();
        Schema other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        KafkaMessageSchemaIdLocation this$schemaIdLocation = this.getSchemaIdLocation();
        KafkaMessageSchemaIdLocation other$schemaIdLocation = other.getSchemaIdLocation();
        if (this$schemaIdLocation == null ? other$schemaIdLocation != null : !((Object)((Object)this$schemaIdLocation)).equals((Object)other$schemaIdLocation)) {
            return false;
        }
        String this$schemaIdPayloadEncoding = this.getSchemaIdPayloadEncoding();
        String other$schemaIdPayloadEncoding = other.getSchemaIdPayloadEncoding();
        if (this$schemaIdPayloadEncoding == null ? other$schemaIdPayloadEncoding != null : !this$schemaIdPayloadEncoding.equals(other$schemaIdPayloadEncoding)) {
            return false;
        }
        String this$schemaLookupStrategy = this.getSchemaLookupStrategy();
        String other$schemaLookupStrategy = other.getSchemaLookupStrategy();
        if (this$schemaLookupStrategy == null ? other$schemaLookupStrategy != null : !this$schemaLookupStrategy.equals(other$schemaLookupStrategy)) {
            return false;
        }
        String this$bindingVersion = this.getBindingVersion();
        String other$bindingVersion = other.getBindingVersion();
        return !(this$bindingVersion == null ? other$bindingVersion != null : !this$bindingVersion.equals(other$bindingVersion));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaMessageBinding;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Schema $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        KafkaMessageSchemaIdLocation $schemaIdLocation = this.getSchemaIdLocation();
        result = result * 59 + ($schemaIdLocation == null ? 43 : ((Object)((Object)$schemaIdLocation)).hashCode());
        String $schemaIdPayloadEncoding = this.getSchemaIdPayloadEncoding();
        result = result * 59 + ($schemaIdPayloadEncoding == null ? 43 : $schemaIdPayloadEncoding.hashCode());
        String $schemaLookupStrategy = this.getSchemaLookupStrategy();
        result = result * 59 + ($schemaLookupStrategy == null ? 43 : $schemaLookupStrategy.hashCode());
        String $bindingVersion = this.getBindingVersion();
        result = result * 59 + ($bindingVersion == null ? 43 : $bindingVersion.hashCode());
        return result;
    }

    public static class KafkaMessageBindingBuilder {
        private Schema key;
        private KafkaMessageSchemaIdLocation schemaIdLocation;
        private String schemaIdPayloadEncoding;
        private String schemaLookupStrategy;
        private boolean bindingVersion$set;
        private String bindingVersion$value;

        KafkaMessageBindingBuilder() {
        }

        @JsonProperty(value="key")
        public KafkaMessageBindingBuilder key(@Nullable Schema key) {
            this.key = key;
            return this;
        }

        @JsonProperty(value="schemaIdLocation")
        public KafkaMessageBindingBuilder schemaIdLocation(@Nullable KafkaMessageSchemaIdLocation schemaIdLocation) {
            this.schemaIdLocation = schemaIdLocation;
            return this;
        }

        @JsonProperty(value="schemaIdPayloadEncoding")
        public KafkaMessageBindingBuilder schemaIdPayloadEncoding(@Nullable String schemaIdPayloadEncoding) {
            this.schemaIdPayloadEncoding = schemaIdPayloadEncoding;
            return this;
        }

        @JsonProperty(value="schemaLookupStrategy")
        public KafkaMessageBindingBuilder schemaLookupStrategy(@Nullable String schemaLookupStrategy) {
            this.schemaLookupStrategy = schemaLookupStrategy;
            return this;
        }

        @JsonProperty(value="bindingVersion")
        public KafkaMessageBindingBuilder bindingVersion(@Nullable String bindingVersion) {
            this.bindingVersion$value = bindingVersion;
            this.bindingVersion$set = true;
            return this;
        }

        public KafkaMessageBinding build() {
            String bindingVersion$value = this.bindingVersion$value;
            if (!this.bindingVersion$set) {
                bindingVersion$value = KafkaMessageBinding.$default$bindingVersion();
            }
            return new KafkaMessageBinding(this.key, this.schemaIdLocation, this.schemaIdPayloadEncoding, this.schemaLookupStrategy, bindingVersion$value);
        }

        public String toString() {
            return "KafkaMessageBinding.KafkaMessageBindingBuilder(key=" + this.key + ", schemaIdLocation=" + (Object)((Object)this.schemaIdLocation) + ", schemaIdPayloadEncoding=" + this.schemaIdPayloadEncoding + ", schemaLookupStrategy=" + this.schemaLookupStrategy + ", bindingVersion$value=" + this.bindingVersion$value + ")";
        }
    }
}

