/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v3.jackson;

import com.asyncapi.v3.schema.Schema;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SchemaItemsDeserializer
extends JsonDeserializer<Object> {
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ObjectCodec objectCodec = jsonParser.getCodec();
        JsonNode node = (JsonNode)objectCodec.readTree(jsonParser);
        JsonNodeType nodeType = node.getNodeType();
        if (nodeType == JsonNodeType.OBJECT) {
            return this.readAsSchema(node, objectCodec);
        }
        if (nodeType == JsonNodeType.ARRAY) {
            return this.readAsListOfSchemas((ArrayNode)node, objectCodec);
        }
        return this.readAsObject(node, objectCodec);
    }

    private List<Schema> readAsListOfSchemas(ArrayNode arrayNode, ObjectCodec objectCodec) throws IOException {
        ArrayList<Schema> schemaList = new ArrayList<Schema>();
        for (JsonNode childNode : arrayNode) {
            schemaList.add(this.readAsSchema(childNode, objectCodec));
        }
        return schemaList;
    }

    private Schema readAsSchema(JsonNode jsonNode, ObjectCodec objectCodec) throws IOException {
        try (JsonParser parser = jsonNode.traverse(objectCodec);){
            Schema schema = (Schema)parser.readValueAs(Schema.class);
            return schema;
        }
    }

    private Object readAsObject(JsonNode jsonNode, ObjectCodec objectCodec) throws IOException {
        try (JsonParser jsonParser = jsonNode.traverse(objectCodec);){
            Object object = jsonParser.readValueAs(Object.class);
            return object;
        }
    }
}

