/*
 * Decompiled with CFR 0.152.
 */
package com.asyncapi.v2.jackson;

import com.asyncapi.v2.model.Reference;
import com.asyncapi.v2.model.security_scheme.SecurityScheme;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ComponentsSecuritySchemesDeserializer
extends JsonDeserializer<Map<String, Object>> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public Map<String, Object> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectCodec objectCodec = p.getCodec();
        JsonNode node = (JsonNode)objectCodec.readTree(p);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        node.fieldNames().forEachRemaining(fieldName -> {
            try {
                parameters.put((String)fieldName, this.chooseKnownPojo(node.get(fieldName)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return parameters;
    }

    private Object chooseKnownPojo(JsonNode parametersValue) throws IOException {
        if (parametersValue.get("$ref") != null) {
            return this.objectMapper.readValue(parametersValue.toString(), Reference.class);
        }
        return this.objectMapper.readValue(parametersValue.toString(), SecurityScheme.class);
    }
}

